/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.ChannelListener;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.ExitEvent;
import org.jgroups.GetStateEvent;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.SetStateEvent;
import org.jgroups.util.Util;

public class STATE_TRANSFER_Test
extends TestCase {
    public static final String CHANNEL_PROPS = "udp.xml";
    public static final String GROUP_NAME = "jgroups.TEST_GROUP";
    private Coordinator coord;

    public STATE_TRANSFER_Test(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        super.setUp();
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        System.setProperty("org.apache.commons.logging.simplelog.defaultlog", "error");
        this.coord = new Coordinator();
        this.coord.recvLoop();
        this.coord.sendLoop();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.coord.stop();
        this.coord = null;
    }

    public void testBasicStateSync() throws Exception {
        JChannel channel = new JChannel(CHANNEL_PROPS);
        ((Channel)channel).setOpt(3, Boolean.FALSE);
        ((Channel)channel).connect(GROUP_NAME);
        Thread.sleep(1000L);
        boolean join = false;
        join = ((Channel)channel).getState(null, 100000L);
        STATE_TRANSFER_Test.assertTrue((boolean)join);
        int cnt = -1;
        block4: while (true) {
            try {
                Object tmp;
                while (!((tmp = ((Channel)channel).receive(0L)) instanceof ExitEvent)) {
                    if (tmp instanceof SetStateEvent) {
                        cnt = (Integer)Util.objectFromByteBuffer(((SetStateEvent)tmp).getArg());
                        System.err.println("--  SetStateEvent, cnt=" + cnt);
                        continue;
                    }
                    if (!(tmp instanceof Message) || cnt == -1) continue;
                    int msg = (Integer)((Message)tmp).getObject();
                    STATE_TRANSFER_Test.assertEquals((int)cnt, (int)(msg - 1));
                    break block4;
                }
            }
            catch (ChannelNotConnectedException not) {
            }
            catch (ChannelClosedException closed) {
            }
            catch (Exception e) {
                System.err.println(e);
                continue;
            }
            break;
        }
        ((Channel)channel).close();
    }

    public static Test suite() {
        return new TestSuite(STATE_TRANSFER_Test.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)STATE_TRANSFER_Test.suite());
    }

    static class Coordinator
    implements ChannelListener {
        private JChannel channel = new JChannel("udp.xml");
        private int cnt = 0;
        private volatile boolean closed = false;

        protected Coordinator() throws ChannelException {
            this.channel.setOpt(3, Boolean.FALSE);
            this.channel.setOpt(5, Boolean.TRUE);
            this.channel.addChannelListener(this);
            this.channel.connect(STATE_TRANSFER_Test.GROUP_NAME);
        }

        public void channelConnected(Channel channel) {
        }

        public void channelDisconnected(Channel channel) {
        }

        public void channelClosed(Channel channel) {
        }

        public void channelShunned() {
        }

        public void channelReconnected(Address addr) {
        }

        public void recvLoop() throws Exception {
            Thread task = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    while (!Coordinator.this.closed) {
                        try {
                            Object tmp = Coordinator.this.channel.receive(0L);
                            if (tmp instanceof ExitEvent) {
                                System.err.println("-- received EXIT, waiting for ChannelReconnected callback");
                                break;
                            }
                            if (!(tmp instanceof GetStateEvent)) continue;
                            Coordinator coordinator = Coordinator.this;
                            synchronized (coordinator) {
                                System.err.println("--  GetStateEvent, cnt=" + Coordinator.this.cnt);
                                Coordinator.this.channel.returnState(Util.objectToByteBuffer(new Integer(Coordinator.this.cnt)));
                            }
                        }
                        catch (ChannelNotConnectedException not) {
                            break;
                        }
                        catch (ChannelClosedException closed) {
                            break;
                        }
                        catch (Exception e) {
                            System.err.println(e);
                        }
                    }
                }
            });
            task.start();
        }

        public void sendLoop() throws Exception {
            Thread task = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    while (!Coordinator.this.closed) {
                        try {
                            Coordinator coordinator = Coordinator.this;
                            synchronized (coordinator) {
                                Coordinator.this.channel.send(null, null, new Integer(++Coordinator.this.cnt));
                                System.err.println("send cnt=" + Coordinator.this.cnt);
                            }
                            Thread.sleep(1000L);
                        }
                        catch (ChannelNotConnectedException not) {
                            break;
                        }
                        catch (ChannelClosedException closed) {
                            break;
                        }
                        catch (Exception e) {
                            System.err.println(e);
                        }
                    }
                }
            });
            task.start();
        }

        public void stop() {
            this.closed = true;
            this.channel.close();
        }
    }
}

