/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.plugin;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.metadata.PluginMetadataManager;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pc.ContainerService;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.PluginContainerConfiguration;
import org.rhq.core.pc.plugin.PluginEnvironment;
import org.rhq.core.pc.plugin.PluginManager;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;

public class PluginComponentFactory
implements ContainerService {
    private static final Log log = LogFactory.getLog(PluginComponentFactory.class);
    private Map<ResourceType, ResourceDiscoveryComponent> discoveryComponentsCache;

    public ResourceDiscoveryComponent getDiscoveryComponent(ResourceType resourceType) throws PluginContainerException {
        if (resourceType.equals((Object)PluginMetadataManager.TEST_PLATFORM_TYPE)) {
            return null;
        }
        ResourceDiscoveryComponent discoveryComponent = this.discoveryComponentsCache.get(resourceType);
        if (discoveryComponent == null) {
            PluginManager pluginManager = PluginContainer.getInstance().getPluginManager();
            PluginEnvironment pluginEnvironment = pluginManager.getPlugin(resourceType.getPlugin());
            String className = pluginManager.getMetadataManager().getDiscoveryClass(resourceType);
            String typeName = resourceType.getName();
            log.debug((Object)("Creating discovery component [" + className + "] for resource type [" + typeName + "]"));
            discoveryComponent = (ResourceDiscoveryComponent)this.instantiateClass(pluginEnvironment, className);
            this.discoveryComponentsCache.put(resourceType, discoveryComponent);
            log.debug((Object)("Created discovery component [" + className + "] for resource type [" + typeName + "]"));
        }
        return discoveryComponent;
    }

    public ResourceComponent buildResourceComponent(ResourceType resourceType) throws PluginContainerException {
        PluginManager pluginManager = PluginContainer.getInstance().getPluginManager();
        PluginEnvironment pluginEnvironment = pluginManager.getPlugin(resourceType.getPlugin());
        String className = pluginManager.getMetadataManager().getComponentClass(resourceType);
        ResourceComponent component = (ResourceComponent)this.instantiateClass(pluginEnvironment, className);
        log.debug((Object)("Created resource component [" + className + "] of resource type [" + resourceType + "]"));
        return component;
    }

    private Object instantiateClass(PluginEnvironment environment, String className) throws PluginContainerException {
        ClassLoader loader = environment.getPluginClassLoader();
        log.debug((Object)("Loading class: " + className));
        try {
            Class<?> clazz = Class.forName(className, true, loader);
            log.debug((Object)("Loaded class: " + clazz));
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new PluginContainerException("Could not instantiate plugin class [" + className + "] from plugin environment [" + environment + "]", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new PluginContainerException("Could not access plugin class " + className + "] from plugin environment [" + environment + "]", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new PluginContainerException("Could not find plugin class " + className + "] from plugin environment [" + environment + "]", (Throwable)e);
        }
        catch (NullPointerException npe) {
            throw new PluginContainerException("Plugin class was 'null' in plugin environment [" + environment + "]", (Throwable)npe);
        }
    }

    public void initialize() {
        this.discoveryComponentsCache = new HashMap<ResourceType, ResourceDiscoveryComponent>();
    }

    public void shutdown() {
        this.discoveryComponentsCache.clear();
        this.discoveryComponentsCache = null;
    }

    public void setConfiguration(PluginContainerConfiguration configuration) {
    }
}

