/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.DataInputStream;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.jgroups.Address;
import org.jgroups.JChannelFactory;
import org.jgroups.blocks.DistributedHashtable;
import org.jgroups.util.Util;

public class DistributedHashtableTest
implements Runnable {
    DistributedHashtable ht;
    long timeout = 500L;
    volatile Thread thread = null;

    public void start(String props, long timeout) throws Exception {
        this.timeout = timeout;
        this.ht = new DistributedHashtable("HashtableTest", new JChannelFactory(), props, timeout);
    }

    public void eventLoop() throws Exception {
        block10: while (true) {
            System.out.println("[1] Insert [2] Start [3] Stop [4] Delete [5] Size [6] Print [q] Quit");
            int c = System.in.read();
            switch (c) {
                case -1: {
                    continue block10;
                }
                case 49: {
                    this.insertEntries();
                    continue block10;
                }
                case 50: {
                    this.start();
                    continue block10;
                }
                case 51: {
                    this.stop();
                    continue block10;
                }
                case 52: {
                    this.deleteEntries();
                    continue block10;
                }
                case 53: {
                    this.printSize();
                    continue block10;
                }
                case 54: {
                    this.printContents();
                    continue block10;
                }
                case 113: {
                    this.ht.stop();
                    return;
                }
            }
        }
    }

    public void insertEntries() {
        try {
            DataInputStream in = new DataInputStream(System.in);
            Address local = this.ht.getLocalAddress();
            System.out.print("Number of entries: ");
            System.out.flush();
            System.in.skip(System.in.available());
            String line = in.readLine();
            int num = Integer.parseInt(line);
            long start = System.currentTimeMillis();
            for (int i = 0; i < num; ++i) {
                if (i % 100 == 0) {
                    System.out.print(i + " ");
                }
                this.ht.put(local.toString() + '#' + i, new Integer(i));
            }
            long stop = System.currentTimeMillis();
            double num_per_sec = (double)num / ((double)(stop - start) / 1000.0);
            System.out.println("\nInserted " + num + " elements in " + (stop - start) + " ms, size=" + this.ht.size() + " [" + num_per_sec + " / sec]");
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    public void deleteEntries() {
        try {
            DataInputStream in = new DataInputStream(System.in);
            System.out.print("Number of entries: ");
            System.out.flush();
            System.in.skip(System.in.available());
            String line = in.readLine();
            int num = Integer.parseInt(line);
            int i = 0;
            Iterator<Object> it = this.ht.keySet().iterator();
            TreeSet keys = new TreeSet();
            while (i++ < num) {
                try {
                    Object key = it.next();
                    keys.add(key);
                }
                catch (Exception ex) {
                    // empty catch block
                    break;
                }
            }
            long start = System.currentTimeMillis();
            for (Object key : keys) {
                this.ht.remove(key);
            }
            long stop = System.currentTimeMillis();
            double num_per_sec = (double)num / ((double)(stop - start) / 1000.0);
            System.out.println("\nRemoved " + keys.size() + " elements in " + (stop - start) + "ms, size=" + this.ht.size() + " [" + num_per_sec + " / sec]");
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    public void start() {
        if (this.thread == null) {
            this.thread = new Thread((Runnable)this, "Modifier thread");
            this.thread.start();
        }
    }

    public void stop() {
        if (this.thread != null) {
            this.thread = null;
        }
    }

    public void printSize() {
        if (this.ht != null) {
            System.out.println("size=" + this.ht.size());
        }
    }

    public void printContents() {
        Set s = this.ht.keySet();
        TreeSet ss = new TreeSet(s);
        for (Object key : ss) {
            System.out.println(key + " --> " + this.ht.get(key));
        }
    }

    public void run() {
        while (this.thread != null) {
            Util.sleep(this.timeout);
        }
    }

    public static void main(String[] args) {
        long timeout = 500L;
        String props = "udp.xml";
        for (int i = 0; i < args.length; ++i) {
            if ("-help".equals(args[i])) {
                DistributedHashtableTest.help();
                return;
            }
            if ("-props".equals(args[i])) {
                props = args[++i];
                continue;
            }
            if (!"-timeout".equals(args[i])) continue;
            timeout = Long.parseLong(args[++i]);
        }
        try {
            DistributedHashtableTest test = new DistributedHashtableTest();
            test.start(props, timeout);
            test.eventLoop();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    static void help() {
        System.out.println("DistributedHashtableTest [-help] [-props <props>] [-timeout <timeout>]");
    }
}

