/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.common.net.URLTools;
import org.gatein.common.util.MarkupInfo;
import org.gatein.pc.api.ContainerURL;
import org.gatein.pc.api.URLFormat;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.spi.ClientContext;
import org.gatein.pc.api.spi.InstanceContext;
import org.gatein.pc.api.spi.PortalContext;
import org.gatein.pc.api.spi.PortletInvocationContext;
import org.gatein.pc.api.spi.SecurityContext;
import org.gatein.pc.api.spi.ServerContext;
import org.gatein.pc.api.spi.UserContext;
import org.gatein.pc.api.spi.WindowContext;
import org.gatein.pc.portlet.impl.spi.AbstractClientContext;
import org.gatein.pc.portlet.impl.spi.AbstractPortletInvocationContext;
import org.gatein.pc.portlet.impl.spi.AbstractServerContext;
import org.gatein.wsrp.WSRPPortletURL;
import org.gatein.wsrp.WSRPResourceURL;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.producer.WSRPInstanceContext;
import org.gatein.wsrp.servlet.ServletAccess;

class WSRPPortletInvocationContext
extends AbstractPortletInvocationContext
implements PortletInvocationContext {
    private SecurityContext securityContext;
    private PortalContext portalContext;
    private UserContext userContext;
    private WSRPInstanceContext instanceContext;
    private WindowContext windowContext;
    private static final String EQ = "=";
    private static final String AMP = "&amp;";
    private static final String EQ_TRUE = "=true";
    private HttpServletRequest request;
    private HttpServletResponse response;

    public WSRPPortletInvocationContext(MarkupInfo markupInfo, SecurityContext securityContext, PortalContext portalContext, UserContext userContext, WSRPInstanceContext instanceContext, WindowContext windowContext) {
        super(markupInfo);
        this.securityContext = securityContext;
        this.portalContext = portalContext;
        this.userContext = userContext;
        this.instanceContext = instanceContext;
        this.windowContext = windowContext;
        this.request = ServletAccess.getRequest();
        this.response = ServletAccess.getResponse();
    }

    public HttpServletRequest getClientRequest() {
        return this.request;
    }

    public HttpServletResponse getClientResponse() {
        return this.response;
    }

    public String encodeResourceURL(String url) {
        if (url != null && !url.startsWith("wsrp_rewrite?")) {
            url = WSRPUtils.getAbsoluteURLFor((String)url, (boolean)false, (String)URLTools.getServerAddressFrom((HttpServletRequest)this.getClientRequest()));
            url = URLTools.encodeXWWWFormURL((String)url);
            StringBuffer sb = new StringBuffer(url.length() * 2);
            sb.append("wsrp_rewrite?").append("wsrp-urlType").append(EQ).append("resource").append(AMP).append("wsrp-url").append(EQ).append(url).append(AMP).append("wsrp-requiresRewrite").append(EQ_TRUE).append("/wsrp_rewrite");
            return sb.toString();
        }
        return url;
    }

    public String renderURL(ContainerURL containerURL, URLFormat urlFormat) {
        if (containerURL != null) {
            Boolean wantSecureBool = urlFormat.getWantSecure();
            boolean wantSecure = wantSecureBool != null ? wantSecureBool : false;
            WSRPPortletURL url = WSRPPortletURL.create((ContainerURL)containerURL, (boolean)wantSecure);
            if (url instanceof WSRPResourceURL) {
                WSRPResourceURL resourceURL = (WSRPResourceURL)url;
                resourceURL.buildURLWith(this.request, this.instanceContext.getPortletContext());
            }
            return url.toString();
        }
        return null;
    }

    public void contextualize(PortletInvocation invocation) {
        invocation.setClientContext((ClientContext)new AbstractClientContext(this.request));
        invocation.setServerContext((ServerContext)new AbstractServerContext(this.request, this.response));
        invocation.setSecurityContext(this.securityContext);
        invocation.setInstanceContext((InstanceContext)this.instanceContext);
        invocation.setWindowContext(this.windowContext);
        invocation.setPortalContext(this.portalContext);
        invocation.setUserContext(this.userContext);
    }

    WindowContext getWindowContext() {
        return this.windowContext;
    }
}

