/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.clientapi.util.units;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.rhq.core.clientapi.util.ArrayUtil;
import org.rhq.core.clientapi.util.units.FormatSpecifics;
import org.rhq.core.clientapi.util.units.FormattedNumber;
import org.rhq.core.clientapi.util.units.Formatter;
import org.rhq.core.clientapi.util.units.ParseSpecifics;
import org.rhq.core.clientapi.util.units.ScaleConstants;
import org.rhq.core.clientapi.util.units.UnitNumber;
import org.rhq.core.clientapi.util.units.UnitsConstants;
import org.rhq.core.clientapi.util.units.UnitsUtil;

public abstract class BinaryFormatter
implements Formatter {
    private NumberFormat getSpecificFormatter(FormatSpecifics specifics, Locale locale) {
        NumberFormat res = NumberFormat.getInstance(locale);
        if (specifics.getPrecision() == 1) {
            res.setMaximumFractionDigits(100);
            res.setMinimumFractionDigits(0);
        } else {
            res.setMaximumFractionDigits(1);
            res.setMinimumFractionDigits(1);
        }
        return res;
    }

    public FormattedNumber format(UnitNumber val, Locale locale, FormatSpecifics specifics) {
        BigDecimal baseVal = val.getBaseValue();
        ScaleConstants targScale = this.findGoodLookingScale(baseVal);
        double newVal = this.getTargetValue(baseVal, targScale);
        NumberFormat fmt = specifics == null ? UnitsUtil.getNumberFormat(new double[]{newVal}, locale) : this.getSpecificFormatter(specifics, locale);
        return this.createFormattedValue(newVal, targScale, fmt);
    }

    public FormattedNumber[] formatSame(double[] vals, UnitsConstants unitType, ScaleConstants scale, Locale locale, FormatSpecifics specifics) {
        int i;
        FormattedNumber[] res = new FormattedNumber[vals.length];
        if (vals.length == 0) {
            return res;
        }
        double average = ArrayUtil.average(vals);
        UnitNumber tmpNum = new UnitNumber(average, unitType, scale);
        ScaleConstants targScale = this.findGoodLookingScale(tmpNum.getBaseValue());
        double[] newVals = new double[vals.length];
        for (i = 0; i < vals.length; ++i) {
            tmpNum = new UnitNumber(vals[i], unitType, scale);
            newVals[i] = this.getTargetValue(tmpNum.getBaseValue(), targScale);
        }
        NumberFormat fmt = specifics == null ? UnitsUtil.getNumberFormat(newVals, locale) : this.getSpecificFormatter(specifics, locale);
        for (i = 0; i < vals.length; ++i) {
            res[i] = this.createFormattedValue(newVals[i], targScale, fmt);
        }
        return res;
    }

    protected abstract String getTagName();

    protected FormattedNumber createFormattedValue(double value, ScaleConstants scale, NumberFormat fmt) {
        String tag;
        switch (scale) {
            case SCALE_NONE: {
                tag = "";
                break;
            }
            case SCALE_KILO: {
                tag = "K";
                break;
            }
            case SCALE_MEGA: {
                tag = "M";
                break;
            }
            case SCALE_GIGA: {
                tag = "G";
                break;
            }
            case SCALE_TERA: {
                tag = "T";
                break;
            }
            case SCALE_PETA: {
                tag = "P";
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled scale");
            }
        }
        return new FormattedNumber(fmt.format(value), tag + this.getTagName());
    }

    private double getTargetValue(BigDecimal baseVal, ScaleConstants targetScale) {
        BigDecimal modifier = UnitsUtil.FACT_NONE;
        double lateModifier = 1.0;
        switch (targetScale) {
            case SCALE_KILO: {
                lateModifier = 1024.0;
                break;
            }
            case SCALE_MEGA: {
                lateModifier = 1048576.0;
                break;
            }
            case SCALE_GIGA: {
                modifier = UnitsUtil.FACT_MEGA_BIN;
                lateModifier = 1024.0;
                break;
            }
            case SCALE_TERA: {
                modifier = UnitsUtil.FACT_GIGA_BIN;
                lateModifier = 1024.0;
                break;
            }
            case SCALE_PETA: {
                modifier = UnitsUtil.FACT_TERA_BIN;
                lateModifier = 1024.0;
            }
        }
        baseVal = baseVal.divide(modifier, 6);
        return baseVal.doubleValue() / lateModifier;
    }

    private ScaleConstants findGoodLookingScale(BigDecimal val) {
        if (val.compareTo(UnitsUtil.FACT_PETA_BIN) >= 1) {
            return ScaleConstants.SCALE_PETA;
        }
        if (val.compareTo(UnitsUtil.FACT_TERA_BIN) >= 1) {
            return ScaleConstants.SCALE_TERA;
        }
        if (val.compareTo(UnitsUtil.FACT_GIGA_BIN) >= 1) {
            return ScaleConstants.SCALE_GIGA;
        }
        if (val.compareTo(UnitsUtil.FACT_MEGA_BIN) >= 1) {
            return ScaleConstants.SCALE_MEGA;
        }
        if (val.compareTo(UnitsUtil.FACT_KILO_BIN) >= 1) {
            return ScaleConstants.SCALE_KILO;
        }
        return ScaleConstants.SCALE_NONE;
    }

    public BigDecimal getBaseValue(double value, ScaleConstants scale) {
        BigDecimal res = new BigDecimal(value);
        return res.multiply(this.getScaleCoeff(scale));
    }

    public BigDecimal getScaledValue(BigDecimal value, ScaleConstants targScale) {
        return value.divide(this.getScaleCoeff(targScale), 6);
    }

    private BigDecimal getScaleCoeff(ScaleConstants scale) {
        switch (scale) {
            case SCALE_NONE: {
                return UnitsUtil.FACT_NONE;
            }
            case SCALE_KILO: {
                return UnitsUtil.FACT_KILO_BIN;
            }
            case SCALE_MEGA: {
                return UnitsUtil.FACT_MEGA_BIN;
            }
            case SCALE_GIGA: {
                return UnitsUtil.FACT_GIGA_BIN;
            }
            case SCALE_TERA: {
                return UnitsUtil.FACT_TERA_BIN;
            }
            case SCALE_PETA: {
                return UnitsUtil.FACT_PETA_BIN;
            }
        }
        throw new IllegalArgumentException("Value did not have binary based scale");
    }

    protected abstract UnitNumber parseTag(double var1, String var3, int var4, ParseSpecifics var5) throws ParseException;

    public UnitNumber parse(String val, Locale locale, ParseSpecifics specifics) throws ParseException {
        NumberFormat fmt = NumberFormat.getInstance(locale);
        int nonIdx = UnitsUtil.findNonNumberIdx(val, fmt);
        if (nonIdx == -1) {
            throw new ParseException("Number had no units with it", val.length());
        }
        if (nonIdx == 0) {
            throw new ParseException("Invalid number specified", 0);
        }
        double numberPart = fmt.parse(val.substring(0, nonIdx)).doubleValue();
        return this.parseTag(numberPart, val.substring(nonIdx, val.length()).trim(), nonIdx, specifics);
    }
}

