/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.injection.resolution;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import javax.inject.TypeLiteral;
import javax.inject.manager.Bean;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.bean.standard.EventBean;
import org.jboss.webbeans.bean.standard.InstanceBean;
import org.jboss.webbeans.injection.resolution.AnnotatedItemTransformer;
import org.jboss.webbeans.injection.resolution.ResolvableAnnotatedItem;
import org.jboss.webbeans.introspector.AnnotatedItem;
import org.jboss.webbeans.metadata.BindingTypeModel;
import org.jboss.webbeans.metadata.MetaDataCache;
import org.jboss.webbeans.util.ListComparator;
import org.jboss.webbeans.util.collections.ConcurrentCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resolver {
    private static final long serialVersionUID = 1L;
    private static final Class<AnnotatedItem<Object, Object>> ANNOTATED_ITEM_GENERIFIED_WITH_OBJECT_OBJECT = new TypeLiteral<AnnotatedItem<Object, Object>>(){}.getRawType();
    private static final Class<Set<Bean<Object>>> BEAN_SET_GENERIFIED_WITH_OBJECT = new TypeLiteral<Set<Bean<Object>>>(){}.getRawType();
    private static final Class<Set<Bean<?>>> BEAN_SET_GENERIFIED_WITH_WILDCARD = new TypeLiteral<Set<Bean<?>>>(){}.getRawType();
    private ConcurrentCache<ResolvableAnnotatedItem<?, ?>, Set<Bean<?>>> resolvedInjectionPoints;
    private Set<AnnotatedItem<?, ?>> injectionPoints;
    private ConcurrentCache<String, Set<Bean<?>>> resolvedNames;
    private final ManagerImpl manager;
    private final Set<AnnotatedItemTransformer> transformers;

    public Resolver(ManagerImpl manager) {
        this.manager = manager;
        this.injectionPoints = new HashSet();
        this.resolvedInjectionPoints = new ConcurrentCache();
        this.resolvedNames = new ConcurrentCache();
        this.transformers = new HashSet<AnnotatedItemTransformer>();
        this.transformers.add(EventBean.TRANSFORMER);
        this.transformers.add(InstanceBean.TRANSFORMER);
    }

    public void addInjectionPoints(Collection<? extends AnnotatedItem<?, ?>> elements) {
        this.injectionPoints.addAll(elements);
    }

    private <T, S> Set<Bean<T>> registerInjectionPoint(final ResolvableAnnotatedItem<T, S> element) {
        Callable callable = new Callable<Set<Bean<T>>>(){

            @Override
            public Set<Bean<T>> call() throws Exception {
                return Resolver.retainHighestPrecedenceBeans(Resolver.this.getMatchingBeans(element, Resolver.this.manager.getBeans()), Resolver.this.manager.getEnabledDeploymentTypes());
            }
        };
        return (Set)this.resolvedInjectionPoints.putIfAbsent(element, callable);
    }

    public void clear() {
        this.resolvedInjectionPoints = new ConcurrentCache();
        this.resolvedNames = new ConcurrentCache();
    }

    public void resolveInjectionPoints() {
        for (final AnnotatedItem<?, ?> injectable : this.injectionPoints) {
            this.registerInjectionPoint(new ResolvableAnnotatedItem<Object, Object>(){
                private static final long serialVersionUID = 1L;

                @Override
                public AnnotatedItem<Object, Object> delegate() {
                    return (AnnotatedItem)ANNOTATED_ITEM_GENERIFIED_WITH_OBJECT_OBJECT.cast(injectable);
                }
            });
        }
    }

    public <T, S> Set<Bean<T>> get(AnnotatedItem<T, S> key) {
        final AnnotatedItem<T, S> transformedElement = this.transformElement(key);
        Set<Bean<T>> beans = this.registerInjectionPoint(new ResolvableAnnotatedItem<T, S>(){

            @Override
            public AnnotatedItem<T, S> delegate() {
                return transformedElement;
            }
        });
        return Collections.unmodifiableSet(beans);
    }

    private <T, S> AnnotatedItem<T, S> transformElement(AnnotatedItem<T, S> element) {
        for (AnnotatedItemTransformer transformer : this.transformers) {
            element = transformer.transform(element);
        }
        return element;
    }

    public Set<Bean<? extends Object>> get(final String name) {
        return (Set)this.resolvedNames.putIfAbsent(name, new Callable<Set<Bean<?>>>(){

            @Override
            public Set<Bean<? extends Object>> call() throws Exception {
                HashSet beans = new HashSet();
                for (Bean<?> bean : Resolver.this.manager.getBeans()) {
                    if ((bean.getName() != null || name != null) && (bean.getName() == null || !bean.getName().equals(name))) continue;
                    beans.add(bean);
                }
                return this.retainHighestPrecedenceBeans(beans, Resolver.this.manager.getEnabledDeploymentTypes());
            }

            private Set<Bean<?>> retainHighestPrecedenceBeans(Set<Bean<?>> beans, List<Class<? extends Annotation>> enabledDeploymentTypes) {
                return (Set)BEAN_SET_GENERIFIED_WITH_WILDCARD.cast(Resolver.retainHighestPrecedenceBeans((Set)BEAN_SET_GENERIFIED_WITH_OBJECT.cast(beans), enabledDeploymentTypes));
            }
        });
    }

    private static <T> Set<Bean<T>> retainHighestPrecedenceBeans(Set<Bean<T>> beans, List<Class<? extends Annotation>> enabledDeploymentTypes) {
        if (beans.size() > 0) {
            TreeSet<Class<? extends Annotation>> possibleDeploymentTypes = new TreeSet<Class<? extends Annotation>>(new ListComparator<Class<? extends Annotation>>(enabledDeploymentTypes));
            for (Bean<T> bean : beans) {
                possibleDeploymentTypes.add(bean.getDeploymentType());
            }
            possibleDeploymentTypes.retainAll(enabledDeploymentTypes);
            HashSet<Bean<T>> trimmed = new HashSet<Bean<T>>();
            if (possibleDeploymentTypes.size() > 0) {
                Class highestPrecedencePossibleDeploymentType = (Class)possibleDeploymentTypes.last();
                for (Bean<T> bean : beans) {
                    if (!bean.getDeploymentType().equals(highestPrecedencePossibleDeploymentType)) continue;
                    trimmed.add(bean);
                }
            }
            return trimmed;
        }
        return beans;
    }

    private <T> Set<Bean<T>> getMatchingBeans(AnnotatedItem<T, ?> element, List<Bean<?>> beans) {
        HashSet<Bean<T>> resolvedBeans = new HashSet<Bean<T>>();
        for (Bean<?> bean : beans) {
            if (!element.isAssignableFrom(bean.getTypes()) || !this.containsAllBindings(element, bean.getBindings())) continue;
            Bean<?> b = bean;
            resolvedBeans.add(b);
        }
        return resolvedBeans;
    }

    private boolean containsAllBindings(AnnotatedItem<?, ?> element, Set<Annotation> bindings) {
        for (Annotation binding : element.getBindings()) {
            BindingTypeModel<? extends Annotation> bindingType = ((MetaDataCache)this.manager.getServices().get(MetaDataCache.class)).getBindingTypeModel(binding.annotationType());
            if (bindingType.getNonBindingTypes().size() > 0) {
                boolean matchFound = false;
                for (Annotation otherBinding : bindings) {
                    if (!bindingType.isEqual(binding, otherBinding)) continue;
                    matchFound = true;
                }
                if (matchFound) continue;
                return false;
            }
            if (bindings.contains(binding)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Resolver\n");
        buffer.append("Injection points: " + this.injectionPoints.size() + "\n");
        buffer.append("Resolved injection points: " + this.resolvedInjectionPoints.size() + "\n");
        buffer.append("Resolved names points: " + this.resolvedNames.size() + "\n");
        return buffer.toString();
    }
}

