/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.introspector.jlr;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.webbeans.introspector.AnnotatedClass;
import org.jboss.webbeans.introspector.AnnotatedConstructor;
import org.jboss.webbeans.introspector.AnnotatedField;
import org.jboss.webbeans.introspector.AnnotatedMethod;
import org.jboss.webbeans.introspector.AnnotationStore;
import org.jboss.webbeans.introspector.ConstructorSignature;
import org.jboss.webbeans.introspector.MethodSignature;
import org.jboss.webbeans.introspector.jlr.AbstractAnnotatedType;
import org.jboss.webbeans.introspector.jlr.AnnotatedConstructorImpl;
import org.jboss.webbeans.introspector.jlr.AnnotatedFieldImpl;
import org.jboss.webbeans.introspector.jlr.AnnotatedMethodImpl;
import org.jboss.webbeans.resources.ClassTransformer;
import org.jboss.webbeans.util.Names;
import org.jboss.webbeans.util.Reflections;
import org.jboss.webbeans.util.collections.multi.SetHashMultiMap;
import org.jboss.webbeans.util.collections.multi.SetMultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedClassImpl<T>
extends AbstractAnnotatedType<T>
implements AnnotatedClass<T> {
    private static List<Class<?>> NO_ARGUMENTS = Collections.emptyList();
    private final Set<AnnotatedField<?>> fields = new HashSet();
    private final SetMultiMap<Class<? extends Annotation>, AnnotatedField<?>> annotatedFields = new SetHashMultiMap();
    private final SetMultiMap<Class<? extends Annotation>, AnnotatedField<?>> metaAnnotatedFields = new SetHashMultiMap();
    private final Set<AnnotatedField<?>> declaredFields = new HashSet();
    private final Map<String, AnnotatedField<?>> declaredFieldsByName = new HashMap();
    private final SetMultiMap<Class<? extends Annotation>, AnnotatedField<?>> declaredAnnotatedFields = new SetHashMultiMap();
    private final SetMultiMap<Class<? extends Annotation>, AnnotatedField<?>> declaredMetaAnnotatedFields = new SetHashMultiMap();
    private final Set<AnnotatedMethod<?>> methods;
    private final Map<MethodSignature, AnnotatedMethod<?>> declaredMethodsBySignature;
    private final SetMultiMap<Class<? extends Annotation>, AnnotatedMethod<?>> annotatedMethods;
    private final SetMultiMap<Class<? extends Annotation>, AnnotatedMethod<?>> methodsByAnnotatedParameters;
    private final Set<AnnotatedMethod<?>> declaredMethods;
    private final SetMultiMap<Class<? extends Annotation>, AnnotatedMethod<?>> declaredAnnotatedMethods;
    private final SetMultiMap<Class<? extends Annotation>, AnnotatedMethod<?>> declaredMethodsByAnnotatedParameters;
    private final Set<AnnotatedConstructor<T>> constructors;
    private final Map<ConstructorSignature, AnnotatedConstructor<?>> declaredConstructorsBySignature;
    private final SetMultiMap<Class<? extends Annotation>, AnnotatedConstructor<T>> annotatedConstructors;
    private final Map<List<Class<?>>, AnnotatedConstructor<T>> constructorsByArgumentMap;
    private String toString;
    private final boolean _nonStaticMemberClass;
    private final boolean _abstract;
    private final boolean _enum;

    public static <T> AnnotatedClass<T> of(Class<T> clazz, ClassTransformer classTransformer) {
        return new AnnotatedClassImpl<T>(clazz, clazz, clazz.getAnnotations(), clazz.getDeclaredAnnotations(), classTransformer);
    }

    private AnnotatedClassImpl(Class<T> rawType, Type type, Annotation[] annotations, Annotation[] declaredAnnotations, ClassTransformer classTransformer) {
        super(AnnotationStore.of(annotations, declaredAnnotations), rawType, type, classTransformer);
        Class<T> c;
        this._nonStaticMemberClass = Reflections.isNonMemberInnerClass(rawType);
        this._abstract = Reflections.isAbstract(rawType);
        this._enum = rawType.isEnum();
        for (c = rawType; c != Object.class && c != null; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                AnnotatedFieldImpl annotatedField = new AnnotatedFieldImpl(field, this);
                this.fields.add(annotatedField);
                if (c == rawType) {
                    this.declaredFields.add(annotatedField);
                    this.declaredFieldsByName.put(annotatedField.getName(), annotatedField);
                }
                for (Annotation annotation : annotatedField.getAnnotationsAsSet()) {
                    this.annotatedFields.put(annotation.annotationType(), annotatedField);
                    if (c == rawType) {
                        this.declaredAnnotatedFields.put(annotation.annotationType(), annotatedField);
                    }
                    for (Annotation metaAnnotation : annotation.annotationType().getAnnotations()) {
                        this.metaAnnotatedFields.put(metaAnnotation.annotationType(), annotatedField);
                        if (c != rawType) continue;
                        this.declaredMetaAnnotatedFields.put(metaAnnotation.annotationType(), annotatedField);
                    }
                }
            }
        }
        this.constructors = new HashSet<AnnotatedConstructor<T>>();
        this.constructorsByArgumentMap = new HashMap();
        this.annotatedConstructors = new SetHashMultiMap<Class<? extends Annotation>, AnnotatedConstructor<T>>();
        this.declaredConstructorsBySignature = new HashMap();
        Constructor<?>[] arr$ = rawType.getDeclaredConstructors();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Constructor<?> constructor;
            Constructor<?> c2 = constructor = arr$[i$];
            AnnotatedConstructor<?> annotatedConstructor = AnnotatedConstructorImpl.of(c2, this);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            this.constructors.add(annotatedConstructor);
            this.constructorsByArgumentMap.put(Arrays.asList(constructor.getParameterTypes()), annotatedConstructor);
            this.declaredConstructorsBySignature.put(annotatedConstructor.getSignature(), annotatedConstructor);
            for (Annotation annotation : annotatedConstructor.getAnnotationsAsSet()) {
                if (!this.annotatedConstructors.containsKey(annotation.annotationType())) {
                    this.annotatedConstructors.put((Class<Annotation>)annotation.annotationType(), (AnnotatedConstructor<T>)((Object)new HashSet()));
                }
                ((Set)this.annotatedConstructors.get(annotation.annotationType())).add(annotatedConstructor);
            }
        }
        this.methods = new HashSet();
        this.annotatedMethods = new SetHashMultiMap();
        this.methodsByAnnotatedParameters = new SetHashMultiMap();
        this.declaredMethods = new HashSet();
        this.declaredAnnotatedMethods = new SetHashMultiMap();
        this.declaredMethodsByAnnotatedParameters = new SetHashMultiMap();
        this.declaredMethodsBySignature = new HashMap();
        for (c = rawType; c != Object.class && c != null; c = c.getSuperclass()) {
            for (Method method : c.getDeclaredMethods()) {
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                AnnotatedMethodImpl annotatedMethod = AnnotatedMethodImpl.of(method, this);
                this.methods.add(annotatedMethod);
                if (c == rawType) {
                    this.declaredMethods.add(annotatedMethod);
                    this.declaredMethodsBySignature.put(annotatedMethod.getSignature(), annotatedMethod);
                }
                for (Annotation annotation : annotatedMethod.getAnnotationsAsSet()) {
                    this.annotatedMethods.put(annotation.annotationType(), annotatedMethod);
                    if (c != rawType) continue;
                    this.declaredAnnotatedMethods.put(annotation.annotationType(), annotatedMethod);
                }
                for (Class clazz : AnnotatedMethod.MAPPED_PARAMETER_ANNOTATIONS) {
                    if (annotatedMethod.getAnnotatedParameters(clazz).size() <= 0) continue;
                    this.methodsByAnnotatedParameters.put(clazz, annotatedMethod);
                    if (c != rawType) continue;
                    this.declaredMethodsByAnnotatedParameters.put(clazz, annotatedMethod);
                }
            }
        }
    }

    public Class<? extends T> getAnnotatedClass() {
        return this.getRawType();
    }

    @Override
    public Class<T> getDelegate() {
        return this.getRawType();
    }

    @Override
    public Set<AnnotatedField<?>> getFields() {
        return Collections.unmodifiableSet(this.fields);
    }

    public Set<AnnotatedField<?>> getDeclaredFields() {
        return Collections.unmodifiableSet(this.declaredFields);
    }

    @Override
    public <F> AnnotatedField<F> getDeclaredField(String fieldName, AnnotatedClass<F> expectedType) {
        return this.declaredFieldsByName.get(fieldName);
    }

    @Override
    public Set<AnnotatedField<?>> getDeclaredAnnotatedFields(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet((Set)this.declaredAnnotatedFields.get(annotationType));
    }

    @Override
    public Set<AnnotatedConstructor<T>> getConstructors() {
        return Collections.unmodifiableSet(this.constructors);
    }

    @Override
    public AnnotatedConstructor<T> getDeclaredConstructor(ConstructorSignature signature) {
        return this.declaredConstructorsBySignature.get(signature);
    }

    @Override
    public Set<AnnotatedField<?>> getMetaAnnotatedFields(Class<? extends Annotation> metaAnnotationType) {
        return Collections.unmodifiableSet((Set)this.metaAnnotatedFields.get(metaAnnotationType));
    }

    @Override
    public Set<AnnotatedField<?>> getAnnotatedFields(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet((Set)this.annotatedFields.get(annotationType));
    }

    @Override
    public boolean isNonStaticMemberClass() {
        return this._nonStaticMemberClass;
    }

    @Override
    public boolean isAbstract() {
        return this._abstract;
    }

    @Override
    public boolean isEnum() {
        return this._enum;
    }

    @Override
    public Set<AnnotatedMethod<?>> getAnnotatedMethods(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet((Set)this.annotatedMethods.get(annotationType));
    }

    @Override
    public Set<AnnotatedMethod<?>> getDeclaredAnnotatedMethods(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet((Set)this.declaredAnnotatedMethods.get(annotationType));
    }

    @Override
    public Set<AnnotatedConstructor<T>> getAnnotatedConstructors(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet((Set)this.annotatedConstructors.get(annotationType));
    }

    @Override
    public AnnotatedConstructor<T> getNoArgsConstructor() {
        return this.constructorsByArgumentMap.get(NO_ARGUMENTS);
    }

    @Override
    public Set<AnnotatedMethod<?>> getMethodsWithAnnotatedParameters(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet((Set)this.methodsByAnnotatedParameters.get(annotationType));
    }

    @Override
    public Set<AnnotatedMethod<?>> getDeclaredMethodsWithAnnotatedParameters(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet((Set)this.declaredMethodsByAnnotatedParameters.get(annotationType));
    }

    @Override
    public AnnotatedMethod<?> getMethod(Method methodDescriptor) {
        for (AnnotatedMethod<?> annotatedMethod : this.methods) {
            if (!annotatedMethod.getName().equals(methodDescriptor.getName()) || !Arrays.equals(annotatedMethod.getParameterTypesAsArray(), methodDescriptor.getParameterTypes())) continue;
            return annotatedMethod;
        }
        return null;
    }

    @Override
    public AnnotatedMethod<?> getDeclaredMethod(Method method) {
        for (AnnotatedMethod<?> annotatedMethod : this.declaredMethods) {
            if (!annotatedMethod.getName().equals(method.getName()) || !Arrays.equals(annotatedMethod.getParameterTypesAsArray(), method.getParameterTypes())) continue;
            return annotatedMethod;
        }
        return null;
    }

    @Override
    public <M> AnnotatedMethod<M> getDeclaredMethod(MethodSignature signature, AnnotatedClass<M> expectedReturnType) {
        return this.declaredMethodsBySignature.get(signature);
    }

    @Override
    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        this.toString = "Annotated class " + Names.classToString(this.getDelegate());
        return this.toString;
    }

    @Override
    public <U> AnnotatedClass<? extends U> asSubclass(AnnotatedClass<U> clazz) {
        return this;
    }

    @Override
    public T cast(Object object) {
        return (T)object;
    }
}

