/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.jcr.info;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.nodetype.NodeType;
import org.chromattic.core.jcr.info.NodeTypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimaryTypeInfo
extends NodeTypeInfo {
    private Set<String> mixinNames;
    private final Set<NodeTypeInfo> superTypes;
    private final Map<String, NodeTypeInfo> superTypesMap;

    public PrimaryTypeInfo(NodeType nodeType, Set<NodeTypeInfo> superTypes) {
        super(nodeType);
        if (nodeType.isMixin()) {
            throw new IllegalArgumentException();
        }
        HashSet<String> mixinNames = new HashSet<String>();
        for (NodeType superType : nodeType.getSupertypes()) {
            if (!superType.isMixin()) continue;
            mixinNames.add(superType.getName());
        }
        HashMap<String, NodeTypeInfo> superTypesMap = new HashMap<String, NodeTypeInfo>();
        for (NodeTypeInfo superType : superTypes) {
            superTypesMap.put(superType.getName(), superType);
        }
        this.mixinNames = Collections.unmodifiableSet(mixinNames);
        this.superTypes = superTypes;
        this.superTypesMap = Collections.unmodifiableMap(superTypesMap);
    }

    public Set<String> getSuperTypeNames() {
        return this.superTypesMap.keySet();
    }

    public NodeTypeInfo getSuperType(String name) {
        return this.superTypesMap.get(name);
    }

    public Set<NodeTypeInfo> getSuperTypes() {
        return this.superTypes;
    }

    public Set<String> getMixinNames() {
        return this.mixinNames;
    }
}

