/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.resolver;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.exoplatform.resolver.ResourceKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResourceResolver {
    public abstract URL getResource(String var1) throws Exception;

    public abstract InputStream getInputStream(String var1) throws Exception;

    public abstract List<URL> getResources(String var1) throws Exception;

    public abstract List<InputStream> getInputStreams(String var1) throws Exception;

    public String getWebAccessPath(String url) {
        throw new RuntimeException("This method is not supported");
    }

    public abstract String getResourceScheme();

    public String getRealPath(String url) {
        throw new RuntimeException("unsupported method");
    }

    public ResourceKey createResourceKey(String url) {
        return new ResourceKey(this.hashCode(), url);
    }

    public String createResourceId(String url) {
        return this.hashCode() + ":" + url;
    }

    public boolean isResolvable(String url) {
        return url.startsWith(this.getResourceScheme());
    }

    public byte[] getResourceContentAsBytes(String url) throws Exception {
        InputStream is = this.getInputStream(url);
        BufferedInputStream buffer = new BufferedInputStream(is);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] data = new byte[buffer.available()];
        int available = -1;
        while ((available = buffer.read(data)) > -1) {
            output.write(data, 0, available);
        }
        return output.toByteArray();
    }

    public abstract boolean isModified(String var1, long var2);

    protected String removeScheme(String url) {
        String scheme = this.getResourceScheme();
        if (url.startsWith(scheme)) {
            return url.substring(scheme.length());
        }
        return url;
    }
}

