/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.portal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.InitParams;
import org.exoplatform.webui.config.Param;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.config.annotation.ParamConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.model.SelectItemCategory;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="system:/groovy/portal/webui/container/UIContainerList.gtmpl", events={@EventConfig(listeners={SelectCategoryActionListener.class})}, initParams={@ParamConfig(name="ContainerConfigOption", value="system:/WEB-INF/conf/uiconf/portal/webui/container/ContainerConfigOption.groovy")})
public class UIContainerList
extends UIContainer {
    private List<SelectItemCategory> categories_;
    private SelectItemCategory selectedCategory_ = null;

    public UIContainerList(InitParams initParams) throws Exception {
        if (initParams == null) {
            return;
        }
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Param param = initParams.getParam("ContainerConfigOption");
        this.categories_ = (List)param.getMapGroovyObject(context);
        if (this.categories_ == null) {
            return;
        }
        this.setSelectedCategory(this.categories_.get(0));
    }

    public void setSelectedCategory(SelectItemCategory selectedCategory) {
        this.selectedCategory_ = selectedCategory;
    }

    public void setSelectedCategory(String name) {
        for (SelectItemCategory itemCategory : this.categories_) {
            if (!itemCategory.getName().equals(name)) continue;
            this.selectedCategory_ = itemCategory;
            return;
        }
    }

    public SelectItemCategory getSelectedCategory() {
        return this.selectedCategory_;
    }

    public List<SelectItemCategory> getCategories() {
        return this.categories_;
    }

    public void setCategories(List<SelectItemCategory> categories) {
        this.categories_ = categories;
    }

    public Container getContainer(String id) throws Exception {
        for (SelectItemCategory category : this.categories_) {
            List items = category.getSelectItemOptions();
            for (SelectItemOption item : items) {
                if (!item.getLabel().equals(id)) continue;
                return this.toContainer(item.getValue().toString());
            }
        }
        return null;
    }

    private Container toContainer(String xml) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());
        IBindingFactory bfact = BindingDirectory.getFactory(Container.class);
        IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
        return (Container)uctx.unmarshalDocument((InputStream)is, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectCategoryActionListener
    extends EventListener<UIContainerList> {
        public void execute(Event<UIContainerList> event) throws Exception {
            String category = event.getRequestContext().getRequestParameter("objectId");
            UIContainerList uiContainerList = (UIContainerList)((Object)event.getSource());
            uiContainerList.setSelectedCategory(category);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiContainerList);
        }
    }
}

