/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.subject;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.authc.AuthenticationException;
import org.jsecurity.authc.AuthenticationToken;
import org.jsecurity.authc.InetAuthenticationToken;
import org.jsecurity.authz.AuthorizationException;
import org.jsecurity.authz.Permission;
import org.jsecurity.authz.UnauthenticatedException;
import org.jsecurity.mgt.SecurityManager;
import org.jsecurity.session.InvalidSessionException;
import org.jsecurity.session.ProxiedSession;
import org.jsecurity.session.Session;
import org.jsecurity.subject.PrincipalCollection;
import org.jsecurity.subject.SimplePrincipalCollection;
import org.jsecurity.subject.Subject;
import org.jsecurity.util.ThreadContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingSubject
implements Subject {
    private static final Log log = LogFactory.getLog(DelegatingSubject.class);
    protected PrincipalCollection principals = new SimplePrincipalCollection();
    protected boolean authenticated = false;
    protected InetAddress inetAddress = null;
    protected Session session = null;
    protected SecurityManager securityManager;

    protected static InetAddress getLocalHost() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public DelegatingSubject(SecurityManager securityManager) {
        this(null, false, DelegatingSubject.getLocalHost(), null, securityManager);
    }

    public DelegatingSubject(PrincipalCollection principals, boolean authenticated, InetAddress inetAddress, Session session, SecurityManager securityManager) {
        if (securityManager == null) {
            throw new IllegalArgumentException("SecurityManager argument cannot be null.");
        }
        this.securityManager = securityManager;
        this.principals = principals;
        this.authenticated = authenticated;
        this.inetAddress = inetAddress != null ? inetAddress : DelegatingSubject.getLocalHost();
        if (session != null) {
            this.session = new StoppingAwareProxiedSession(session, this);
        }
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    protected boolean hasPrincipals() {
        PrincipalCollection pc = this.getPrincipals();
        return pc != null && !pc.isEmpty();
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    @Override
    public Object getPrincipal() {
        PrincipalCollection principals = this.getPrincipals();
        if (principals == null || principals.isEmpty()) {
            return null;
        }
        return principals.asSet().iterator().next();
    }

    @Override
    public PrincipalCollection getPrincipals() {
        return this.principals;
    }

    @Override
    public boolean isPermitted(String permission) {
        return this.hasPrincipals() && this.securityManager.isPermitted(this.getPrincipals(), permission);
    }

    @Override
    public boolean isPermitted(Permission permission) {
        return this.hasPrincipals() && this.securityManager.isPermitted(this.getPrincipals(), permission);
    }

    @Override
    public boolean[] isPermitted(String ... permissions) {
        if (this.hasPrincipals()) {
            return this.securityManager.isPermitted(this.getPrincipals(), permissions);
        }
        return new boolean[permissions.length];
    }

    @Override
    public boolean[] isPermitted(List<Permission> permissions) {
        if (this.hasPrincipals()) {
            return this.securityManager.isPermitted(this.getPrincipals(), permissions);
        }
        return new boolean[permissions.size()];
    }

    @Override
    public boolean isPermittedAll(String ... permissions) {
        return this.hasPrincipals() && this.securityManager.isPermittedAll(this.getPrincipals(), permissions);
    }

    @Override
    public boolean isPermittedAll(Collection<Permission> permissions) {
        return this.hasPrincipals() && this.securityManager.isPermittedAll(this.getPrincipals(), permissions);
    }

    protected void assertAuthzCheckPossible() throws AuthorizationException {
        if (!this.hasPrincipals()) {
            String msg = "Identity principals are not associated with this Subject instance - authorization operations require an identity to check against.  A Subject instance will acquire these identifying principals automatically after a successful login is performed be executing " + Subject.class.getName() + ".login(AuthenticationToken) or when 'Remember Me' " + "functionality is enabled.  This exception can also occur when the current Subject has logged out, " + "which relinquishes its identity and essentially makes it anonymous again.  " + "Because an identity is currently not known due to any of these conditions, " + "authorization is denied.";
            throw new UnauthenticatedException(msg);
        }
    }

    @Override
    public void checkPermission(String permission) throws AuthorizationException {
        this.assertAuthzCheckPossible();
        this.securityManager.checkPermission(this.getPrincipals(), permission);
    }

    @Override
    public void checkPermission(Permission permission) throws AuthorizationException {
        this.assertAuthzCheckPossible();
        this.securityManager.checkPermission(this.getPrincipals(), permission);
    }

    @Override
    public void checkPermissions(String ... permissions) throws AuthorizationException {
        this.assertAuthzCheckPossible();
        this.securityManager.checkPermissions(this.getPrincipals(), permissions);
    }

    @Override
    public void checkPermissions(Collection<Permission> permissions) throws AuthorizationException {
        this.assertAuthzCheckPossible();
        this.securityManager.checkPermissions(this.getPrincipals(), permissions);
    }

    @Override
    public boolean hasRole(String roleIdentifier) {
        return this.hasPrincipals() && this.securityManager.hasRole(this.getPrincipals(), roleIdentifier);
    }

    @Override
    public boolean[] hasRoles(List<String> roleIdentifiers) {
        if (this.hasPrincipals()) {
            return this.securityManager.hasRoles(this.getPrincipals(), roleIdentifiers);
        }
        return new boolean[roleIdentifiers.size()];
    }

    @Override
    public boolean hasAllRoles(Collection<String> roleIdentifiers) {
        return this.hasPrincipals() && this.securityManager.hasAllRoles(this.getPrincipals(), roleIdentifiers);
    }

    @Override
    public void checkRole(String role) throws AuthorizationException {
        this.assertAuthzCheckPossible();
        this.securityManager.checkRole(this.getPrincipals(), role);
    }

    @Override
    public void checkRoles(Collection<String> roles) throws AuthorizationException {
        this.assertAuthzCheckPossible();
        this.securityManager.checkRoles(this.getPrincipals(), roles);
    }

    @Override
    public void login(AuthenticationToken token) throws AuthenticationException {
        InetAddress addy;
        Subject authcSecCtx = this.securityManager.login(token);
        PrincipalCollection principals = authcSecCtx.getPrincipals();
        if (principals == null || principals.isEmpty()) {
            String msg = "Principals returned from securityManager.login( token ) returned a null or empty value.  This value must be non null and populated with one or more elements.  Please check the SecurityManager implementation to ensure this happens after a successful login attempt.";
            throw new IllegalStateException(msg);
        }
        this.principals = principals;
        Session session = authcSecCtx.getSession(false);
        this.session = session != null ? (session instanceof StoppingAwareProxiedSession ? session : new StoppingAwareProxiedSession(session, this)) : null;
        this.authenticated = true;
        if (token instanceof InetAuthenticationToken && (addy = ((InetAuthenticationToken)token).getInetAddress()) != null) {
            this.inetAddress = addy;
        }
        ThreadContext.bind(this);
    }

    @Override
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    @Override
    public Session getSession() {
        return this.getSession(true);
    }

    @Override
    public Session getSession(boolean create) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("attempting to get session; create = " + create + "; session is null = " + (this.session == null) + "; session has id = " + (this.session != null && this.session.getId() != null)));
        }
        if (this.session == null && create) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("starting session for address [" + this.getInetAddress() + "]"));
            }
            Session target = this.securityManager.start(this.getInetAddress());
            this.session = new StoppingAwareProxiedSession(target, this);
        }
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logout() {
        try {
            this.securityManager.logout(this.getPrincipals());
        }
        finally {
            this.session = null;
            this.principals = null;
            this.authenticated = false;
            this.inetAddress = null;
            this.securityManager = null;
        }
    }

    private void sessionStopped() {
        this.session = null;
    }

    private class StoppingAwareProxiedSession
    extends ProxiedSession {
        private final DelegatingSubject owner;

        private StoppingAwareProxiedSession(Session target, DelegatingSubject owningSubject) {
            super(target);
            this.owner = owningSubject;
        }

        public void stop() throws InvalidSessionException {
            super.stop();
            this.owner.sessionStopped();
        }
    }
}

