/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Channel;
import org.jgroups.ExtendedReceiverAdapter;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.util.BoundedList;
import org.jgroups.util.Util;

public final class ViewDeliveryDemo {
    private static final int SEND = 0;
    private static final int REOPEN = 1;
    private static final int RECONNECT = 2;
    private static Channel channel = null;
    private static final Lock lock = new ReentrantLock();
    private static boolean blocked = false;
    private static final Random random = new Random();
    private static MyReceiver mr = null;
    static String props = "flush-udp.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-props")) {
                System.out.println("ViewDeliveryDemo [-help] [-props <props>]");
                return;
            }
            props = args[++i];
        }
        channel = new JChannel(props);
        mr = new MyReceiver();
        channel.setReceiver(mr);
        channel.setOpt(0, true);
        channel.connect("view_test");
        while (true) {
            switch (random.nextInt(3)) {
                case 0: 
                case 1: {
                    lock.lock();
                    try {
                        if (!blocked) {
                            ViewDeliveryDemo.send();
                            break;
                        }
                        System.out.println("Didn't send any messages because I was blocked");
                        break;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                case 2: {
                    ViewDeliveryDemo.reconnect();
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            Thread.sleep(random.nextInt(2000));
        }
    }

    private static void send() throws Exception {
        int max = random.nextInt(1000);
        System.out.println("Sending " + max + " messages");
        try {
            for (int i = 0; i < max; ++i) {
                channel.send(null, null, channel.getView());
            }
        }
        catch (Throwable t) {
            System.err.println("failed to send messages");
            t.printStackTrace();
        }
    }

    private static void reopen() throws Exception {
        System.out.println("closing and reopening.");
        try {
            channel.close();
            System.out.println("closed");
            Thread.sleep(random.nextInt(5000));
            channel.open();
            channel.connect("view_test");
        }
        catch (Throwable t) {
            System.err.println("failed to reopen the channel");
            t.printStackTrace();
        }
    }

    private static void reconnect() throws Exception {
        System.out.println("disconnecting and reconnecting.");
        try {
            channel.disconnect();
            System.out.println("disconnected");
            Thread.sleep(random.nextInt(5000));
            System.out.println("connecting");
            channel.connect("view_test");
        }
        catch (Throwable t) {
            System.err.println("failed to reconnect channel");
            t.printStackTrace();
        }
    }

    private static class MyReceiver
    extends ExtendedReceiverAdapter
    implements Runnable {
        ViewId my_vid;
        long last_time = System.currentTimeMillis();
        static final long MAX_TIME = 10000L;
        final AtomicInteger count = new AtomicInteger(0);
        final AtomicInteger violations = new AtomicInteger(0);
        final List<String> violations_list = new LinkedList<String>();
        final BoundedList<View> views = new BoundedList(10);

        private MyReceiver() {
            new Thread(this).start();
        }

        public void run() {
            while (true) {
                Util.sleep(10000L);
                StringBuilder sb = new StringBuilder();
                sb.append("==> received " + this.count.get() + " valid msgs, " + this.violations.get() + " violations so far");
                if (this.violations.get() > 0) {
                    sb.append("violations:\n" + this.printViolationsList());
                }
                sb.append("\nlast views:\n").append(this.printViews() + "\n");
                System.out.println(sb);
            }
        }

        private String printViews() {
            StringBuilder sb = new StringBuilder();
            for (View view : this.views) {
                sb.append(view).append("\n");
            }
            return sb.toString();
        }

        public void viewAccepted(View new_view) {
            System.out.println("new_view = " + new_view);
            this.my_vid = new_view.getVid();
            this.views.add(new_view);
        }

        public void receive(Message msg) {
            Object obj = msg.getObject();
            if (obj instanceof View) {
                this.count.incrementAndGet();
                View viewArrived = (View)obj;
                ViewId sent_in_vid = viewArrived.getVid();
                ViewId arrived_in_vid = this.my_vid;
                if (!sent_in_vid.equals(arrived_in_vid) && viewArrived.containsMember(channel.getLocalAddress())) {
                    String tmp = "*** VIOLATION: message sent in view " + sent_in_vid + " received in " + arrived_in_vid + "\n" + "msg: " + msg + ", headers: " + msg.getHeaders();
                    this.violations_list.add(tmp);
                    System.out.println(tmp);
                    this.violations.incrementAndGet();
                }
            } else {
                System.out.println("ERROR: unexpected payload: " + obj);
            }
        }

        private String printViolationsList() {
            StringBuilder sb = new StringBuilder();
            for (String tmp : this.violations_list) {
                sb.append(tmp).append("\n");
            }
            return sb.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void block() {
            System.out.println("block()");
            lock.lock();
            try {
                blocked = true;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unblock() {
            System.out.println("unblock()");
            lock.lock();
            try {
                blocked = false;
            }
            finally {
                lock.unlock();
            }
        }
    }
}

