/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ICUCache;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.OlsonTimeZone;
import com.ibm.icu.impl.SimpleCache;
import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.SimpleTimeZone;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import com.ibm.icu.util.UResourceBundleIterator;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.Vector;

public final class ZoneMeta {
    private static final boolean ASSERT = false;
    private static Map canonicalMap = null;
    private static Set multiZoneTerritories = null;
    public static final String HOUR = "hourFormat";
    public static final String GMT = "gmtFormat";
    public static final String REGION_FORMAT = "regionFormat";
    public static final String FALLBACK_FORMAT = "fallbackFormat";
    public static final String ZONE_STRINGS = "zoneStrings";
    public static final String FORWARD_SLASH = "/";
    private static final String[] EMPTY = new String[0];
    private static final String kREGIONS = "Regions";
    private static final String kZONES = "Zones";
    private static final String kNAMES = "Names";
    private static final String kGMT_ID = "GMT";
    private static final String kRFC_TZ_PREFIX = "GMT";
    private static ICUCache zoneCache = new SimpleCache();
    static int OLSON_ZONE_START = -1;
    static int OLSON_ZONE_COUNT = 0;
    private static final int kMAX_CUSTOM_HOUR = 23;
    private static final int kMAX_CUSTOM_MIN = 59;
    static /* synthetic */ Class class$com$ibm$icu$impl$ZoneMeta;

    public static synchronized String[] getAvailableIDs(String country) {
        if (!ZoneMeta.getOlsonMeta()) {
            return EMPTY;
        }
        try {
            ICUResourceBundle top = (ICUResourceBundle)ICUResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt38b", "zoneinfo", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
            UResourceBundle regions = top.get(kREGIONS);
            UResourceBundle names = top.get(kNAMES);
            UResourceBundle temp = regions.get(country);
            int[] vector = temp.getIntVector();
            String[] ret = new String[vector.length];
            for (int i = 0; i < vector.length; ++i) {
                ret[i] = names.getString(vector[i]);
            }
            return ret;
        }
        catch (MissingResourceException missingResourceException) {
            return EMPTY;
        }
    }

    public static synchronized String[] getAvailableIDs() {
        if (!ZoneMeta.getOlsonMeta()) {
            return EMPTY;
        }
        try {
            ICUResourceBundle top = (ICUResourceBundle)ICUResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt38b", "zoneinfo", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
            UResourceBundle names = top.get(kNAMES);
            return names.getStringArray();
        }
        catch (MissingResourceException missingResourceException) {
            return EMPTY;
        }
    }

    public static synchronized String[] getAvailableIDs(int offset) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < OLSON_ZONE_COUNT; ++i) {
            TimeZone z;
            String unistr = ZoneMeta.getID(i);
            if (unistr == null || (z = TimeZone.getTimeZone(unistr)) == null || !z.getID().equals(unistr) || z.getRawOffset() != offset) continue;
            vector.add(unistr);
        }
        if (!vector.isEmpty()) {
            String[] strings = new String[vector.size()];
            return vector.toArray(strings);
        }
        return EMPTY;
    }

    private static String getID(int i) {
        try {
            ICUResourceBundle top = (ICUResourceBundle)ICUResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt38b", "zoneinfo", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
            UResourceBundle names = top.get(kNAMES);
            return names.getString(i);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public static synchronized int countEquivalentIDs(String id) {
        UResourceBundle res = ZoneMeta.openOlsonResource(id);
        int size = res.getSize();
        if (size == 4 || size == 6) {
            UResourceBundle r = res.get(size - 1);
            int[] v = r.getIntVector();
            return v.length;
        }
        return 0;
    }

    public static synchronized String getEquivalentID(String id, int index) {
        String result = "";
        UResourceBundle res = ZoneMeta.openOlsonResource(id);
        int zone = -1;
        int size = res.getSize();
        if (size == 4 || size == 6) {
            UResourceBundle r = res.get(size - 1);
            int[] v = r.getIntVector();
            if (index >= 0 && index < v.length && ZoneMeta.getOlsonMeta()) {
                zone = v[index];
            }
        }
        if (zone >= 0) {
            UResourceBundle top = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt38b", "zoneinfo", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
            UResourceBundle ares = top.get(kNAMES);
            result = ares.getString(zone);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getCanonicalInfo(String id) {
        if (canonicalMap == null) {
            HashMap<String, String[]> m = new HashMap<String, String[]>();
            HashSet<String> s = new HashSet<String>();
            UResourceBundle supplementalDataBundle = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt38b", "supplementalData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
            UResourceBundle zoneFormatting = supplementalDataBundle.get("zoneFormatting");
            UResourceBundleIterator it = zoneFormatting.getIterator();
            block9: while (it.hasNext()) {
                UResourceBundle temp = it.next();
                int resourceType = temp.getType();
                switch (resourceType) {
                    case 2: {
                        String[] result = new String[]{"", ""};
                        UResourceBundle zoneInfo = temp;
                        String canonicalID = zoneInfo.getKey().replace(':', '/');
                        String territory = zoneInfo.get("territory").getString();
                        result[0] = canonicalID;
                        result[1] = territory.equals("001") ? null : territory;
                        m.put(canonicalID, result);
                        try {
                            UResourceBundle aliasBundle = zoneInfo.get("aliases");
                            String[] aliases = aliasBundle.getStringArray();
                            for (int i = 0; i < aliases.length; ++i) {
                                m.put(aliases[i], result);
                            }
                            continue block9;
                        }
                        catch (MissingResourceException ex) {
                            break;
                        }
                    }
                    case 8: {
                        String[] territoryList = temp.getStringArray();
                        for (int i = 0; i < territoryList.length; ++i) {
                            s.add(territoryList[i]);
                        }
                        break;
                    }
                }
            }
            Class clazz = class$com$ibm$icu$impl$ZoneMeta == null ? (class$com$ibm$icu$impl$ZoneMeta = ZoneMeta.class$("com.ibm.icu.impl.ZoneMeta")) : class$com$ibm$icu$impl$ZoneMeta;
            synchronized (clazz) {
                canonicalMap = m;
                multiZoneTerritories = s;
            }
        }
        return (String[])canonicalMap.get(id);
    }

    public static String getCanonicalID(String tzid) {
        String[] info = ZoneMeta.getCanonicalInfo(tzid);
        if (info != null) {
            return info[0];
        }
        return tzid;
    }

    public static String getCanonicalCountry(String tzid) {
        String[] info = ZoneMeta.getCanonicalInfo(tzid);
        if (info != null) {
            return info[1];
        }
        return null;
    }

    public static String getSingleCountry(String tzid) {
        String[] info = ZoneMeta.getCanonicalInfo(tzid);
        if (info != null && info[1] != null && !multiZoneTerritories.contains(info[1])) {
            return info[1];
        }
        return null;
    }

    public static String displayFallback(String tzid, String city, ULocale locale) {
        String[] info = ZoneMeta.getCanonicalInfo(tzid);
        if (info == null) {
            return null;
        }
        String country_code = info[1];
        if (country_code == null) {
            return null;
        }
        String country = null;
        if (country_code != null) {
            ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt38b", locale);
            ULocale rbloc = rb.getULocale();
            if (!rbloc.equals(ULocale.ROOT) && rbloc.getLanguage().equals(locale.getLanguage())) {
                country = ULocale.getDisplayCountry("xx_" + country_code, locale);
            }
            if (country == null || country.length() == 0) {
                country = country_code;
            }
        }
        if (ZoneMeta.getSingleCountry(tzid) != null) {
            return ZoneMeta.displayRegion(country, locale);
        }
        if (city == null) {
            city = tzid.substring(tzid.lastIndexOf(47) + 1).replace('_', ' ');
        }
        String flbPat = ZoneMeta.getTZLocalizationInfo(locale, FALLBACK_FORMAT);
        MessageFormat mf = new MessageFormat(flbPat);
        return mf.format(new Object[]{city, country});
    }

    public static String displayRegion(String cityOrCountry, ULocale locale) {
        String regPat = ZoneMeta.getTZLocalizationInfo(locale, REGION_FORMAT);
        MessageFormat mf = new MessageFormat(regPat);
        return mf.format(new Object[]{cityOrCountry});
    }

    public static String displayGMT(long value, ULocale locale) {
        String msgpat = "GMT{0}";
        String dtepat = ZoneMeta.getTZLocalizationInfo(locale, HOUR);
        int n = dtepat.indexOf(59);
        if (n != -1) {
            if (value < 0L) {
                value = -value;
                dtepat = dtepat.substring(n + 1);
            } else {
                dtepat = dtepat.substring(0, n);
            }
        }
        SimpleDateFormat sdf = new SimpleDateFormat(dtepat, locale);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        String res = sdf.format(new Long(value));
        MessageFormat mf = new MessageFormat(msgpat);
        res = mf.format(new Object[]{res});
        return res;
    }

    public static String getTZLocalizationInfo(ULocale locale, String format) {
        ICUResourceBundle bundle = (ICUResourceBundle)ICUResourceBundle.getBundleInstance(locale);
        return bundle.getStringWithFallback("zoneStrings/" + format);
    }

    public static UResourceBundle openOlsonResource(String id) {
        if (!ZoneMeta.getOlsonMeta()) {
            return null;
        }
        ICUResourceBundle top = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt38b", "zoneinfo", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        UResourceBundle res = ZoneMeta.getZoneByName(top, id);
        if (res.getSize() <= 1 && ZoneMeta.getOlsonMeta(top)) {
            int deref = res.getInt() + 0;
            UResourceBundle ares = top.get(kZONES);
            res = (ICUResourceBundle)ares.get(deref);
        }
        return res;
    }

    private static UResourceBundle getZoneByName(UResourceBundle top, String id) {
        UResourceBundle tmp = top.get(kNAMES);
        int idx = ZoneMeta.findInStringArray(tmp, id);
        if (idx == -1) {
            throw new MissingResourceException(kNAMES, ((ICUResourceBundle)tmp).getResPath(), id);
        }
        tmp = top.get(kZONES);
        tmp = tmp.get(idx);
        return tmp;
    }

    private static int findInStringArray(UResourceBundle array, String id) {
        int mid;
        int start = 0;
        int limit = array.getSize();
        String u = null;
        int lastMid = Integer.MAX_VALUE;
        if (limit < 1) {
            return -1;
        }
        while (lastMid != (mid = (start + limit) / 2)) {
            lastMid = mid;
            u = array.getString(mid);
            if (u == null) break;
            int r = id.compareTo(u);
            if (r == 0) {
                return mid;
            }
            if (r < 0) {
                limit = mid;
                continue;
            }
            start = mid;
        }
        return -1;
    }

    private static boolean getOlsonMeta(ICUResourceBundle top) {
        if (OLSON_ZONE_START < 0) {
            UResourceBundle res = top.get(kZONES);
            OLSON_ZONE_COUNT = res.getSize();
            OLSON_ZONE_START = 0;
        }
        return OLSON_ZONE_START >= 0;
    }

    private static boolean getOlsonMeta() {
        ICUResourceBundle top = (ICUResourceBundle)ICUResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt38b", "zoneinfo", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        if (OLSON_ZONE_START < 0) {
            ZoneMeta.getOlsonMeta(top);
        }
        return OLSON_ZONE_START >= 0;
    }

    public static TimeZone getSystemTimeZone(String id) {
        TimeZone z = (TimeZone)zoneCache.get(id);
        if (z == null) {
            try {
                UResourceBundle top = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt38b", "zoneinfo", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
                UResourceBundle res = ZoneMeta.openOlsonResource(id);
                z = new OlsonTimeZone(top, res);
                z.setID(id);
                zoneCache.put(id, z);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return (TimeZone)z.clone();
    }

    public static TimeZone getGMT() {
        SimpleTimeZone z = new SimpleTimeZone(0, "GMT");
        ((TimeZone)z).setID("GMT");
        return z;
    }

    public static TimeZone getCustomTimeZone(String id) {
        NumberFormat numberFormat = null;
        String idUppercase = id.toUpperCase();
        if (id.length() > "GMT".length() && idUppercase.startsWith("GMT")) {
            ParsePosition pos = new ParsePosition("GMT".length());
            boolean negative = false;
            int hour = 0;
            int min = 0;
            if (id.charAt(pos.getIndex()) == '-') {
                negative = true;
            } else if (id.charAt(pos.getIndex()) != '+') {
                return null;
            }
            pos.setIndex(pos.getIndex() + 1);
            numberFormat = NumberFormat.getInstance();
            numberFormat.setParseIntegerOnly(true);
            int start = pos.getIndex();
            Number n = numberFormat.parse(id, pos);
            if (pos.getIndex() == start) {
                return null;
            }
            hour = n.intValue();
            if (pos.getIndex() < id.length() && id.charAt(pos.getIndex()) == ':') {
                pos.setIndex(pos.getIndex() + 1);
                int oldPos = pos.getIndex();
                n = numberFormat.parse(id, pos);
                if (pos.getIndex() == oldPos) {
                    return null;
                }
                min = n.intValue();
            } else if (hour > 23 || pos.getIndex() - start > 2) {
                min = hour % 100;
                hour /= 100;
            }
            if (hour > 23 || min > 59) {
                return null;
            }
            StringBuffer zid = new StringBuffer("GMT");
            if (hour != 0 || min != 0) {
                if (negative) {
                    zid.append('-');
                } else {
                    zid.append('+');
                }
                if (hour < 10) {
                    zid.append('0');
                }
                zid.append(hour);
                if (min < 10) {
                    zid.append('0');
                }
                zid.append(min);
            }
            int offset = (hour * 60 + min) * 60 * 1000;
            if (negative) {
                offset = -offset;
            }
            SimpleTimeZone z = new SimpleTimeZone(offset, zid.toString());
            return z;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

