/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.net.vfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.common.net.URLFilter;
import org.gatein.common.net.URLNavigationProvider;
import org.gatein.common.net.URLVisitor;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.plugins.vfs.VirtualFileURLConnection;

public class VFSZipURLNavigationProvider
implements URLNavigationProvider {
    private Logger log = LoggerFactory.getLogger(VFSZipURLNavigationProvider.class);
    private boolean trace = this.log.isDebugEnabled();

    public void visit(URL url, URLVisitor visitor, URLFilter filter) throws IllegalArgumentException, IOException {
        if (url == null) {
            throw new IllegalArgumentException("Null URL not accepted");
        }
        if (!"vfszip".equals(url.getProtocol())) {
            throw new IllegalArgumentException("Only jar URL are accepted, not " + url.getProtocol());
        }
        VirtualFileURLConnection conn = (VirtualFileURLConnection)url.openConnection();
        VirtualFile vFile = conn.getContent();
        this.visit(vFile, visitor, filter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void visit(VirtualFile file, URLVisitor visitor, URLFilter filter) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        String name = file.getName();
        if (!file.isLeaf()) {
            if (this.trace) {
                this.log.debug((Object)("entering directory" + file.getPathName()));
            }
            try {
                URL url = file.toURL();
                if (filter != null) {
                    if (!filter.acceptDir(url)) return;
                }
                boolean bl = true;
                boolean visit = bl;
                if (!visit) return;
                visitor.startDir(url, name);
                for (VirtualFile child : file.getChildren()) {
                    this.visit(child, visitor, filter);
                }
                visitor.endDir(file.toURL(), name);
                if (!this.trace) return;
                this.log.debug((Object)("leaving directory" + file.getPathName()));
                return;
            }
            catch (URISyntaxException e) {
                throw new IOException("Error trying to get Virtual File for " + file.toString() + ". " + e);
            }
        }
        try {
            URL url;
            if (this.trace) {
                this.log.debug((Object)("visiting file " + file.getPathName()));
            }
            if (filter.acceptFile(url = file.toURL())) {
                visitor.file(url, name);
                return;
            } else {
                if (!this.trace) return;
                this.log.debug((Object)"The file does not respect url format");
            }
            return;
        }
        catch (URISyntaxException e) {
            throw new IOException("Error trying to get Virtual File for " + file.toString() + ". " + e);
        }
    }
}

