/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.explorer.UIJcrExplorerEditContainer;
import org.exoplatform.ecm.webui.component.explorer.UIJcrExplorerEditForm;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormSelectBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/explorer/UIDriveSelector.gtmpl", events={@EventConfig(listeners={AddDriveActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UIDriveSelector
extends UIContainer {
    private UIPageIterator uiPageIterator_ = (UIPageIterator)this.addChild(UIPageIterator.class, null, "DriveSelectorList");

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public List getListDrive() throws Exception {
        return this.uiPageIterator_.getCurrentPageData();
    }

    public void updateGrid() throws Exception {
        ObjectPageList objPageList = new ObjectPageList(this.getDrives("repository"), 10);
        this.uiPageIterator_.setPageList((PageList)objPageList);
    }

    public List<DriveData> getDrives(String repoName) throws Exception {
        ManageDriveService driveService = (ManageDriveService)this.getApplicationComponent(ManageDriveService.class);
        List driveList = driveService.getDriveByUserRoles(repoName, Util.getPortalRequestContext().getRemoteUser(), Utils.getMemberships());
        Collections.sort(driveList, new DriveComparator());
        return driveList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddDriveActionListener
    extends EventListener<UIDriveSelector> {
        public void execute(Event<UIDriveSelector> event) throws Exception {
            String driveName = event.getRequestContext().getRequestParameter("objectId");
            UIDriveSelector driveSelector = (UIDriveSelector)((Object)event.getSource());
            UIJcrExplorerEditContainer editContainer = (UIJcrExplorerEditContainer)driveSelector.getAncestorOfType(UIJcrExplorerEditContainer.class);
            UIJcrExplorerEditForm form = (UIJcrExplorerEditForm)editContainer.getChild(UIJcrExplorerEditForm.class);
            UIFormInputSetWithAction driveNameInput = (UIFormInputSetWithAction)form.getChildById("DriveNameInput");
            driveNameInput.getUIStringInput("driveName").setValue((Object)driveName);
            UIComponent uiComponent = driveSelector.getParent();
            UIFormSelectBox typeSelectBox = (UIFormSelectBox)form.getChildById("usecase");
            if ("parameterize".equals(typeSelectBox.getValue())) {
                UIFormInputSetWithAction uiParamPathInput = (UIFormInputSetWithAction)form.getChildById("SelectNodePath");
                uiParamPathInput.setRendered(true);
            }
            if (uiComponent != null && uiComponent instanceof UIPopupWindow) {
                ((UIPopupWindow)uiComponent).setShow(false);
                ((UIPopupWindow)uiComponent).setRendered(false);
                event.getRequestContext().addUIComponentToUpdateByAjax(((UIPopupWindow)uiComponent).getParent());
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIDriveSelector> {
        public void execute(Event<UIDriveSelector> event) throws Exception {
            UIDriveSelector driveSelector = (UIDriveSelector)((Object)event.getSource());
            UIComponent uiComponent = driveSelector.getParent();
            if (uiComponent != null && uiComponent instanceof UIPopupWindow) {
                ((UIPopupWindow)uiComponent).setShow(false);
                ((UIPopupWindow)uiComponent).setRendered(false);
                event.getRequestContext().addUIComponentToUpdateByAjax(((UIPopupWindow)uiComponent).getParent());
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DriveComparator
    implements Comparator<DriveData> {
        @Override
        public int compare(DriveData d1, DriveData d2) throws ClassCastException {
            String name1 = d1.getName();
            String name2 = d2.getName();
            return name1.compareToIgnoreCase(name2);
        }
    }
}

