/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.organization;

import java.util.Date;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl;
import org.exoplatform.services.jcr.ext.organization.JCRUserListAccess;
import org.exoplatform.services.jcr.ext.organization.OrganizationServiceException;
import org.exoplatform.services.jcr.ext.organization.UserHandlerImpl;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;

public class UserByQueryJCRUserListAccess
extends JCRUserListAccess {
    private Query query;
    private UserHandlerImpl uHandler;

    public UserByQueryJCRUserListAccess(JCROrganizationServiceImpl service, Query query) {
        super(service);
        this.query = query;
        this.uHandler = new UserHandlerImpl(service);
    }

    protected int getSize(Session session) throws Exception {
        try {
            int result = 0;
            Node storageNode = (Node)session.getItem(this.service.getStoragePath() + "/" + "exo:users");
            NodeIterator results = storageNode.getNodes();
            while (results.hasNext()) {
                Node uNode = results.nextNode();
                if (!this.checkQuery(uNode)) continue;
                ++result;
            }
            return result;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not get list size", e);
        }
    }

    protected User[] load(Session session, int index, int length) throws Exception {
        if (index < 0) {
            throw new IllegalArgumentException("Illegal index: index must be a positive number");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Illegal length: length must be a positive number");
        }
        try {
            User[] users = new User[length];
            Node storageNode = (Node)session.getItem(this.service.getStoragePath() + "/" + "exo:users");
            NodeIterator results = storageNode.getNodes();
            int p = 0;
            int counter = 0;
            while (counter < length) {
                if (!results.hasNext()) {
                    throw new IllegalArgumentException("Illegal index or length: sum of the index and the length cannot be greater than the list size");
                }
                Node uNode = results.nextNode();
                if (!this.checkQuery(uNode) || p++ < index) continue;
                users[counter++] = this.uHandler.readObjectFromNode(uNode);
            }
            return users;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not load users", e);
        }
    }

    private boolean checkQuery(Node uNode) throws Exception {
        if (this.query.getUserName() != null && !this.isLike(uNode.getName(), this.query.getUserName(), true)) {
            return false;
        }
        if (this.query.getFirstName() != null && !this.isLike(this.uHandler.readStringProperty(uNode, "exo:firstName"), this.query.getFirstName(), true)) {
            return false;
        }
        if (this.query.getLastName() != null && !this.isLike(this.uHandler.readStringProperty(uNode, "exo:lastName"), this.query.getLastName(), true)) {
            return false;
        }
        if (this.query.getEmail() != null && !this.isLike(this.uHandler.readStringProperty(uNode, "exo:email"), this.query.getEmail(), false)) {
            return false;
        }
        Date lastLoginTime = this.uHandler.readDateProperty(uNode, "exo:lastLoginTime");
        if (this.query.getFromLoginDate() != null && this.query.getFromLoginDate().getTime() > lastLoginTime.getTime()) {
            return false;
        }
        return this.query.getToLoginDate() == null || this.query.getToLoginDate().getTime() >= lastLoginTime.getTime();
    }

    private boolean isLike(String jcrField, String queryField, boolean caseSensitive) {
        return caseSensitive ? jcrField.toUpperCase().indexOf(this.removeAsterisk(queryField.toUpperCase())) != -1 : jcrField.indexOf(this.removeAsterisk(queryField)) != -1;
    }

    private String removeAsterisk(String str) {
        if (str.startsWith("*")) {
            str = str.substring(1);
        }
        if (str.endsWith("*")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }
}

