/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.filters;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.Text;

public class RegexFilter
implements NodeFilter {
    public static final int MATCH = 1;
    public static final int LOOKINGAT = 2;
    public static final int FIND = 3;
    protected String mPatternString;
    protected Pattern mPattern;
    protected int mStrategy;

    public RegexFilter() {
        this(".*", 3);
    }

    public RegexFilter(String pattern) {
        this(pattern, 3);
    }

    public RegexFilter(String pattern, int strategy) {
        this.setPattern(pattern);
        this.setStrategy(strategy);
    }

    public String getPattern() {
        return this.mPatternString;
    }

    public void setPattern(String pattern) {
        this.mPatternString = pattern;
        this.mPattern = Pattern.compile(pattern);
    }

    public int getStrategy() {
        return this.mStrategy;
    }

    public void setStrategy(int strategy) {
        if (strategy != 1 && strategy != 2 && strategy != 3) {
            throw new IllegalArgumentException("illegal strategy (" + strategy + ")");
        }
        this.mStrategy = strategy;
    }

    public boolean accept(Node node) {
        boolean ret = false;
        if (node instanceof Text) {
            String string = ((Text)node).getText();
            Matcher matcher = this.mPattern.matcher(string);
            switch (this.mStrategy) {
                case 1: {
                    ret = matcher.matches();
                    break;
                }
                case 2: {
                    ret = matcher.lookingAt();
                    break;
                }
                default: {
                    ret = matcher.find();
                }
            }
        }
        return ret;
    }
}

