/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.navigation.PageNavigationUtils;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.wcm.core.WCMConfigurationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiLinkParser {
    private String dataSource;
    public static final Pattern XWIKI_LINK = Pattern.compile("(\\[)([\\w\\W&&[^\\]]]+)(\\>)([:/\\w\\s\\.]+)(\\])");
    Map<String, String> links = new HashMap<String, String>();

    public WikiLinkParser(String source) {
        this.dataSource = source;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    protected static List<PageNavigation> getNavigations() throws Exception {
        List allNav = Util.getUIPortal().getNavigations();
        String remoteUser = Util.getPortalRequestContext().getRemoteUser();
        ArrayList<PageNavigation> result = new ArrayList<PageNavigation>();
        for (PageNavigation nav : allNav) {
            result.add(PageNavigationUtils.filter((PageNavigation)nav, (String)remoteUser));
        }
        return result;
    }

    private String getBaseURI() {
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        HttpServletRequest servletRequest = portalRequestContext.getRequest();
        String baseURI = servletRequest.getScheme() + "://" + servletRequest.getServerName() + ":" + servletRequest.getServerPort() + portalRequestContext.getPortalURI();
        WCMConfigurationService configurationService = (WCMConfigurationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WCMConfigurationService.class);
        String wikiContext = configurationService.getRuntimeContextParam("createWikiPageURI");
        return baseURI.concat(wikiContext);
    }

    private String generateLink(String uri, String label) throws Exception {
        if (uri == null || uri.trim().length() == 0 || uri.startsWith(".") || uri.endsWith(".")) {
            return "#";
        }
        if (uri.contains("//")) {
            return "<a href=\"" + uri.trim() + "\">" + label + "</a>";
        }
        String temp = uri = uri.replace('.', '/').replace(" ", "");
        String parent = "";
        String newURI = "";
        String correctLink = "";
        List<PageNavigation> navs = WikiLinkParser.getNavigations();
        PageNode pageNode = null;
        for (PageNavigation navigation : navs) {
            pageNode = PageNavigationUtils.searchPageNodeByUri((PageNavigation)navigation, (String)uri);
            while (pageNode == null) {
                uri = uri.substring(0, uri.lastIndexOf(47));
                pageNode = PageNavigationUtils.searchPageNodeByUri((PageNavigation)navigation, (String)uri);
            }
            if (pageNode == null) continue;
            break;
        }
        if (uri.length() != temp.length()) {
            parent = uri;
            newURI = temp.substring(uri.length() + 1);
            correctLink = this.getBaseURI() + "?parentUri=" + parent + "&pageUri=" + newURI;
            return label + " <a href=\"" + correctLink + "\">?</a>";
        }
        correctLink = this.getBaseURI() + temp;
        return "<a href=\"" + correctLink + "\">" + label + "</a>";
    }

    private void correctLinks(List<String> list) throws Exception {
        String[] arr = this.links.keySet().toArray(new String[0]);
        for (int i = list.size() - 1; i >= 0; --i) {
            String key = arr[list.size() - i - 1];
            String label = this.links.get(key);
            String correctLink = this.generateLink(key, label);
            this.dataSource = this.dataSource.replace(list.get(i), correctLink);
        }
    }

    public String parseHTML() throws Exception {
        this.dataSource = this.dataSource.replace("&gt;", ">");
        Matcher matcher = XWIKI_LINK.matcher(this.dataSource);
        ArrayList<String> list = new ArrayList<String>();
        while (matcher.find()) {
            String link = matcher.group(4);
            String label = matcher.group(2);
            list.add(this.dataSource.substring(matcher.start(), matcher.end()));
            this.links.put(link, label);
        }
        this.correctLinks(list);
        return this.dataSource;
    }
}

