/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.security;

import java.io.InputStream;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.security.EncryptionDictionary;
import org.icepdf.core.pobjects.security.Permissions;
import org.icepdf.core.pobjects.security.SecurityHandler;
import org.icepdf.core.pobjects.security.StandardEncryption;

public class StandardSecurityHandler
extends SecurityHandler {
    private StandardEncryption standardEnryption = null;
    private byte[] encryptionKey = null;
    private boolean initiated = false;
    private String password;

    public StandardSecurityHandler(EncryptionDictionary encryptionDictionary) {
        super(encryptionDictionary);
        this.handlerName = "Adobe Standard Security";
    }

    public boolean isAuthorized(String password) {
        boolean value = this.standardEnryption.authenticateUserPassword(password);
        if (!value) {
            value = this.standardEnryption.authenticateOwnerPassword(password);
            if (value) {
                this.password = this.standardEnryption.getUserPassword();
            }
        } else {
            this.password = password;
        }
        return value;
    }

    public boolean isOwnerAuthorized(String password) {
        return this.standardEnryption.authenticateOwnerPassword(password);
    }

    public boolean isUserAuthorized(String password) {
        boolean value = this.standardEnryption.authenticateUserPassword(password);
        if (value) {
            this.password = password;
        }
        return value;
    }

    public byte[] encrypt(Reference objectReference, byte[] encryptionKey, byte[] data) {
        return this.standardEnryption.generalEncryptionAlgorithm(objectReference, encryptionKey, data);
    }

    public byte[] decrypt(Reference objectReference, byte[] encryptionKey, byte[] data) {
        return this.encrypt(objectReference, encryptionKey, data);
    }

    public InputStream getEncryptionInputStream(Reference objectReference, byte[] encryptionKey, InputStream input) {
        return this.standardEnryption.generalEncryptionInputStream(objectReference, encryptionKey, input);
    }

    public byte[] getEncryptionKey() {
        if (!this.initiated) {
            this.init();
        }
        this.encryptionKey = this.standardEnryption.encryptionKeyAlgorithm(this.password, this.encryptionDictionary.getKeyLength());
        return this.encryptionKey;
    }

    public byte[] getDecryptionKey() {
        return this.getEncryptionKey();
    }

    public Permissions getPermissions() {
        if (!this.initiated) {
            this.init();
        }
        return this.permissions;
    }

    public String getHandlerName() {
        return this.handlerName;
    }

    public void init() {
        this.standardEnryption = new StandardEncryption(this.encryptionDictionary);
        this.permissions = new Permissions(this.encryptionDictionary);
        this.permissions.init();
        this.initiated = true;
    }

    public void dispose() {
        this.standardEnryption = null;
        this.encryptionKey = null;
        this.permissions = null;
        this.initiated = false;
    }
}

