/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.common;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.common.PackBits;
import org.apache.sanselan.common.mylzw.MyLZWCompressor;
import org.apache.sanselan.common.mylzw.MyLZWDecompressor;

public class Compression {
    public byte[] decompressLZW(byte[] compressed, int LZWMinimumCodeSize, int expectedSize, int byteOrder) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(compressed);
        MyLZWDecompressor decompressor = new MyLZWDecompressor(LZWMinimumCodeSize, byteOrder);
        byte[] result = decompressor.decompress(is, expectedSize);
        return result;
    }

    public byte[] decompressPackBits(byte[] compressed, int expectedSize, int byteOrder) throws ImageReadException, IOException {
        byte[] unpacked = new PackBits().decompress(compressed, expectedSize);
        return unpacked;
    }

    public byte[] compressLZW(byte[] src, int LZWMinimumCodeSize, int byteOrder, boolean earlyLimit) throws IOException {
        MyLZWCompressor compressor = new MyLZWCompressor(LZWMinimumCodeSize, byteOrder, earlyLimit);
        byte[] compressed = compressor.compress(src);
        return compressed;
    }
}

