/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form;

import java.util.List;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.validator.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="system:/groovy/webui/core/UIPageIterator.gtmpl", events={@EventConfig(listeners={ShowPageActionListener.class}, phase=Event.Phase.DECODE)})
@Serialized
public class UIFormPageIterator
extends UIPageIterator
implements UIFormInput<Object> {
    @Override
    public void processDecode(WebuiRequestContext context) throws Exception {
        UIForm uiForm = this.getAncestorOfType(UIForm.class);
        String action = uiForm.getSubmitAction();
        if (action == null) {
            return;
        }
        Event<UIComponent> event = this.createEvent(action, Event.Phase.DECODE, context);
        if (event != null) {
            event.broadcast();
        }
    }

    @Override
    public String event(String name, String beanId) throws Exception {
        UIForm uiForm = this.getAncestorOfType(UIForm.class);
        return uiForm.event(name, this.getId(), beanId);
    }

    @Override
    public <E extends Validator> UIFormInput addValidator(Class<E> clazz, Object ... params) throws Exception {
        return this;
    }

    @Override
    public String getBindingField() {
        return null;
    }

    @Override
    public List getValidators() {
        return null;
    }

    @Override
    public Object getValue() throws Exception {
        return null;
    }

    @Override
    public void reset() {
    }

    @Override
    public String getLabel() {
        return this.getName();
    }

    @Override
    public Class getTypeValue() {
        return null;
    }

    @Override
    public UIFormInput setValue(Object value) throws Exception {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShowPageActionListener
    extends EventListener<UIFormPageIterator> {
        @Override
        public void execute(Event<UIFormPageIterator> event) throws Exception {
            UIFormPageIterator uiPageIterator = event.getSource();
            int page = Integer.parseInt(event.getRequestContext().getRequestParameter("objectId"));
            uiPageIterator.setCurrentPage(page);
            UIForm uiForm = uiPageIterator.getAncestorOfType(UIForm.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm.getParent());
        }
    }
}

