/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.link;

import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.cms.link.LinkUtils;
import org.exoplatform.services.cms.link.PropertyLinkAware;
import org.exoplatform.services.cms.link.RangeIteratorLinkAware;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class PropertyIteratorLinkAware
extends RangeIteratorLinkAware
implements PropertyIterator {
    private static final Log LOG = ExoLogger.getLogger((String)"cms.PropertyIteratorLinkAware");

    public PropertyIteratorLinkAware(Session originalSession, String virtualPath, PropertyIterator propertyIterator) {
        super(originalSession, virtualPath, (RangeIterator)propertyIterator);
    }

    public Property nextProperty() {
        Property property = (Property)this.iterator.next();
        try {
            return new PropertyLinkAware(this.originalSession, LinkUtils.createPath(this.virtualPath, property.getName()), property);
        }
        catch (RepositoryException e) {
            LOG.error((Object)"Cannot create an instance of PropertyLinkAware", (Throwable)e);
            return property;
        }
    }

    public Object next() {
        return this.nextProperty();
    }
}

