/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.swing.log;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.exoplatform.swing.ViewPlugin;
import org.exoplatform.swing.event.Event;
import org.exoplatform.swing.event.EventListener;
import org.exoplatform.swing.event.EventManager;

public class LogViewPlugin
extends JPanel
implements ViewPlugin {
    public static final String NAME = "LogViewPlugin";
    public JTextArea txt;
    private JButton clearBtn_;

    public LogViewPlugin() {
        this.setLayout(new BorderLayout());
        this.txt = new JTextArea();
        this.txt.setEditable(false);
        JScrollPane scroll = new JScrollPane(this.txt);
        scroll.setPreferredSize(new Dimension());
        this.add((Component)scroll, "Center");
        this.clearBtn_ = new JButton("Clear");
        JPanel pnlControl = new JPanel();
        pnlControl.add(this.clearBtn_);
        this.add((Component)pnlControl, "South");
        this.clearBtn_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
            }
        });
        EventManager.getInstance().addEventListener(new LogEventListener("log.event.error", "[ERROR]", this.txt));
        EventManager.getInstance().addEventListener(new LogEventListener("log.event.info", "[INFO] ", this.txt));
    }

    public String getName() {
        return NAME;
    }

    public String getTitle() {
        return "Log";
    }

    public static class LogEventListener
    extends EventListener {
        private JTextArea txt;
        private String prefix;
        private String eventName;

        public LogEventListener(String eventName, String prefix, JTextArea txt) {
            this.txt = txt;
            this.prefix = prefix + " ";
            this.eventName = eventName;
        }

        public String getListenedEventName() {
            return this.eventName;
        }

        public void onEvent(Event event) throws Exception {
            this.txt.append(this.prefix);
            this.txt.append(event.getData().toString());
            this.txt.append("\n");
        }
    }
}

