/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.io;

import java.io.IOException;
import java.io.OutputStream;

public class CountingOutputStream
extends OutputStream {
    private OutputStream wrapped;
    private long count;

    public CountingOutputStream(OutputStream wrap) {
        this.wrapped = wrap;
        this.count = 0L;
    }

    public long getCount() {
        return this.count;
    }

    public void write(int i) throws IOException {
        this.wrapped.write(i);
        ++this.count;
    }

    public void write(byte[] bytes) throws IOException {
        this.wrapped.write(bytes);
        this.count += (long)bytes.length;
    }

    public void write(byte[] bytes, int offset, int len) throws IOException {
        this.wrapped.write(bytes, offset, len);
        int num = Math.min(len, bytes.length - offset);
        this.count += (long)num;
    }

    public void flush() throws IOException {
        this.wrapped.flush();
    }

    public void close() throws IOException {
        this.wrapped.close();
    }
}

