/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.actions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.jcr.Node;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.ecm.jcr.model.Preference;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIFormInputSetWithActionForTaggingForm;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UITaggingFormContainer;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UISideBar;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.cms.folksonomy.NewFolksonomyService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={AddTagActionListener.class}), @EventConfig(listeners={EditActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ChangeActionListener.class}, phase=Event.Phase.DECODE)})
public class UITaggingForm
extends UIForm {
    public static final String TAG_NAME_LIST = "tagNameList";
    public static final String TAG_NAMES = "names";
    public static final String TAG_SCOPES = "tagScopes";
    public static final String SCOPE_VALUES = "scopeValues";
    public static final String LINKED_TAGS = "linked";
    public static final String LINKED_TAGS_SET = "tagSet";
    public static final String TAG_STATUS_PROP = "exo:tagStatus".intern();
    public static final String TAG_NAME_ACTION = "tagNameAct".intern();
    public static final String ASCENDING_ORDER = "Ascending".intern();
    private static final String USER_FOLKSONOMY_ALIAS = "userPrivateFolksonomy".intern();
    private static final String GROUP_FOLKSONOMY_ALIAS = "folksonomy".intern();
    private static final String GROUPS_ALIAS = "groupsPath".intern();
    public static final String PUBLIC_TAG_NODE_PATH = "exoPublicTagNode";
    String[] groups;
    String[] users;

    public UITaggingForm() throws Exception {
        UIFormInputSetWithActionForTaggingForm uiInputSet = new UIFormInputSetWithActionForTaggingForm(LINKED_TAGS_SET);
        uiInputSet.addUIFormInput((UIFormInput)new UIFormStringInput(TAG_NAMES, TAG_NAMES, null));
        uiInputSet.addUIFormInput((UIFormInput)new UIFormTextAreaInput(TAG_NAME_LIST, TAG_NAME_LIST, null));
        RequestContext context = RequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        ArrayList<SelectItemOption> tagScopes = new ArrayList<SelectItemOption>();
        tagScopes.add(new SelectItemOption(res.getString("UITaggingForm.label.Private"), (Object)"Private"));
        tagScopes.add(new SelectItemOption(res.getString("UITaggingForm.label.Public"), (Object)"Public"));
        UIFormSelectBox box = new UIFormSelectBox(TAG_SCOPES, TAG_SCOPES, tagScopes);
        box.setOnChange("Change");
        uiInputSet.addUIFormInput((UIFormInput)box);
        box.setSelectedValues(new String[]{"Private"});
        uiInputSet.addUIFormInput((UIFormInput)new UIFormInputInfo(LINKED_TAGS, LINKED_TAGS, null));
        uiInputSet.setIntroduction(TAG_NAMES, "UITaggingForm.introduction.tagName");
        this.addUIComponentInput((UIComponent)uiInputSet);
        uiInputSet.setIsView(false);
        super.setActions(new String[]{"AddTag", "Cancel"});
    }

    public void activate() throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        String repository = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
        RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
        ManageableRepository manageableRepo = repositoryService.getRepository(repository);
        String workspace = manageableRepo.getConfiguration().getDefaultWorkspaceName();
        NewFolksonomyService folksonomyService = (NewFolksonomyService)this.getApplicationComponent(NewFolksonomyService.class);
        StringBuilder linkedTags = new StringBuilder();
        HashSet<String> linkedTagSet = new HashSet<String>();
        String tagScope = (String)this.getUIFormSelectBox(TAG_SCOPES).getValue();
        Node currentNode = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode();
        for (Node tag : folksonomyService.getLinkedTagsOfDocumentByScope(this.getIntValue(tagScope), this.getStrValue(tagScope, currentNode), currentNode, repository, workspace)) {
            linkedTagSet.add(tag.getName());
        }
        for (String tagName : linkedTagSet) {
            if (linkedTags.length() > 0) {
                linkedTags = linkedTags.append(",");
            }
            linkedTags.append(tagName);
        }
        UIFormInputSetWithAction uiLinkedInput = (UIFormInputSetWithAction)this.getChildById(LINKED_TAGS_SET);
        uiLinkedInput.setInfoField(LINKED_TAGS, linkedTags.toString());
        uiLinkedInput.setActionInfo(LINKED_TAGS, new String[]{"Edit", "Remove"});
        uiLinkedInput.setIsShowOnly(true);
        uiLinkedInput.setIsDeleteOnly(false);
    }

    public void deActivate() throws Exception {
    }

    public int getIntValue(String scope) {
        if ("Public".equals(scope)) {
            return 0;
        }
        if ("Group".equals(scope)) {
            return 3;
        }
        if ("Private".equals(scope)) {
            return 1;
        }
        return 2;
    }

    public List<String> getAllTagNames() throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        String repository = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
        RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
        ManageableRepository manageableRepo = repositoryService.getRepository(repository);
        String workspace = manageableRepo.getConfiguration().getDefaultWorkspaceName();
        NewFolksonomyService folksonomyService = (NewFolksonomyService)this.getApplicationComponent(NewFolksonomyService.class);
        String tagScope = (String)this.getUIFormSelectBox(TAG_SCOPES).getValue();
        Node currentNode = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode();
        return folksonomyService.getAllTagNames(repository, workspace, this.getIntValue(tagScope), this.getStrValue(tagScope, currentNode));
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        context.getJavascriptManager().importJavascript("eXo.ecm.ECMUtils", "/ecm-wcm-extension/javascript/");
        context.getJavascriptManager().addJavascript((CharSequence)"eXo.ecm.ECMUtils.disableAutocomplete('UITaggingForm');");
        super.processRender(context);
    }

    private String getStrValue(String scope, Node node) throws Exception {
        StringBuilder ret = new StringBuilder();
        if ("Private".equals(scope)) {
            ret.append(node.getSession().getUserID());
        } else if ("Group".equals(scope)) {
            for (String group : Utils.getGroups()) {
                ret.append(group).append(';');
            }
            ret.deleteCharAt(ret.length() - 1);
        } else if ("Public".equals(scope)) {
            NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)this.getApplicationComponent(NodeHierarchyCreator.class);
            ret.append(nodeHierarchyCreator.getJcrPath(PUBLIC_TAG_NODE_PATH));
        }
        return ret.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditActionListener
    extends EventListener<UITaggingForm> {
        public void execute(Event<UITaggingForm> event) throws Exception {
            UITaggingForm uiForm = (UITaggingForm)((Object)event.getSource());
            NewFolksonomyService newFolksonomyService = (NewFolksonomyService)uiForm.getApplicationComponent(NewFolksonomyService.class);
            String tagScope = (String)uiForm.getUIFormSelectBox(UITaggingForm.TAG_SCOPES).getValue();
            List memberships = Utils.getMemberships();
            if (!newFolksonomyService.canEditTag(uiForm.getIntValue(tagScope), memberships)) {
                UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.editTagAccessDenied", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            ((UITaggingFormContainer)uiForm.getParent()).edit(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeActionListener
    extends EventListener<UITaggingForm> {
        public void execute(Event<UITaggingForm> event) throws Exception {
            UITaggingForm uiForm = (UITaggingForm)((Object)event.getSource());
            uiForm.activate();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveActionListener
    extends EventListener<UITaggingForm> {
        public void execute(Event<UITaggingForm> event) throws Exception {
            UITaggingForm uiForm = (UITaggingForm)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiForm.getAncestorOfType(UIJCRExplorer.class);
            NewFolksonomyService newFolksonomyService = (NewFolksonomyService)uiForm.getApplicationComponent(NewFolksonomyService.class);
            String tagScope = (String)uiForm.getUIFormSelectBox(UITaggingForm.TAG_SCOPES).getValue();
            List memberships = Utils.getMemberships();
            if (!newFolksonomyService.canEditTag(uiForm.getIntValue(tagScope), memberships)) {
                UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.editTagAccessDenied", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            Node currentNode = uiExplorer.getCurrentNode();
            String tagName = event.getRequestContext().getRequestParameter("objectId");
            String[] arrFilterChar = new String[]{"&", "'", "$", "@", ":", "]", "[", "*", "%", "!", "/", "\\"};
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            if (!Utils.isNameValid((String)tagName, (String[])arrFilterChar)) {
                uiApp.addMessage(new ApplicationMessage("UITaggingForm.msg.tagName-invalid", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            this.removeTagFromNode(tagScope, currentNode, tagName, uiForm);
            uiForm.activate();
            Preference preferences = uiExplorer.getPreference();
            if (preferences.isShowSideBar()) {
                UISideBar uiSideBar = (UISideBar)uiExplorer.findFirstComponentOfType(UISideBar.class);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSideBar);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }

        public void removeTagFromNode(String scope, Node currentNode, String tagName, UITaggingForm uiForm) throws Exception {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            NewFolksonomyService newFolksonomyService = (NewFolksonomyService)uiForm.getApplicationComponent(NewFolksonomyService.class);
            NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)uiForm.getApplicationComponent(NodeHierarchyCreator.class);
            String repository = ((UIJCRExplorer)uiForm.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
            String userName = currentNode.getSession().getUserID();
            RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
            ManageableRepository manageableRepo = repositoryService.getRepository(repository);
            String workspace = manageableRepo.getConfiguration().getDefaultWorkspaceName();
            String tagPath = "";
            if ("Public".equals(scope)) {
                tagPath = nodeHierarchyCreator.getJcrPath(UITaggingForm.PUBLIC_TAG_NODE_PATH) + '/' + tagName;
                newFolksonomyService.removeTagOfDocument(tagPath, currentNode, repository, workspace);
            } else if ("Private".equals(scope)) {
                Node userFolksonomyNode = this.getUserFolksonomyFolder(userName, uiForm);
                tagPath = userFolksonomyNode.getNode(tagName).getPath();
                newFolksonomyService.removeTagOfDocument(tagPath, currentNode, repository, workspace);
            } else if ("Group".equals(scope)) {
                String groupsPath = nodeHierarchyCreator.getJcrPath(GROUPS_ALIAS);
                String folksonomyPath = nodeHierarchyCreator.getJcrPath(GROUP_FOLKSONOMY_ALIAS);
                Node groupsNode = this.getNode(repository, workspace, groupsPath);
                for (String role : Utils.getGroups()) {
                    tagPath = groupsNode.getNode(role).getNode(folksonomyPath).getNode(tagName).getPath();
                    newFolksonomyService.removeTagOfDocument(tagPath, currentNode, repository, workspace);
                }
            }
        }

        private Node getNode(String repository, String workspace, String path) throws Exception {
            ExoContainer myContainer = ExoContainerContext.getCurrentContainer();
            RepositoryService repositoryService = (RepositoryService)myContainer.getComponentInstanceOfType(RepositoryService.class);
            ManageableRepository manageableRepository = repositoryService.getRepository(repository);
            SessionProvider sessionProvider = SessionProviderFactory.createSessionProvider();
            return (Node)sessionProvider.getSession(workspace, manageableRepository).getItem(path);
        }

        private Node getUserFolksonomyFolder(String userName, UITaggingForm uiForm) throws Exception {
            NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)uiForm.getApplicationComponent(NodeHierarchyCreator.class);
            SessionProvider sessionProvider = SessionProviderFactory.createSessionProvider();
            Node userNode = nodeHierarchyCreator.getUserNode(sessionProvider, userName);
            String folksonomyPath = nodeHierarchyCreator.getJcrPath(USER_FOLKSONOMY_ALIAS);
            return userNode.getNode(folksonomyPath);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UITaggingForm> {
        public void execute(Event<UITaggingForm> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UITaggingForm)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            uiExplorer.cancelAction();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddTagActionListener
    extends EventListener<UITaggingForm> {
        public void execute(Event<UITaggingForm> event) throws Exception {
            UITaggingForm uiForm = (UITaggingForm)((Object)event.getSource());
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            String repository = ((UIJCRExplorer)uiForm.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
            String workspace = ((UIJCRExplorer)uiForm.getAncestorOfType(UIJCRExplorer.class)).getRepository().getConfiguration().getDefaultWorkspaceName();
            String tagName = (String)uiForm.getUIStringInput(UITaggingForm.TAG_NAMES).getValue();
            NewFolksonomyService newFolksonomyService = (NewFolksonomyService)uiForm.getApplicationComponent(NewFolksonomyService.class);
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiForm.getAncestorOfType(UIJCRExplorer.class);
            Node currentNode = uiExplorer.getCurrentNode();
            uiExplorer.addLockToken(currentNode);
            if (tagName == null || tagName.trim().length() == 0) {
                uiApp.addMessage(new ApplicationMessage("UITaggingForm.msg.tag-name-empty", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            String[] tagNames = null;
            if (tagName.indexOf(",") > -1) {
                tagNames = tagName.split(",");
                ArrayList<String> listTagNames = new ArrayList<String>(tagNames.length);
                ArrayList<String> listTagNamesClone = new ArrayList<String>(tagNames.length);
                for (String tName : tagNames) {
                    listTagNames.add(tName.trim());
                    listTagNamesClone.add(tName.trim());
                }
                for (int i = 0; i < listTagNames.size(); ++i) {
                    String tag = (String)listTagNames.get(i);
                    listTagNamesClone.remove(tag);
                    if (listTagNamesClone.contains(tag)) {
                        uiApp.addMessage(new ApplicationMessage("UITaggingForm.msg.tag-name-duplicate", null, 1));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                    listTagNamesClone.add(tag);
                }
            } else {
                tagNames = new String[]{tagName};
            }
            String[] fitlerTagNames = new String[tagNames.length];
            int i = 0;
            for (String t : tagNames) {
                String[] arrFilterChar;
                fitlerTagNames[i] = tagNames[i].trim();
                ++i;
                if (t.trim().length() == 0) {
                    uiApp.addMessage(new ApplicationMessage("UITaggingForm.msg.tag-name-empty", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
                if (t.trim().length() > 20) {
                    uiApp.addMessage(new ApplicationMessage("UITaggingForm.msg.tagName-too-long", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
                for (String filterChar : arrFilterChar = new String[]{"&", "'", "$", "@", ":", "]", "[", "*", "%", "!", "/", "\\"}) {
                    if (t.indexOf(filterChar) <= -1) continue;
                    uiApp.addMessage(new ApplicationMessage("UITaggingForm.msg.tagName-invalid", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
            }
            String tagScope = (String)uiForm.getUIFormSelectBox(UITaggingForm.TAG_SCOPES).getValue();
            List tagList = newFolksonomyService.getLinkedTagsOfDocumentByScope(uiForm.getIntValue(tagScope), uiForm.getStrValue(tagScope, currentNode), uiExplorer.getCurrentNode(), repository, workspace);
            for (Node tag : tagList) {
                for (String t : fitlerTagNames) {
                    if (!t.equals(tag.getName())) continue;
                    Object[] args = new Object[]{t};
                    uiApp.addMessage(new ApplicationMessage("UITaggingForm.msg.name-exist", args, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
            }
            this.addTagToNode(tagScope, currentNode, fitlerTagNames, repository, uiForm);
            uiForm.activate();
            Preference preferences = uiExplorer.getPreference();
            if (preferences.isShowSideBar()) {
                UISideBar uiSideBar = (UISideBar)uiExplorer.findFirstComponentOfType(UISideBar.class);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSideBar);
            }
            uiForm.getUIStringInput(UITaggingForm.TAG_NAMES).setValue(null);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }

        private void addTagToNode(String scope, Node currentNode, String[] tagNames, String repository, UITaggingForm uiForm) throws Exception {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            NewFolksonomyService newFolksonomyService = (NewFolksonomyService)uiForm.getApplicationComponent(NewFolksonomyService.class);
            RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
            ManageableRepository manageableRepo = repositoryService.getRepository(repository);
            NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)uiForm.getApplicationComponent(NodeHierarchyCreator.class);
            String workspace = manageableRepo.getConfiguration().getDefaultWorkspaceName();
            String[] roles = Utils.getGroups().toArray(new String[0]);
            String publicTagNodePath = nodeHierarchyCreator.getJcrPath(UITaggingForm.PUBLIC_TAG_NODE_PATH);
            if ("Public".equals(scope)) {
                newFolksonomyService.addPublicTag(publicTagNodePath, tagNames, currentNode, repository, workspace);
            } else if ("Group".equals(scope)) {
                newFolksonomyService.addGroupsTag(tagNames, currentNode, repository, workspace, roles);
            } else if ("Private".equals(scope)) {
                String userName = currentNode.getSession().getUserID();
                newFolksonomyService.addPrivateTag(tagNames, currentNode, repository, workspace, userName);
            }
        }
    }
}

