/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.info;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PropertyIterator;
import javax.jcr.Session;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/explorer/popup/info/UIReferencesList.gtmpl", events={@EventConfig(listeners={CloseActionListener.class})})
public class UIReferencesList
extends UIGrid
implements UIPopupComponent {
    private static String[] REFERENCES_BEAN_FIELD = new String[]{"workspace", "path"};

    public void activate() throws Exception {
        this.configure("workspace", REFERENCES_BEAN_FIELD, null);
        this.updateGrid();
    }

    public void deActivate() {
    }

    public void updateGrid() throws Exception {
        ObjectPageList objPageList = new ObjectPageList(this.getReferences(), 10);
        this.getUIPageIterator().setPageList((PageList)objPageList);
    }

    private List<ReferenceBean> getReferences() throws Exception {
        ArrayList<ReferenceBean> referBeans = new ArrayList<ReferenceBean>();
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        Node currentNode = uiJCRExplorer.getCurrentNode();
        String uuid = currentNode.getUUID();
        String repositoryName = uiJCRExplorer.getRepositoryName();
        ManageableRepository repository = repositoryService.getRepository(repositoryName);
        Session session = null;
        for (String workspace : repository.getWorkspaceNames()) {
            session = repository.getSystemSession(workspace);
            try {
                Node lookupNode = session.getNodeByUUID(uuid);
                PropertyIterator iter = lookupNode.getReferences();
                if (iter != null) {
                    while (iter.hasNext()) {
                        Node refNode = iter.nextProperty().getParent();
                        referBeans.add(new ReferenceBean(workspace, refNode.getPath()));
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            session.logout();
        }
        return referBeans;
    }

    public class ReferenceBean {
        private String workspace_;
        private String path_;

        public ReferenceBean(String workspace, String path) {
            this.workspace_ = workspace;
            this.path_ = path;
        }

        public String getPath() {
            return this.path_;
        }

        public void setPath(String path) {
            this.path_ = path;
        }

        public String getWorkspace() {
            return this.workspace_;
        }

        public void setWorkspace(String workspace) {
            this.workspace_ = workspace;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CloseActionListener
    extends EventListener<UIReferencesList> {
        public void execute(Event<UIReferencesList> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UIReferencesList)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            uiExplorer.cancelAction();
        }
    }
}

