/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.ValueExpression;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.XmlException;
import org.apache.shindig.expressions.Expressions;
import org.apache.shindig.gadgets.AuthType;
import org.apache.shindig.gadgets.spec.RequestAuthenticationInfo;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.apache.shindig.gadgets.variables.Substitutions;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PipelinedData {
    private final Map<String, SocialData> socialPreloads;
    private final Map<String, HttpData> httpPreloads;
    private boolean needsViewer;
    private boolean needsOwner;
    public static final String OPENSOCIAL_NAMESPACE = "http://ns.opensocial.org/2008/markup";

    public PipelinedData(Element element, Uri base) throws SpecParserException {
        HashMap socialPreloads = Maps.newHashMap();
        HashMap httpPreloads = Maps.newHashMap();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element child;
            if (!(node instanceof Element) || !OPENSOCIAL_NAMESPACE.equals((child = (Element)node).getNamespaceURI())) continue;
            String elementName = child.getLocalName();
            String key = child.getAttribute("key");
            if (key == null) {
                throw new SpecParserException("Missing key attribute on os:" + elementName);
            }
            try {
                if ("PeopleRequest".equals(elementName)) {
                    socialPreloads.put(key, this.createPeopleRequest(child));
                    continue;
                }
                if ("ViewerRequest".equals(elementName)) {
                    socialPreloads.put(key, this.createViewerRequest(child));
                    continue;
                }
                if ("OwnerRequest".equals(elementName)) {
                    socialPreloads.put(key, this.createOwnerRequest(child));
                    continue;
                }
                if ("PersonAppDataRequest".equals(elementName)) {
                    socialPreloads.put(key, this.createPersonAppDataRequest(child));
                    continue;
                }
                if ("ActivitiesRequest".equals(elementName)) {
                    socialPreloads.put(key, this.createActivityRequest(child));
                    continue;
                }
                if ("DataRequest".equals(elementName)) {
                    socialPreloads.put(key, this.createDataRequest(child));
                    continue;
                }
                if ("HttpRequest".equals(elementName)) {
                    httpPreloads.put(key, this.createHttpRequest(child, base));
                    continue;
                }
                throw new SpecParserException("Unknown element <os:" + elementName + '>');
            }
            catch (ELException ele) {
                throw new SpecParserException(new XmlException((Exception)((Object)ele)));
            }
        }
        this.socialPreloads = Collections.unmodifiableMap(socialPreloads);
        this.httpPreloads = Collections.unmodifiableMap(httpPreloads);
    }

    private PipelinedData(PipelinedData socialData, Substitutions substituter) {
        HashMap socialPreloads = Maps.newHashMap();
        HashMap httpPreloads = Maps.newHashMap();
        socialPreloads.putAll(socialData.socialPreloads);
        for (Map.Entry<String, HttpData> httpPreload : socialData.httpPreloads.entrySet()) {
            httpPreloads.put(httpPreload.getKey(), httpPreload.getValue().substitute(substituter));
        }
        this.socialPreloads = Collections.unmodifiableMap(socialPreloads);
        this.httpPreloads = Collections.unmodifiableMap(httpPreloads);
    }

    public PipelinedData substitute(Substitutions substituter) {
        return new PipelinedData(this, substituter);
    }

    public Batch getBatch(Expressions expressions, ELResolver rootObjects) {
        return this.getBatch(expressions, rootObjects, this.socialPreloads, this.httpPreloads);
    }

    private Batch getBatch(Expressions expressions, ELResolver rootObjects, Map<String, SocialData> currentSocialPreloads, Map<String, HttpData> currentHttpPreloads) {
        ELContext elContext = expressions.newELContext(new ELResolver[]{rootObjects});
        HashMap evaluatedSocialPreloads = Maps.newHashMap();
        HashMap pendingSocialPreloads = null;
        if (currentSocialPreloads != null) {
            for (Map.Entry<String, SocialData> preload : currentSocialPreloads.entrySet()) {
                try {
                    JSONObject value = preload.getValue().toJson(expressions, elContext);
                    evaluatedSocialPreloads.put(preload.getKey(), value);
                }
                catch (PropertyNotFoundException pnfe) {
                    if (pendingSocialPreloads == null) {
                        pendingSocialPreloads = Maps.newHashMap();
                    }
                    pendingSocialPreloads.put(preload.getKey(), preload.getValue());
                }
                catch (ELException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        HashMap evaluatedHttpPreloads = Maps.newHashMap();
        HashMap pendingHttpPreloads = null;
        if (currentHttpPreloads != null) {
            for (Map.Entry<String, HttpData> preload : currentHttpPreloads.entrySet()) {
                try {
                    RequestAuthenticationInfo value = preload.getValue().evaluate(expressions, elContext);
                    evaluatedHttpPreloads.put(preload.getKey(), value);
                }
                catch (PropertyNotFoundException pnfe) {
                    if (pendingHttpPreloads == null) {
                        pendingHttpPreloads = Maps.newHashMap();
                    }
                    pendingHttpPreloads.put(preload.getKey(), preload.getValue());
                }
                catch (ELException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (evaluatedSocialPreloads.isEmpty() && evaluatedHttpPreloads.isEmpty() && pendingHttpPreloads == null && pendingSocialPreloads == null) {
            return null;
        }
        return new BatchImpl(expressions, evaluatedSocialPreloads, evaluatedHttpPreloads, pendingSocialPreloads, pendingHttpPreloads);
    }

    public boolean needsViewer() {
        return this.needsViewer;
    }

    public boolean needsOwner() {
        return this.needsOwner;
    }

    private SocialData createPeopleRequest(Element child) throws ELException {
        SocialData expression = new SocialData(child.getAttribute("key"), "people.get");
        this.copyAttribute("groupId", child, expression, String.class);
        this.copyAttribute("userId", child, expression, JSONArray.class);
        this.updateUserArrayState("userId", child);
        this.copyAttribute("personId", child, expression, JSONArray.class);
        this.updateUserArrayState("personId", child);
        this.copyAttribute("startIndex", child, expression, Integer.class);
        this.copyAttribute("count", child, expression, Integer.class);
        this.copyAttribute("sortBy", child, expression, String.class);
        this.copyAttribute("sortOrder", child, expression, String.class);
        this.copyAttribute("filterBy", child, expression, String.class);
        this.copyAttribute("filterOperation", child, expression, String.class);
        this.copyAttribute("filterValue", child, expression, String.class);
        this.copyAttribute("fields", child, expression, JSONArray.class);
        return expression;
    }

    private SocialData createViewerRequest(Element child) throws ELException {
        return this.createPersonRequest(child, "@viewer");
    }

    private SocialData createOwnerRequest(Element child) throws ELException {
        return this.createPersonRequest(child, "@owner");
    }

    private SocialData createPersonRequest(Element child, String userId) throws ELException {
        SocialData expression = new SocialData(child.getAttribute("key"), "people.get");
        expression.addProperty("userId", userId, JSONArray.class);
        this.updateUserState(userId);
        this.copyAttribute("fields", child, expression, JSONArray.class);
        return expression;
    }

    private SocialData createPersonAppDataRequest(Element child) throws ELException {
        SocialData expression = new SocialData(child.getAttribute("key"), "appdata.get");
        this.copyAttribute("groupId", child, expression, String.class);
        this.copyAttribute("userId", child, expression, JSONArray.class);
        this.updateUserArrayState("userId", child);
        this.copyAttribute("appId", child, expression, String.class);
        this.copyAttribute("fields", child, expression, JSONArray.class);
        return expression;
    }

    private SocialData createActivityRequest(Element child) throws ELException {
        SocialData expression = new SocialData(child.getAttribute("key"), "activities.get");
        this.copyAttribute("groupId", child, expression, String.class);
        this.copyAttribute("userId", child, expression, JSONArray.class);
        this.updateUserArrayState("userId", child);
        this.copyAttribute("appId", child, expression, String.class);
        this.copyAttribute("activityId", child, expression, JSONArray.class);
        this.copyAttribute("fields", child, expression, JSONArray.class);
        return expression;
    }

    private SocialData createDataRequest(Element child) throws ELException, SpecParserException {
        String method = child.getAttribute("method");
        if (method == null) {
            throw new SpecParserException("Missing @method attribute on os:DataRequest");
        }
        if (method.endsWith(".update") || method.endsWith(".create") || method.endsWith(".delete")) {
            throw new SpecParserException("Unsupported @method attribute \"" + method + "\" on os:DataRequest");
        }
        SocialData expression = new SocialData(child.getAttribute("key"), method);
        NamedNodeMap nodeMap = child.getAttributes();
        for (int i = 0; i < nodeMap.getLength(); ++i) {
            String name;
            Node attrNode = nodeMap.item(i);
            if (attrNode.getNamespaceURI() != null || "method".equals(name = attrNode.getNodeName()) || "key".equals(name)) continue;
            String value = attrNode.getNodeValue();
            expression.addProperty(name, value, Object.class);
        }
        return expression;
    }

    private HttpData createHttpRequest(Element child, Uri base) throws ELException {
        HttpData data = new HttpData(child, base);
        if (data.authz != AuthType.NONE) {
            if (data.signOwner) {
                this.needsOwner = true;
            }
            if (data.signViewer) {
                this.needsViewer = true;
            }
        }
        return data;
    }

    private void copyAttribute(String name, Element element, SocialData expression, Class<?> type) throws ELException {
        if (element.hasAttribute(name)) {
            expression.addProperty(name, element.getAttribute(name), type);
        }
    }

    private void updateUserArrayState(String name, Element element) {
        if (element.hasAttribute(name)) {
            StringTokenizer tokens = new StringTokenizer(element.getAttribute(name), ",");
            while (tokens.hasMoreTokens()) {
                this.updateUserState(tokens.nextToken());
            }
        }
    }

    private void updateUserState(String userId) {
        if ("@owner".equals(userId)) {
            this.needsOwner = true;
        } else if ("@viewer".equals(userId) || "@me".equals(userId)) {
            this.needsViewer = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SocialData {
        private final List<Property> properties = Lists.newArrayList();
        private final String id;
        private final String method;

        public SocialData(String id, String method) {
            this.id = id;
            this.method = method;
        }

        public void addProperty(String name, String value, Class<?> type) throws ELException {
            this.properties.add(new Property(name, value, type));
        }

        public JSONObject toJson(Expressions expressions, ELContext elContext) throws ELException {
            JSONObject object = new JSONObject();
            try {
                object.put("method", (Object)this.method);
                object.put("id", (Object)this.id);
                JSONObject params = new JSONObject();
                for (Property property : this.properties) {
                    property.set(expressions, elContext, params);
                }
                object.put("params", (Object)params);
            }
            catch (JSONException je) {
                throw new ELException((Throwable)je);
            }
            return object;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class Property {
            private final String name;
            private final String value;
            private final Class<?> type;

            public Property(String name, String value, Class<?> type) {
                this.name = name;
                this.value = value;
                this.type = type;
            }

            public void set(Expressions expressions, ELContext elContext, JSONObject object) throws ELException {
                ValueExpression expression = expressions.parse(this.value, this.type);
                Object value = expression.getValue(elContext);
                try {
                    if (value != null) {
                        object.put(this.name, value);
                    }
                }
                catch (JSONException e) {
                    throw new ELException("Error parsing property \"" + this.name + '\"', (Throwable)e);
                }
            }
        }
    }

    private static class HttpData {
        private final AuthType authz;
        private final Uri base;
        private final String href;
        private final boolean signOwner;
        private final boolean signViewer;
        private final Map<String, String> attributes;
        private static final Set<String> KNOWN_ATTRIBUTES = ImmutableSet.of((Object[])new String[]{"authz", "href", "sign_owner", "sign_viewer"});

        public HttpData(Element element, Uri base) throws ELException {
            this.base = base;
            this.authz = element.hasAttribute("authz") ? AuthType.parse(element.getAttribute("authz")) : AuthType.NONE;
            this.href = element.getAttribute("href");
            this.signOwner = this.booleanValue(element, "sign_owner", true);
            this.signViewer = this.booleanValue(element, "sign_viewer", true);
            ImmutableMap.Builder attributes = ImmutableMap.builder();
            for (int i = 0; i < element.getAttributes().getLength(); ++i) {
                Node attr = element.getAttributes().item(i);
                if (KNOWN_ATTRIBUTES.contains(attr.getNodeName())) continue;
                attributes.put((Object)attr.getNodeName(), (Object)attr.getNodeValue());
            }
            this.attributes = attributes.build();
        }

        private HttpData(HttpData data, Substitutions substituter) {
            this.base = data.base;
            this.authz = data.authz;
            this.href = substituter.substituteString(data.href);
            this.signOwner = data.signOwner;
            this.signViewer = data.signViewer;
            this.attributes = data.attributes;
        }

        public HttpData substitute(Substitutions substituter) {
            return new HttpData(this, substituter);
        }

        public RequestAuthenticationInfo evaluate(Expressions expressions, ELContext context) throws ELException {
            String hrefString = String.valueOf(expressions.parse(this.href, String.class).getValue(context));
            final Uri evaluatedHref = this.base.resolve(Uri.parse((String)hrefString));
            final HashMap evaluatedAttributes = Maps.newHashMap();
            for (Map.Entry<String, String> attr : this.attributes.entrySet()) {
                ValueExpression expression = expressions.parse(attr.getValue(), String.class);
                evaluatedAttributes.put(attr.getKey(), String.valueOf(expression.getValue(context)));
            }
            return new RequestAuthenticationInfo(){

                @Override
                public Map<String, String> getAttributes() {
                    return evaluatedAttributes;
                }

                @Override
                public AuthType getAuthType() {
                    return HttpData.this.authz;
                }

                @Override
                public Uri getHref() {
                    return evaluatedHref;
                }

                @Override
                public boolean isSignOwner() {
                    return HttpData.this.signOwner;
                }

                @Override
                public boolean isSignViewer() {
                    return HttpData.this.signViewer;
                }
            };
        }

        private boolean booleanValue(Element element, String attrName, boolean defaultValue) {
            if (!element.hasAttribute(attrName)) {
                return defaultValue;
            }
            return "true".equalsIgnoreCase(element.getAttribute(attrName));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BatchImpl
    implements Batch {
        private final Expressions expressions;
        private final Map<String, Object> evaluatedSocialPreloads;
        private final Map<String, RequestAuthenticationInfo> evaluatedHttpPreloads;
        private final Map<String, SocialData> pendingSocialPreloads;
        private final Map<String, HttpData> pendingHttpPreloads;

        public BatchImpl(Expressions expressions, Map<String, Object> evaluatedSocialPreloads, Map<String, RequestAuthenticationInfo> evaluatedHttpPreloads, Map<String, SocialData> pendingSocialPreloads, Map<String, HttpData> pendingHttpPreloads) {
            this.expressions = expressions;
            this.evaluatedSocialPreloads = evaluatedSocialPreloads;
            this.evaluatedHttpPreloads = evaluatedHttpPreloads;
            this.pendingSocialPreloads = pendingSocialPreloads;
            this.pendingHttpPreloads = pendingHttpPreloads;
        }

        @Override
        public Map<String, Object> getSocialPreloads() {
            return this.evaluatedSocialPreloads;
        }

        @Override
        public Map<String, RequestAuthenticationInfo> getHttpPreloads() {
            return this.evaluatedHttpPreloads;
        }

        @Override
        public Batch getNextBatch(ELResolver rootObjects) {
            return PipelinedData.this.getBatch(this.expressions, rootObjects, this.pendingSocialPreloads, this.pendingHttpPreloads);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Batch {
        public Map<String, Object> getSocialPreloads();

        public Map<String, RequestAuthenticationInfo> getHttpPreloads();

        public Batch getNextBatch(ELResolver var1);
    }
}

