/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.chars;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringTokenizer {
    private char[] regexes;
    private char[] addRegexes;

    public StringTokenizer(char[] reg, char[] addReg) {
        this.regexes = reg;
        this.addRegexes = addReg;
    }

    public List<String> split(String text) {
        ArrayList<String> list = new ArrayList<String>();
        int start = 0;
        for (int idx = 0; idx < text.length(); ++idx) {
            char c = text.charAt(idx);
            TypeRegex check = this.isSplitChar(c);
            if (check == TypeRegex.ADD_REGEX) {
                if (start < idx) {
                    this.add(text.substring(start, idx), list);
                }
                this.add(String.valueOf(c), list);
                start = idx + 1;
                continue;
            }
            if (check != TypeRegex.REGEX) continue;
            this.add(text.substring(start, idx), list);
            start = idx + 1;
        }
        if (start < text.length()) {
            this.add(text.substring(start, text.length()), list);
        }
        return list;
    }

    private void add(String value, List<String> list) {
        if ((value = value.trim()).length() < 1) {
            return;
        }
        list.add(value);
    }

    private TypeRegex isSplitChar(char c) {
        for (char e : this.regexes) {
            if (e != c) continue;
            return TypeRegex.ADD_REGEX;
        }
        for (char e : this.addRegexes) {
            if (e != c) continue;
            return TypeRegex.REGEX;
        }
        return TypeRegex.NOT_REGEX;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TypeRegex {
        ADD_REGEX,
        NOT_REGEX,
        REGEX;

    }
}

