/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.version;

import java.util.List;
import java.util.Stack;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.OnParentVersionAction;
import javax.jcr.version.VersionException;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.core.nodetype.NodeDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionData;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.value.BaseValue;
import org.exoplatform.services.jcr.impl.dataflow.AbstractItemDataCopyVisitor;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class FrozenNodeInitializer
extends AbstractItemDataCopyVisitor {
    private static Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.FrozenNodeInitializer");
    private final Stack<NodeData> contextNodes;
    private final NodeTypeDataManager ntManager;
    private final PlainChangesLog changesLog;
    private final SessionDataManager dataManager;
    private final ValueFactory valueFactory;

    public FrozenNodeInitializer(NodeData frozen, SessionDataManager dataManager, NodeTypeDataManager ntManager, PlainChangesLog changesLog, ValueFactory valueFactory) throws RepositoryException {
        super(dataManager);
        this.dataManager = dataManager;
        this.ntManager = ntManager;
        this.changesLog = changesLog;
        this.valueFactory = valueFactory;
        this.contextNodes = new Stack();
        this.contextNodes.push(frozen);
    }

    protected void entering(PropertyData property, int level) throws RepositoryException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entering property " + property.getQPath().getAsString()));
        }
        if (this.currentNode() == null) {
            return;
        }
        TransientPropertyData frozenProperty = null;
        InternalQName qname = property.getQPath().getName();
        List<ValueData> values = this.copyValues(property);
        boolean mv = property.isMultiValued();
        if (qname.equals((Object)Constants.JCR_PRIMARYTYPE) && level == 1) {
            frozenProperty = TransientPropertyData.createPropertyData(this.currentNode(), Constants.JCR_FROZENPRIMARYTYPE, 7, mv, values);
        } else if (qname.equals((Object)Constants.JCR_UUID) && level == 1) {
            frozenProperty = TransientPropertyData.createPropertyData(this.currentNode(), Constants.JCR_FROZENUUID, 1, mv, values);
        } else if (qname.equals((Object)Constants.JCR_MIXINTYPES) && level == 1) {
            frozenProperty = TransientPropertyData.createPropertyData(this.currentNode(), Constants.JCR_FROZENMIXINTYPES, 7, mv, values);
        } else {
            NodeData parent = (NodeData)this.dataManager.getItemData(property.getParentIdentifier());
            PropertyDefinitionData pdef = this.ntManager.getPropertyDefinitions(qname, parent.getPrimaryTypeName(), parent.getMixinTypeNames()).getAnyDefinition();
            int action = pdef.getOnParentVersion();
            if (action == 5) {
                return;
            }
            if (action == 6) {
                throw new VersionException("Property is aborted " + property.getQPath().getAsString());
            }
            if (action == 1 || action == 2 || action == 4) {
                frozenProperty = TransientPropertyData.createPropertyData(this.currentNode(), qname, property.getType(), mv, values);
            } else if (action == 3) {
                if (pdef.isAutoCreated()) {
                    if (pdef.getDefaultValues() != null && pdef.getDefaultValues().length > 0) {
                        values.clear();
                        for (String defValue : pdef.getDefaultValues()) {
                            ValueData defData = 0 == pdef.getRequiredType() ? ((BaseValue)this.valueFactory.createValue(defValue)).getInternalData() : ((BaseValue)this.valueFactory.createValue(defValue, pdef.getRequiredType())).getInternalData();
                            values.add(defData);
                        }
                    } else if (this.ntManager.isNodeType(Constants.NT_HIERARCHYNODE, parent.getPrimaryTypeName(), parent.getMixinTypeNames()) && qname.equals((Object)Constants.JCR_CREATED)) {
                        values.clear();
                        values.add(new TransientValueData(this.dataManager.getTransactManager().getStorageDataManager().getCurrentTime()));
                    }
                }
                frozenProperty = TransientPropertyData.createPropertyData(this.currentNode(), qname, property.getType(), mv, values);
            } else {
                throw new RepositoryException("Unknown OnParentVersion value " + action);
            }
        }
        this.changesLog.add(ItemState.createAddedState(frozenProperty));
    }

    protected void entering(NodeData node, int level) throws RepositoryException {
        NodeData parent;
        if (level == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entering node " + node.getQPath().getAsString() + ", level=0"));
            }
            return;
        }
        if (this.currentNode() == null) {
            this.contextNodes.push(null);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entering node " + node.getQPath().getAsString() + ", HAS NULL PARENT"));
            }
            return;
        }
        InternalQName qname = node.getQPath().getName();
        NodeDefinitionData ndef = this.ntManager.getChildNodeDefinition(qname, (parent = (NodeData)this.dataManager.getItemData(node.getParentIdentifier())).getPrimaryTypeName(), parent.getMixinTypeNames());
        if (ndef == null) {
            throw new ConstraintViolationException("Definition not found for " + qname.getAsString());
        }
        int action = ndef.getOnParentVersion();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entering node " + node.getQPath().getAsString() + ", " + OnParentVersionAction.nameFromValue((int)action)));
        }
        TransientNodeData frozenNode = null;
        if (action == 5) {
            this.contextNodes.push(null);
        } else {
            if (action == 6) {
                throw new VersionException("Node is aborted " + node.getQPath().getAsString());
            }
            if (action == 1) {
                AccessControlList acl = this.ntManager.isNodeType(Constants.EXO_PRIVILEGEABLE, node.getPrimaryTypeName(), node.getMixinTypeNames()) ? node.getACL() : this.currentNode().getACL();
                QPath frozenPath = QPath.makeChildPath(this.currentNode().getQPath(), qname, node.getQPath().getIndex());
                frozenNode = new TransientNodeData(frozenPath, IdGenerator.generate(), node.getPersistedVersion(), node.getPrimaryTypeName(), node.getMixinTypeNames(), node.getOrderNumber(), this.currentNode().getIdentifier(), acl);
                this.contextNodes.push(frozenNode);
                this.changesLog.add(ItemState.createAddedState(frozenNode));
            } else if (action == 2) {
                if (this.ntManager.isNodeType(Constants.MIX_VERSIONABLE, node.getPrimaryTypeName(), node.getMixinTypeNames())) {
                    frozenNode = TransientNodeData.createNodeData(this.currentNode(), qname, Constants.NT_VERSIONEDCHILD, node.getQPath().getIndex());
                    TransientPropertyData pt = TransientPropertyData.createPropertyData((NodeData)frozenNode, Constants.JCR_PRIMARYTYPE, 7, false, new TransientValueData(Constants.NT_VERSIONEDCHILD));
                    ValueData vh = ((PropertyData)this.dataManager.getItemData(node, new QPathEntry(Constants.JCR_VERSIONHISTORY, 0), ItemType.PROPERTY)).getValues().get(0);
                    TransientPropertyData pd = TransientPropertyData.createPropertyData((NodeData)frozenNode, Constants.JCR_CHILDVERSIONHISTORY, 9, false, vh);
                    this.contextNodes.push(null);
                    this.changesLog.add(ItemState.createAddedState(frozenNode));
                    this.changesLog.add(ItemState.createAddedState(pt));
                    this.changesLog.add(ItemState.createAddedState(pd));
                } else {
                    AccessControlList acl = this.ntManager.isNodeType(Constants.EXO_PRIVILEGEABLE, node.getPrimaryTypeName(), node.getMixinTypeNames()) ? node.getACL() : this.currentNode().getACL();
                    QPath frozenPath = QPath.makeChildPath(this.currentNode().getQPath(), qname, node.getQPath().getIndex());
                    frozenNode = new TransientNodeData(frozenPath, IdGenerator.generate(), node.getPersistedVersion(), node.getPrimaryTypeName(), node.getMixinTypeNames(), node.getOrderNumber(), this.currentNode().getIdentifier(), acl);
                    this.contextNodes.push(frozenNode);
                    this.changesLog.add(ItemState.createAddedState(frozenNode));
                }
            } else if (action == 3) {
                frozenNode = TransientNodeData.createNodeData(this.currentNode(), qname, node.getPrimaryTypeName(), node.getQPath().getIndex());
                this.contextNodes.push(null);
                this.changesLog.add(ItemState.createAddedState(frozenNode));
            } else if (action == 4) {
                frozenNode = TransientNodeData.createNodeData(this.currentNode(), qname, node.getPrimaryTypeName(), node.getQPath().getIndex());
                this.contextNodes.push(null);
                this.changesLog.add(ItemState.createAddedState(frozenNode));
            } else {
                throw new RepositoryException("Unknown onParentVersion type " + action);
            }
        }
    }

    protected void leaving(PropertyData property, int level) throws RepositoryException {
    }

    protected void leaving(NodeData node, int level) throws RepositoryException {
        this.contextNodes.pop();
    }

    private NodeData currentNode() {
        return this.contextNodes.peek();
    }

    public SessionDataManager getDataManager() {
        return this.dataManager;
    }
}

