/*
 * Decompiled with CFR 0.152.
 */
package org.quartz;

import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import org.quartz.Calendar;
import org.quartz.CronTrigger;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Trigger;

public class UICronTrigger
extends Trigger {
    public static final int MISFIRE_INSTRUCTION_FIRE_ONCE_NOW = 1;
    public static final int MISFIRE_INSTRUCTION_DO_NOTHING = 2;
    private static final int ALL_SPEC_INT = 99;
    private static final int NO_SPEC_INT = 98;
    private static final Integer ALL_SPEC = new Integer(99);
    private static final Integer NO_SPEC = new Integer(98);
    private static Map monthMap = new HashMap(20);
    private static Map dayMap = new HashMap(60);
    private Date startTime = null;
    private Date endTime = null;
    private Date nextFireTime = null;
    private TimeZone timeZone = null;
    private Date previousFireTime = null;
    private TreeSet seconds = null;
    private TreeSet minutes = null;
    private TreeSet hours = null;
    private TreeSet daysOfMonth = null;
    private TreeSet months = null;
    private TreeSet daysOfWeek = null;
    private TreeSet years = null;
    private transient boolean lastdayOfWeek = false;
    private transient int nthdayOfWeek = 0;
    private transient boolean lastdayOfMonth = false;
    private transient boolean calendardayOfWeek = false;
    private transient boolean calendardayOfMonth = false;

    public void reset() {
        int i;
        this.seconds = new TreeSet();
        this.minutes = new TreeSet();
        this.hours = new TreeSet();
        this.daysOfMonth = new TreeSet();
        this.months = new TreeSet();
        this.daysOfWeek = new TreeSet();
        this.years = new TreeSet();
        this.seconds.add(new Integer(0));
        this.minutes.add(ALL_SPEC);
        for (i = 0; i < 60; ++i) {
            this.minutes.add(new Integer(i));
        }
        this.hours.add(ALL_SPEC);
        for (i = 0; i < 24; ++i) {
            this.hours.add(new Integer(i));
        }
        this.daysOfMonth.add(ALL_SPEC);
        for (i = 1; i <= 31; ++i) {
            this.daysOfMonth.add(new Integer(i));
        }
        this.months.add(ALL_SPEC);
        for (i = 1; i <= 12; ++i) {
            this.months.add(new Integer(i));
        }
        this.daysOfWeek.add(NO_SPEC);
        this.years.add(ALL_SPEC);
        for (i = 1970; i <= 2099; ++i) {
            this.years.add(new Integer(i));
        }
        this.startTime = new Date();
        this.setStartTime(this.startTime);
        this.setTimeZone(TimeZone.getDefault());
    }

    public UICronTrigger() {
        this.reset();
    }

    public UICronTrigger(String name, String group) {
        super(name, group);
        this.reset();
    }

    public UICronTrigger(String name, String group, String jobName, String jobGroup) {
        super(name, group, jobName, jobGroup);
        this.reset();
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        if (startTime == null) {
            throw new IllegalArgumentException("Start time cannot be null");
        }
        Date eTime = this.getEndTime();
        if (eTime != null && startTime != null && eTime.before(startTime)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        java.util.Calendar cl = java.util.Calendar.getInstance();
        cl.setTime(startTime);
        cl.set(14, 0);
        this.startTime = cl.getTime();
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        Date sTime = this.getStartTime();
        if (sTime != null && endTime != null && sTime.after(endTime)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        this.endTime = endTime;
    }

    public Date getNextFireTime() {
        return this.nextFireTime;
    }

    public void updateAfterMisfire(Calendar cal) {
        int instr = this.getMisfireInstruction();
        if (instr == 0) {
            instr = 2;
        }
        if (instr == 2) {
            Date newFireTime = this.getFireTimeAfter(new Date());
            while (newFireTime != null && cal != null && !cal.isTimeIncluded(newFireTime.getTime())) {
                newFireTime = this.getFireTimeAfter(newFireTime);
            }
            this.setNextFireTime(newFireTime);
        } else if (instr == 1) {
            this.setNextFireTime(new Date());
        }
    }

    public Date getPreviousFireTime() {
        return this.previousFireTime;
    }

    public void setPreviousFireTime(Date previousFireTime) {
        this.previousFireTime = previousFireTime;
    }

    public void setNextFireTime(Date nextFireTime) {
        this.nextFireTime = nextFireTime;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public Date getFireTimeAfter(Date afterTime) {
        if (afterTime == null) {
            afterTime = new Date();
        }
        if (this.startTime.after(afterTime)) {
            afterTime = new Date(this.startTime.getTime() - 1000L);
        }
        Date pot = this.getTimeAfter(afterTime);
        if (this.endTime != null && pot != null && pot.after(this.endTime)) {
            return null;
        }
        return pot;
    }

    public Date getFinalFireTime() {
        if (this.endTime != null) {
            return this.getTimeBefore(this.endTime);
        }
        return null;
    }

    public boolean mayFireAgain() {
        return this.getNextFireTime() != null;
    }

    protected boolean validateMisfireInstruction(int misfireInstruction) {
        if (misfireInstruction < 0) {
            return false;
        }
        return misfireInstruction <= 2;
    }

    public void updateAfterMisfire() {
        int instr = this.getMisfireInstruction();
        if (instr == 0) {
            instr = 2;
        }
        if (instr == 2) {
            this.setNextFireTime(this.getFireTimeAfter(new Date()));
        } else if (instr == 1) {
            this.setNextFireTime(new Date());
        }
    }

    public boolean willFireOn(java.util.Calendar test) {
        Integer second = new Integer(test.get(13));
        Integer minute = new Integer(test.get(12));
        Integer hour = new Integer(test.get(11));
        Integer day = new Integer(test.get(5));
        Integer month = new Integer(test.get(2));
        return !(!this.seconds.contains(second) && !this.seconds.contains(ALL_SPEC) || !this.minutes.contains(minute) && !this.minutes.contains(ALL_SPEC) || !this.hours.contains(hour) && !this.hours.contains(ALL_SPEC) || !this.daysOfMonth.contains(day) && !this.daysOfMonth.contains(ALL_SPEC) || !this.months.contains(month) && !this.months.contains(ALL_SPEC));
    }

    public int executionComplete(JobExecutionContext context, JobExecutionException result) {
        if (result != null && result.refireImmediately()) {
            return 1;
        }
        if (result != null && result.refireImmediately()) {
            return 1;
        }
        if (result != null && result.unscheduleFiringTrigger()) {
            return 2;
        }
        if (result != null && result.unscheduleAllTriggers()) {
            return 4;
        }
        if (!this.mayFireAgain()) {
            return 3;
        }
        return 0;
    }

    public void triggered(Calendar calendar) {
        this.previousFireTime = this.nextFireTime;
        this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
        while (this.nextFireTime != null && calendar != null && !calendar.isTimeIncluded(this.nextFireTime.getTime())) {
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
        }
    }

    public void updateWithNewCalendar(Calendar calendar, long misfireThreshold) {
        block1: {
            long diff;
            this.nextFireTime = this.getFireTimeAfter(this.previousFireTime);
            Date now = new Date();
            while (this.nextFireTime != null && calendar != null && !calendar.isTimeIncluded(this.nextFireTime.getTime())) {
                this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
            }
            if (this.nextFireTime == null || !this.nextFireTime.before(now) || (diff = now.getTime() - this.nextFireTime.getTime()) < misfireThreshold) break block1;
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
        }
    }

    public Date computeFirstFireTime(Calendar calendar) {
        this.nextFireTime = this.getFireTimeAfter(new Date(this.startTime.getTime() - 1000L));
        while (this.nextFireTime != null && calendar != null && !calendar.isTimeIncluded(this.nextFireTime.getTime())) {
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
        }
        return this.nextFireTime;
    }

    public String getExpressionSummary() {
        StringBuffer buf = new StringBuffer();
        buf.append("seconds: ");
        buf.append(this.getExpressionSetSummary(this.seconds));
        buf.append("\n");
        buf.append("minutes: ");
        buf.append(this.getExpressionSetSummary(this.minutes));
        buf.append("\n");
        buf.append("hours: ");
        buf.append(this.getExpressionSetSummary(this.hours));
        buf.append("\n");
        buf.append("daysOfMonth: ");
        buf.append(this.getExpressionSetSummary(this.daysOfMonth));
        buf.append("\n");
        buf.append("months: ");
        buf.append(this.getExpressionSetSummary(this.months));
        buf.append("\n");
        buf.append("daysOfWeek: ");
        buf.append(this.getExpressionSetSummary(this.daysOfWeek));
        buf.append("\n");
        buf.append("lastdayOfWeek: ");
        buf.append(this.lastdayOfWeek);
        buf.append("\n");
        buf.append("lastdayOfMonth: ");
        buf.append(this.lastdayOfMonth);
        buf.append("\n");
        buf.append("calendardayOfWeek: ");
        buf.append(this.calendardayOfWeek);
        buf.append("\n");
        buf.append("calendardayOfMonth: ");
        buf.append(this.calendardayOfMonth);
        buf.append("\n");
        buf.append("years: ");
        buf.append(this.getExpressionSetSummary(this.years));
        buf.append("\n");
        return buf.toString();
    }

    private String getExpressionSetSummary(Set set) {
        if (set.contains(NO_SPEC)) {
            return "?";
        }
        if (set.contains(ALL_SPEC)) {
            return "*";
        }
        StringBuffer buf = new StringBuffer();
        Iterator itr = set.iterator();
        boolean first = true;
        while (itr.hasNext()) {
            Integer iVal = (Integer)itr.next();
            String val = iVal.toString();
            if (!first) {
                buf.append(",");
            }
            buf.append(val);
            first = false;
        }
        return buf.toString();
    }

    private Date getTimeAfter(Date afterTime) {
        java.util.Calendar cl = java.util.Calendar.getInstance(this.timeZone);
        afterTime = new Date(afterTime.getTime() + 1000L);
        cl.setTime(afterTime);
        cl.set(14, 0);
        boolean gotOne = false;
        while (!gotOne) {
            boolean dayOfWSpec;
            if (this.endTime != null && cl.getTime().after(this.endTime)) {
                return null;
            }
            SortedSet<Integer> st = null;
            int t = 0;
            int sec = cl.get(13);
            int min = cl.get(12);
            st = this.seconds.tailSet(new Integer(sec));
            if (st != null && st.size() != 0) {
                sec = st.first();
            } else {
                sec = (Integer)this.seconds.first();
                cl.set(12, ++min);
            }
            cl.set(13, sec);
            min = cl.get(12);
            int hr = cl.get(11);
            t = -1;
            st = this.minutes.tailSet(new Integer(min));
            if (st != null && st.size() != 0) {
                t = min;
                min = st.first();
            } else {
                min = (Integer)this.minutes.first();
                ++hr;
            }
            if (min != t) {
                cl.set(13, 0);
                cl.set(12, min);
                cl.set(11, hr);
                continue;
            }
            cl.set(12, min);
            hr = cl.get(11);
            int day = cl.get(5);
            t = -1;
            st = this.hours.tailSet(new Integer(hr));
            if (st != null && st.size() != 0) {
                t = hr;
                hr = st.first();
            } else {
                hr = (Integer)this.hours.first();
                ++day;
            }
            if (hr != t) {
                cl.set(13, 0);
                cl.set(12, 0);
                cl.set(11, hr);
                cl.set(5, day);
                continue;
            }
            cl.set(11, hr);
            day = cl.get(5);
            int mon = cl.get(2) + 1;
            t = -1;
            boolean dayOfMSpec = !this.daysOfMonth.contains(NO_SPEC);
            boolean bl = dayOfWSpec = !this.daysOfWeek.contains(NO_SPEC);
            if (dayOfMSpec && !dayOfWSpec) {
                st = this.daysOfMonth.tailSet(new Integer(day));
                if (this.lastdayOfMonth) {
                    t = day;
                    day = this.getLastDayOfMonth(mon);
                } else if (st != null && st.size() != 0) {
                    t = day;
                    day = st.first();
                } else {
                    day = (Integer)this.daysOfMonth.first();
                    ++mon;
                }
                if (day != t) {
                    cl.set(13, 0);
                    cl.set(12, 0);
                    cl.set(11, 0);
                    cl.set(5, day);
                    cl.set(2, mon - 1);
                    continue;
                }
            } else if (dayOfWSpec && !dayOfMSpec) {
                int lDay;
                int daysToAdd;
                int cDow;
                int dow;
                if (this.lastdayOfWeek) {
                    dow = (Integer)this.daysOfWeek.first();
                    cDow = cl.get(7);
                    daysToAdd = 0;
                    if (cDow < dow) {
                        daysToAdd = dow - cDow;
                    }
                    if (cDow > dow) {
                        daysToAdd = dow + (7 - cDow);
                    }
                    if (day + daysToAdd > (lDay = this.getLastDayOfMonth(mon))) {
                        cl.set(13, 0);
                        cl.set(12, 0);
                        cl.set(11, 0);
                        cl.set(5, 1);
                        cl.set(2, mon);
                        continue;
                    }
                    while (day + daysToAdd + 7 <= lDay) {
                        daysToAdd += 7;
                    }
                    day += daysToAdd;
                } else if (this.nthdayOfWeek != 0) {
                    dow = (Integer)this.daysOfWeek.first();
                    cDow = cl.get(7);
                    daysToAdd = 0;
                    if (cDow < dow) {
                        daysToAdd = dow - cDow;
                    } else if (cDow > dow) {
                        daysToAdd = dow + (7 - cDow);
                    }
                    int weekOfMonth = (day += daysToAdd) / 7;
                    if (day % 7 > 0) {
                        ++weekOfMonth;
                    }
                    if ((daysToAdd = (this.nthdayOfWeek - weekOfMonth) * 7) < 0 || (day += daysToAdd) > this.getLastDayOfMonth(mon)) {
                        cl.set(13, 0);
                        cl.set(12, 0);
                        cl.set(11, 0);
                        cl.set(5, 1);
                        cl.set(2, mon);
                        continue;
                    }
                } else {
                    int cDow2 = cl.get(7);
                    int dow2 = (Integer)this.daysOfWeek.first();
                    st = this.daysOfWeek.tailSet(new Integer(cDow2));
                    if (st != null && st.size() > 0) {
                        dow2 = st.first();
                    }
                    daysToAdd = 0;
                    if (cDow2 < dow2) {
                        daysToAdd = dow2 - cDow2;
                    }
                    if (cDow2 > dow2) {
                        daysToAdd = dow2 + (7 - cDow2);
                    }
                    if (day + daysToAdd > (lDay = this.getLastDayOfMonth(mon))) {
                        cl.set(13, 0);
                        cl.set(12, 0);
                        cl.set(11, 0);
                        cl.set(5, 1);
                        cl.set(2, mon);
                        continue;
                    }
                    if (daysToAdd > 0) {
                        cl.set(13, 0);
                        cl.set(12, 0);
                        cl.set(11, 0);
                        cl.set(5, day + daysToAdd);
                        cl.set(2, mon - 1);
                        continue;
                    }
                }
            } else {
                throw new UnsupportedOperationException("Support for specifying both a day-of-week AND a day-of-month parameter is not implemented.");
            }
            cl.set(5, day);
            mon = cl.get(2) + 1;
            int year = cl.get(1);
            t = -1;
            st = this.months.tailSet(new Integer(mon));
            if (st != null && st.size() != 0) {
                t = mon;
                mon = st.first();
            } else {
                mon = (Integer)this.months.first();
                ++year;
            }
            if (mon != t) {
                cl.set(13, 0);
                cl.set(12, 0);
                cl.set(11, 0);
                cl.set(5, 1);
                cl.set(2, mon - 1);
                cl.set(1, year);
                continue;
            }
            cl.set(2, mon - 1);
            year = cl.get(1);
            t = -1;
            st = this.years.tailSet(new Integer(year));
            if (st == null || st.size() == 0) {
                return null;
            }
            t = year;
            year = st.first();
            if (year != t) {
                cl.set(13, 0);
                cl.set(12, 0);
                cl.set(11, 0);
                cl.set(5, 1);
                cl.set(2, mon - 1);
                cl.set(1, year);
                continue;
            }
            cl.set(1, year);
            gotOne = true;
        }
        return cl.getTime();
    }

    private Date getTimeBefore(Date endTime) {
        return null;
    }

    public boolean isLeapYear() {
        java.util.Calendar cl = java.util.Calendar.getInstance(this.timeZone);
        int year = cl.get(1);
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public int getLastDayOfMonth(int monthNum) {
        switch (monthNum) {
            case 1: {
                return 31;
            }
            case 2: {
                return this.isLeapYear() ? 29 : 28;
            }
            case 3: {
                return 31;
            }
            case 4: {
                return 30;
            }
            case 5: {
                return 31;
            }
            case 6: {
                return 30;
            }
            case 7: {
                return 31;
            }
            case 8: {
                return 31;
            }
            case 9: {
                return 30;
            }
            case 10: {
                return 31;
            }
            case 11: {
                return 30;
            }
            case 12: {
                return 31;
            }
        }
        throw new IllegalArgumentException("Illegal month number: " + monthNum);
    }

    public Integer[] getSecondsValues() {
        Integer[] list = new Integer[60];
        for (int i = 0; i < 60; ++i) {
            list[i] = new Integer(i);
        }
        return list;
    }

    public Integer[] getSecondsLabels() {
        return this.getSecondsValues();
    }

    public Integer[] getSeconds() {
        Integer[] list = new Integer[this.seconds.size()];
        if (this.seconds != null) {
            int i = 0;
            Iterator it = this.seconds.iterator();
            while (it.hasNext()) {
                list[i] = (Integer)it.next();
                ++i;
            }
        }
        return list;
    }

    public void setSeconds(Integer[] val) {
        if (this.seconds != null) {
            this.seconds.clear();
        } else {
            this.seconds = new TreeSet();
        }
        for (int i = 0; i < val.length; ++i) {
            this.seconds.add(val[i]);
        }
    }

    public Integer[] getMinutesValues() {
        Integer[] list = new Integer[60];
        for (int i = 0; i < 60; ++i) {
            list[i] = new Integer(i);
        }
        return list;
    }

    public Integer[] getMinutesLabels() {
        return this.getMinutesValues();
    }

    public Integer[] getMinutes() {
        Integer[] list = new Integer[this.minutes.size()];
        if (this.minutes != null) {
            int i = 0;
            Iterator it = this.minutes.iterator();
            while (it.hasNext()) {
                list[i] = (Integer)it.next();
                ++i;
            }
        }
        return list;
    }

    public void setMinutes(Integer[] val) {
        if (this.minutes != null) {
            this.minutes.clear();
        } else {
            this.minutes = new TreeSet();
        }
        for (int i = 0; i < val.length; ++i) {
            this.minutes.add(val[i]);
        }
    }

    public Integer[] getHoursValues() {
        Integer[] list = new Integer[24];
        for (int i = 0; i < 24; ++i) {
            list[i] = new Integer(i);
        }
        return list;
    }

    public String[] getHoursLabels() {
        String[] vals = new String[]{"12AM (Midnight)", "1AM", "2AM", "3AM", "4AM", "5AM", "6AM", "7AM", "8AM", "9AM", "10AM", "11AM", "12PM (Noon)", "1PM", "2PM", "3PM", "4PM", "5PM", "6PM", "7PM", "8PM", "9PM", "10PM", "11PM"};
        return vals;
    }

    public Integer[] getHours() {
        Integer[] list = new Integer[this.hours.size()];
        if (this.hours != null) {
            int i = 0;
            Iterator it = this.hours.iterator();
            while (it.hasNext()) {
                list[i] = (Integer)it.next();
                ++i;
            }
        }
        return list;
    }

    public void setHours(Integer[] val) {
        if (this.hours != null) {
            this.hours.clear();
        } else {
            this.hours = new TreeSet();
        }
        for (int i = 0; i < val.length; ++i) {
            this.hours.add(val[i]);
        }
    }

    public Integer[] getDaysOfMonthValues() {
        Integer[] list = new Integer[31];
        for (int i = 0; i < 31; ++i) {
            list[i] = new Integer(i + 1);
        }
        return list;
    }

    public Integer[] getDaysOfMonthLabels() {
        return this.getDaysOfMonthValues();
    }

    public Integer[] getDaysOfMonth() {
        Integer[] list = new Integer[this.daysOfMonth.size()];
        if (this.daysOfMonth != null) {
            int i = 0;
            Iterator it = this.daysOfMonth.iterator();
            while (it.hasNext()) {
                list[i] = (Integer)it.next();
                ++i;
            }
        }
        return list;
    }

    public void setDaysOfMonth(Integer[] val) {
        if (this.daysOfMonth != null) {
            this.daysOfMonth.clear();
        } else {
            this.daysOfMonth = new TreeSet();
        }
        for (int i = 0; i < val.length; ++i) {
            this.daysOfMonth.add(val[i]);
        }
        this.daysOfWeek.clear();
        this.daysOfWeek.add(NO_SPEC);
    }

    public Integer[] getMonthsValues() {
        Integer[] list = new Integer[12];
        for (int i = 0; i < 12; ++i) {
            list[i] = new Integer(i + 1);
        }
        return list;
    }

    public String[] getMonthsLabels() {
        String[] vals = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        return vals;
    }

    public Integer[] getMonths() {
        Integer[] list = new Integer[this.months.size()];
        if (this.months != null) {
            int i = 0;
            Iterator it = this.months.iterator();
            while (it.hasNext()) {
                list[i] = (Integer)it.next();
                ++i;
            }
        }
        return list;
    }

    public void setMonths(Integer[] val) {
        if (this.months != null) {
            this.months.clear();
        } else {
            this.months = new TreeSet();
        }
        for (int i = 0; i < val.length; ++i) {
            this.months.add(val[i]);
        }
    }

    public String[] getDaysOfWeekLabels() {
        String[] list = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
        return list;
    }

    public Integer[] getDaysOfWeekValues() {
        Integer[] list = new Integer[7];
        for (int i = 0; i < 7; ++i) {
            list[i] = new Integer(i + 1);
        }
        return list;
    }

    public Integer[] getDaysOfWeek() {
        Integer[] list = new Integer[this.daysOfWeek.size()];
        if (this.daysOfWeek != null) {
            int i = 0;
            Iterator it = this.daysOfWeek.iterator();
            while (it.hasNext()) {
                list[i] = (Integer)it.next();
                ++i;
            }
        }
        return list;
    }

    public void setDaysOfWeek(Integer[] val) {
        if (this.daysOfWeek != null) {
            this.daysOfWeek.clear();
        } else {
            this.daysOfWeek = new TreeSet();
        }
        for (int i = 0; i < val.length; ++i) {
            this.daysOfWeek.add(val[i]);
        }
        this.daysOfMonth.clear();
        this.daysOfMonth.add(NO_SPEC);
    }

    public Integer[] getYearsValues() {
        Integer[] list = new Integer[20];
        java.util.Calendar now = java.util.Calendar.getInstance();
        int year = now.get(1);
        for (int i = 0; i < 20; ++i) {
            list[i] = new Integer(i + year);
        }
        return list;
    }

    public Integer[] getYearsLabels() {
        return this.getYearsValues();
    }

    public Integer[] getYears() {
        Integer[] list = new Integer[this.years.size()];
        if (this.years != null) {
            int i = 0;
            Iterator it = this.years.iterator();
            while (it.hasNext()) {
                list[i] = (Integer)it.next();
                ++i;
            }
        }
        return list;
    }

    public void setYears(Integer[] val) {
        if (this.years != null) {
            this.years.clear();
        } else {
            this.years = new TreeSet();
        }
        for (int i = 0; i < val.length; ++i) {
            this.years.add(val[i]);
        }
    }

    public static void main(String[] argv) {
        CronTrigger ct = new CronTrigger("a", "a");
        try {
            ct.setCronExpression("0 * * * * ? *");
        }
        catch (ParseException e) {
            // empty catch block
        }
        ct.setStartTime(new Date());
        ct.setTimeZone(TimeZone.getDefault());
        System.out.println(ct.getExpressionSummary());
        ct.computeFirstFireTime(null);
        UICronTrigger uict = new UICronTrigger("a", "a");
        Integer[] set = new Integer[]{new Integer(1)};
        uict.setSeconds(set);
        System.out.println(ct.getExpressionSummary());
        uict.computeFirstFireTime(null);
    }

    static {
        monthMap.put("JAN", new Integer(0));
        monthMap.put("FEB", new Integer(1));
        monthMap.put("MAR", new Integer(2));
        monthMap.put("APR", new Integer(3));
        monthMap.put("MAY", new Integer(4));
        monthMap.put("JUN", new Integer(5));
        monthMap.put("JUL", new Integer(6));
        monthMap.put("AUG", new Integer(7));
        monthMap.put("SEP", new Integer(8));
        monthMap.put("OCT", new Integer(9));
        monthMap.put("NOV", new Integer(10));
        monthMap.put("DEC", new Integer(11));
        dayMap.put("SUN", new Integer(1));
        dayMap.put("MON", new Integer(2));
        dayMap.put("TUE", new Integer(3));
        dayMap.put("WED", new Integer(4));
        dayMap.put("THU", new Integer(5));
        dayMap.put("FRI", new Integer(6));
        dayMap.put("SAT", new Integer(7));
    }
}

