/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.bridges.common;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.portals.bridges.util.PreferencesHelper;

public class GenericServletPortlet
extends GenericPortlet {
    public static final String PARAM_ACTION_PAGE = "ActionPage";
    public static final String PARAM_ALLOW_PREFERENCES = "AllowPreferences";
    public static final String PARAM_CUSTOM_PAGE = "CustomPage";
    public static final String PARAM_EDIT_PAGE = "EditPage";
    public static final String PARAM_HELP_PAGE = "HelpPage";
    public static final String PARAM_VIEW_PAGE = "ViewPage";
    public static final String PARAM_MAX_PAGE = "MaxPage";
    private boolean allowPreferences = false;
    private String defaultActionPage = null;
    private String defaultCustomPage = null;
    private String defaultEditPage = null;
    private String defaultHelpPage = null;
    private String defaultViewPage = null;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.defaultActionPage = config.getInitParameter(PARAM_ACTION_PAGE);
        this.defaultCustomPage = config.getInitParameter(PARAM_CUSTOM_PAGE);
        this.defaultEditPage = config.getInitParameter(PARAM_EDIT_PAGE);
        this.defaultViewPage = config.getInitParameter(PARAM_VIEW_PAGE);
        this.defaultHelpPage = config.getInitParameter(PARAM_HELP_PAGE);
        String allowPreferencesString = config.getInitParameter(PARAM_ALLOW_PREFERENCES);
        if (allowPreferencesString != null) {
            this.allowPreferences = new Boolean(allowPreferencesString);
        }
    }

    public void processAction(ActionRequest request, ActionResponse actionResponse) throws PortletException, IOException {
        PortletPreferences prefs;
        String actionPage = this.defaultActionPage;
        if (this.allowPreferences && (prefs = request.getPreferences()) != null) {
            actionPage = prefs.getValue(PARAM_ACTION_PAGE, this.defaultActionPage);
        }
        if (actionPage != null) {
            // empty if block
        }
    }

    public void doCustom(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        String customPage = this.defaultCustomPage;
        if (this.allowPreferences) {
            PortletPreferences prefs = request.getPreferences();
            customPage = (String)request.getAttribute(PARAM_CUSTOM_PAGE);
            if (prefs != null && customPage == null) {
                customPage = prefs.getValue(PARAM_CUSTOM_PAGE, this.defaultCustomPage);
            }
        }
        if (customPage != null) {
            PortletContext context = this.getPortletContext();
            PortletRequestDispatcher rd = context.getRequestDispatcher(customPage);
            rd.include(request, response);
        }
    }

    public void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        PortletPreferences prefs;
        String editPage = this.defaultEditPage;
        String reqEditPage = (String)request.getAttribute(PARAM_EDIT_PAGE);
        if (reqEditPage != null) {
            editPage = reqEditPage;
        }
        if (this.allowPreferences && (prefs = request.getPreferences()) != null && reqEditPage == null) {
            editPage = prefs.getValue(PARAM_EDIT_PAGE, this.defaultEditPage);
        }
        if (editPage != null) {
            PortletContext context = this.getPortletContext();
            PortletRequestDispatcher rd = context.getRequestDispatcher(editPage);
            rd.include(request, response);
        }
    }

    public void doHelp(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        PortletPreferences prefs;
        String helpPage = this.defaultHelpPage;
        String reqHelpPage = (String)request.getAttribute(PARAM_HELP_PAGE);
        if (reqHelpPage != null) {
            helpPage = reqHelpPage;
        }
        if (this.allowPreferences && (prefs = request.getPreferences()) != null && reqHelpPage == null) {
            helpPage = prefs.getValue(PARAM_HELP_PAGE, this.defaultHelpPage);
        }
        if (helpPage != null) {
            PortletContext context = this.getPortletContext();
            PortletRequestDispatcher rd = context.getRequestDispatcher(helpPage);
            rd.include(request, response);
        }
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        PortletPreferences prefs;
        String viewPage = this.defaultViewPage;
        String reqViewPage = (String)request.getAttribute(PARAM_VIEW_PAGE);
        if (reqViewPage != null) {
            viewPage = reqViewPage;
        }
        if (this.allowPreferences && (prefs = request.getPreferences()) != null && reqViewPage == null) {
            viewPage = prefs.getValue(PARAM_VIEW_PAGE, this.defaultViewPage);
        }
        if (viewPage != null) {
            PortletContext context = this.getPortletContext();
            PortletRequestDispatcher rd = context.getRequestDispatcher(viewPage);
            rd.include(request, response);
        }
    }

    public String getDefaultViewPage() {
        return this.defaultViewPage;
    }

    public void setDefaultViewPage(String defaultViewPage) {
        this.defaultViewPage = defaultViewPage;
    }

    public String getDefaultHelpPage() {
        return this.defaultHelpPage;
    }

    public void setDefaultHelpPage(String defaultHelpPage) {
        this.defaultHelpPage = defaultHelpPage;
    }

    public String getDefaultEditPage() {
        return this.defaultEditPage;
    }

    public void setDefaultEditPage(String defaultEditPage) {
        this.defaultEditPage = defaultEditPage;
    }

    public String getDefaultCustomPage() {
        return this.defaultCustomPage;
    }

    public void setDefaultCustomPage(String defaultCustomPage) {
        this.defaultCustomPage = defaultCustomPage;
    }

    public String getDefaultActionPage() {
        return this.defaultActionPage;
    }

    public void setDefaultActionPage(String defaultActionPage) {
        this.defaultActionPage = defaultActionPage;
    }

    public void processPreferencesAction(ActionRequest request, ActionResponse actionResponse) throws PortletException, IOException {
        PortletPreferences prefs = request.getPreferences();
        PreferencesHelper.requestParamsToPreferences(request);
        prefs.store();
        actionResponse.setPortletMode(PortletMode.VIEW);
    }
}

