/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.drives;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.drives.UIDriveForm;
import org.exoplatform.ecm.webui.component.admin.drives.UIDriveManager;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIComponentDecorator;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/admin/drives/UIDriveList.gtmpl", events={@EventConfig(listeners={DeleteActionListener.class}, confirm="UIDriveList.msg.confirm-delete"), @EventConfig(listeners={EditInfoActionListener.class}), @EventConfig(listeners={AddDriveActionListener.class})})
public class UIDriveList
extends UIComponentDecorator {
    public static final String[] ACTIONS = new String[]{"AddDrive"};
    public static final String ST_ADD = "AddDriveManagerPopup";
    public static final String ST_EDIT = "EditDriveManagerPopup";
    private UIPageIterator uiPageIterator_ = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, "UIDriveListIterator");

    public UIDriveList() throws Exception {
        this.setUIComponent((UIComponent)this.uiPageIterator_);
    }

    public String[] getActions() {
        return ACTIONS;
    }

    public void updateDriveListGrid(int currentPage) throws Exception {
        String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        ObjectPageList objPageList = new ObjectPageList(this.getDrives(repository), 10);
        this.uiPageIterator_.setPageList((PageList)objPageList);
        if (currentPage > this.getUIPageIterator().getAvailablePage()) {
            this.uiPageIterator_.setCurrentPage(currentPage - 1);
        } else {
            this.uiPageIterator_.setCurrentPage(currentPage);
        }
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public List getDriveList() throws Exception {
        return this.uiPageIterator_.getCurrentPageData();
    }

    public List<DriveData> getDrives(String repoName) throws Exception {
        RepositoryService rservice = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageDriveService driveService = (ManageDriveService)this.getApplicationComponent(ManageDriveService.class);
        ManageableRepository repository = rservice.getRepository(repoName);
        ArrayList<DriveData> driveList = new ArrayList<DriveData>();
        Session session = null;
        List drives = driveService.getAllDrives(repoName);
        if (drives != null && drives.size() > 0) {
            for (DriveData drive : drives) {
                if (drive.getIcon() != null && drive.getIcon().length() > 0) {
                    try {
                        String[] iconPath = drive.getIcon().split(":/");
                        session = repository.getSystemSession(iconPath[0]);
                        session.getItem("/" + iconPath[1]);
                        session.logout();
                    }
                    catch (PathNotFoundException pnf) {
                        drive.setIcon("");
                    }
                }
                if (!this.isExistWorspace(repository, drive)) continue;
                driveList.add(drive);
            }
        }
        Collections.sort(driveList);
        return driveList;
    }

    public String getPortalName() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
        return containerInfo.getContainerName();
    }

    public String getRepository() throws Exception {
        return ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
    }

    private boolean isExistWorspace(ManageableRepository repository, DriveData drive) {
        for (String ws : repository.getWorkspaceNames()) {
            if (!ws.equals(drive.getWorkspace())) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditInfoActionListener
    extends EventListener<UIDriveList> {
        public void execute(Event<UIDriveList> event) throws Exception {
            UIDriveManager uiDriveManager = (UIDriveManager)((UIDriveList)((Object)event.getSource())).getParent();
            uiDriveManager.removeChildById(UIDriveList.ST_ADD);
            uiDriveManager.initPopup(UIDriveList.ST_EDIT);
            String driveName = event.getRequestContext().getRequestParameter("objectId");
            ((UIDriveForm)uiDriveManager.findFirstComponentOfType(UIDriveForm.class)).refresh(driveName);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiDriveManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActionListener
    extends EventListener<UIDriveList> {
        public void execute(Event<UIDriveList> event) throws Exception {
            String name = event.getRequestContext().getRequestParameter("objectId");
            UIDriveList uiDriveList = (UIDriveList)((Object)event.getSource());
            ManageDriveService driveService = (ManageDriveService)uiDriveList.getApplicationComponent(ManageDriveService.class);
            String repository = ((UIECMAdminPortlet)uiDriveList.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
            driveService.removeDrive(name, repository);
            uiDriveList.updateDriveListGrid(uiDriveList.getUIPageIterator().getCurrentPage());
            event.getRequestContext().addUIComponentToUpdateByAjax(uiDriveList.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddDriveActionListener
    extends EventListener<UIDriveList> {
        public void execute(Event<UIDriveList> event) throws Exception {
            UIDriveManager uiDriveManager = (UIDriveManager)((UIDriveList)((Object)event.getSource())).getParent();
            uiDriveManager.removeChildById(UIDriveList.ST_EDIT);
            uiDriveManager.initPopup(UIDriveList.ST_ADD);
            UIDriveForm uiForm = (UIDriveForm)uiDriveManager.findFirstComponentOfType(UIDriveForm.class);
            uiForm.refresh(null);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiDriveManager);
        }
    }

    public static class DriveComparator
    implements Comparator {
        public int compare(Object o1, Object o2) throws ClassCastException {
            String name1 = ((DriveData)o1).getName();
            String name2 = ((DriveData)o2).getName();
            return name1.compareToIgnoreCase(name2);
        }
    }
}

