/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ULocale;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class PluralRules
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Map ruleMap;
    private final RuleList rules;
    private final Set keywords;
    private int repeatLimit;
    public static final String KEYWORD_ZERO = "zero";
    public static final String KEYWORD_ONE = "one";
    public static final String KEYWORD_TWO = "two";
    public static final String KEYWORD_FEW = "few";
    public static final String KEYWORD_MANY = "many";
    public static final String KEYWORD_OTHER = "other";
    private static final UnicodeSet START_CHARS;
    private static final UnicodeSet CONT_CHARS;
    private static final Constraint NO_CONSTRAINT;
    private static final Rule DEFAULT_RULE;
    public static final PluralRules DEFAULT;

    public static PluralRules parseDescription(String description) throws ParseException {
        if ((description = description.trim()).length() == 0) {
            return DEFAULT;
        }
        return new PluralRules(PluralRules.parseRuleChain(description));
    }

    public static PluralRules createRules(String description) {
        try {
            return PluralRules.parseDescription(description);
        }
        catch (ParseException e) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Constraint parseConstraint(String description) throws ParseException {
        void var1_2;
        description = description.trim().toLowerCase(Locale.ENGLISH);
        Object var1_1 = null;
        String[] or_together = Utility.splitString(description, "or");
        for (int i = 0; i < or_together.length; ++i) {
            Constraint andConstraint = null;
            String[] and_together = Utility.splitString(or_together[i], "and");
            for (int j = 0; j < and_together.length; ++j) {
                String t;
                Constraint newConstraint = NO_CONSTRAINT;
                String condition = and_together[j].trim();
                String[] tokens = Utility.splitWhitespace(condition);
                int mod = 0;
                boolean within = true;
                long lowBound = -1L;
                long highBound = -1L;
                boolean isRange = false;
                int x = 0;
                if (!"n".equals(t = tokens[x++])) {
                    throw PluralRules.unexpected(t, condition);
                }
                if (x < tokens.length) {
                    if ("mod".equals(t = tokens[x++])) {
                        mod = Integer.parseInt(tokens[x++]);
                        t = PluralRules.nextToken(tokens, x++, condition);
                    }
                    if ("is".equals(t)) {
                        if ("not".equals(t = PluralRules.nextToken(tokens, x++, condition))) {
                            within = false;
                            t = PluralRules.nextToken(tokens, x++, condition);
                        }
                    } else {
                        isRange = true;
                        if ("not".equals(t)) {
                            within = false;
                            t = PluralRules.nextToken(tokens, x++, condition);
                        }
                        if (!"in".equals(t)) throw PluralRules.unexpected(t, condition);
                        t = PluralRules.nextToken(tokens, x++, condition);
                    }
                    if (isRange) {
                        String[] pair = Utility.splitString(t, "..");
                        if (pair.length != 2) throw PluralRules.unexpected(t, condition);
                        lowBound = Long.parseLong(pair[0]);
                        highBound = Long.parseLong(pair[1]);
                    } else {
                        lowBound = highBound = Long.parseLong(t);
                    }
                    if (x != tokens.length) {
                        throw PluralRules.unexpected(tokens[x], condition);
                    }
                    newConstraint = new RangeConstraint(mod, within, lowBound, highBound);
                }
                andConstraint = andConstraint == null ? newConstraint : new AndConstraint(andConstraint, newConstraint);
            }
            if (var1_2 == null) {
                Constraint constraint = andConstraint;
                continue;
            }
            OrConstraint orConstraint = new OrConstraint((Constraint)var1_2, andConstraint);
        }
        return var1_2;
    }

    private static ParseException unexpected(String token, String context) {
        return new ParseException("unexpected token '" + token + "' in '" + context + "'", -1);
    }

    private static String nextToken(String[] tokens, int x, String context) throws ParseException {
        if (x < tokens.length) {
            return tokens[x];
        }
        throw new ParseException("missing token at end of '" + context + "'", -1);
    }

    private static Rule parseRule(String description) throws ParseException {
        int x = description.indexOf(58);
        if (x == -1) {
            throw new ParseException("missing ':' in rule description '" + description + "'", 0);
        }
        String keyword = description.substring(0, x).trim();
        if (!PluralRules.isValidKeyword(keyword)) {
            throw new ParseException("keyword '" + keyword + " is not valid", 0);
        }
        if ((description = description.substring(x + 1).trim()).length() == 0) {
            throw new ParseException("missing constraint in '" + description + "'", x + 1);
        }
        Constraint constraint = PluralRules.parseConstraint(description);
        ConstrainedRule rule = new ConstrainedRule(keyword, constraint);
        return rule;
    }

    private static RuleChain parseRuleChain(String description) throws ParseException {
        RuleChain rc = null;
        String[] rules = Utility.split(description, ';');
        for (int i = 0; i < rules.length; ++i) {
            Rule r = PluralRules.parseRule(rules[i].trim());
            rc = rc == null ? new RuleChain(r) : rc.addRule(r);
        }
        return rc;
    }

    public static PluralRules forLocale(ULocale locale) {
        PluralRules result = null;
        while (null == (result = (PluralRules)ruleMap.get(locale.getName()))) {
            if ((locale = locale.getFallback()) != null) continue;
            return DEFAULT;
        }
        return result;
    }

    private static boolean isValidKeyword(String token) {
        if (token.length() > 0 && START_CHARS.contains(token.charAt(0))) {
            for (int i = 1; i < token.length(); ++i) {
                if (CONT_CHARS.contains(token.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private PluralRules(RuleList rules) {
        this.rules = rules;
        this.keywords = Collections.unmodifiableSet(rules.getKeywords());
    }

    public String select(long number) {
        return this.rules.select(number);
    }

    public Set getKeywords() {
        return this.keywords;
    }

    public String toString() {
        return "keywords: " + this.keywords + " rules: " + this.rules.toString() + " limit: " + this.getRepeatLimit();
    }

    public int hashCode() {
        return ((Object)this.keywords).hashCode();
    }

    public boolean equals(Object rhs) {
        return rhs instanceof PluralRules && this.equals((PluralRules)rhs);
    }

    public boolean equals(PluralRules rhs) {
        if (rhs == null) {
            return false;
        }
        if (rhs == this) {
            return true;
        }
        if (!((Object)rhs.getKeywords()).equals(this.keywords)) {
            return false;
        }
        int limit = Math.max(this.getRepeatLimit(), rhs.getRepeatLimit());
        for (int i = 0; i < limit; ++i) {
            if (this.select(i).equals(rhs.select(i))) continue;
            return false;
        }
        return true;
    }

    private int getRepeatLimit() {
        if (this.repeatLimit == 0) {
            this.repeatLimit = this.rules.getRepeatLimit() + 1;
        }
        return this.repeatLimit;
    }

    static {
        START_CHARS = new UnicodeSet("[[:ID_Start:][_]]");
        CONT_CHARS = new UnicodeSet("[:ID_Continue:]");
        NO_CONSTRAINT = new Constraint(){
            private static final long serialVersionUID = 9163464945387899416L;

            public boolean isFulfilled(long n) {
                return true;
            }

            public String toString() {
                return "n is any";
            }

            public int updateRepeatLimit(int limit) {
                return limit;
            }
        };
        DEFAULT_RULE = new Rule(){
            private static final long serialVersionUID = -5677499073940822149L;

            public String getKeyword() {
                return PluralRules.KEYWORD_OTHER;
            }

            public boolean appliesTo(long n) {
                return true;
            }

            public String toString() {
                return "(other)";
            }

            public int updateRepeatLimit(int limit) {
                return limit;
            }
        };
        DEFAULT = new PluralRules(new RuleChain(DEFAULT_RULE));
        String[] ruledata = new String[]{"other: n/ja,ko,tr,vi", "zero: n is 0; one: n is 1; two: n is 2; few: n in 3..10; many: n in 11..99/ar", "one: n is 1/da,de,el,en,eo,es,et,fi,fo,he,hu,it,nb,nl,nn,no,pt,sv", "one: n in 0..1/fr,pt_BR", "zero: n is 0; one: n mod 10 is 1 and n mod 100 is not 11/lv", "one: n is 1; two: n is 2/ga", "zero: n is 0; one: n is 1; zero: n mod 100 in 1..19/ro", "other: n mod 100 in 11..19; one: n mod 10 is 1; few: n mod 10 in 2..9/lt", "one: n mod 10 is 1 and n mod 100 is not 11; few: n mod 10 in 2..4 and n mod 100 not in 12..14/hr,ru,sr,uk", "one: n is 1; few: n in 2..4/cs,sk", "one: n is 1; few: n mod 10 in 2..4 and n mod 100 not in 12..14/pl", "one: n mod 100 is 1; two: n mod 100 is 2; few: n mod 100 in 3..4/sl"};
        HashMap<String, PluralRules> map = new HashMap<String, PluralRules>();
        for (int i = 0; i < ruledata.length; ++i) {
            String[] data = Utility.split(ruledata[i], '/');
            try {
                PluralRules pluralRules = PluralRules.parseDescription(data[0]);
                String[] locales = Utility.split(data[1], ',');
                for (int j = 0; j < locales.length; ++j) {
                    map.put(locales[j].trim(), pluralRules);
                }
                continue;
            }
            catch (Exception e) {
                System.err.println("PluralRules init failure, " + e.getMessage() + " at line " + i);
            }
        }
        ruleMap = map;
    }

    private static class RuleChain
    implements RuleList,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Rule rule;
        private final RuleChain next;

        public RuleChain(Rule rule) {
            this(rule, null);
        }

        private RuleChain(Rule rule, RuleChain next) {
            this.rule = rule;
            this.next = next;
        }

        public RuleChain addRule(Rule nextRule) {
            return new RuleChain(nextRule, this);
        }

        private Rule selectRule(long n) {
            Rule r = null;
            if (this.next != null) {
                r = this.next.selectRule(n);
            }
            if (r == null && this.rule.appliesTo(n)) {
                r = this.rule;
            }
            return r;
        }

        public String select(long n) {
            Rule r = this.selectRule(n);
            if (r == null) {
                return PluralRules.KEYWORD_OTHER;
            }
            return r.getKeyword();
        }

        public Set getKeywords() {
            HashSet<String> result = new HashSet<String>();
            result.add(PluralRules.KEYWORD_OTHER);
            RuleChain rc = this;
            while (rc != null) {
                result.add(rc.rule.getKeyword());
                rc = rc.next;
            }
            return result;
        }

        public int getRepeatLimit() {
            int result = 0;
            RuleChain rc = this;
            while (rc != null) {
                result = rc.rule.updateRepeatLimit(result);
                rc = rc.next;
            }
            return result;
        }

        public String toString() {
            String s = this.rule.toString();
            if (this.next != null) {
                s = this.next.toString() + "; " + s;
            }
            return s;
        }
    }

    private static class ConstrainedRule
    implements Rule,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String keyword;
        private final Constraint constraint;

        public ConstrainedRule(String keyword, Constraint constraint) {
            this.keyword = keyword;
            this.constraint = constraint;
        }

        public Rule and(Constraint c) {
            return new ConstrainedRule(this.keyword, new AndConstraint(this.constraint, c));
        }

        public Rule or(Constraint c) {
            return new ConstrainedRule(this.keyword, new OrConstraint(this.constraint, c));
        }

        public String getKeyword() {
            return this.keyword;
        }

        public boolean appliesTo(long n) {
            return this.constraint.isFulfilled(n);
        }

        public int updateRepeatLimit(int limit) {
            return this.constraint.updateRepeatLimit(limit);
        }

        public String toString() {
            return this.keyword + ": " + this.constraint;
        }
    }

    private static class OrConstraint
    extends BinaryConstraint {
        private static final long serialVersionUID = 1405488568664762222L;

        OrConstraint(Constraint a, Constraint b) {
            super(a, b, " || ");
        }

        public boolean isFulfilled(long n) {
            return this.a.isFulfilled(n) || this.b.isFulfilled(n);
        }
    }

    private static class AndConstraint
    extends BinaryConstraint {
        private static final long serialVersionUID = 7766999779862263523L;

        AndConstraint(Constraint a, Constraint b) {
            super(a, b, " && ");
        }

        public boolean isFulfilled(long n) {
            return this.a.isFulfilled(n) && this.b.isFulfilled(n);
        }
    }

    private static abstract class BinaryConstraint
    implements Constraint,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected final Constraint a;
        protected final Constraint b;
        private final String conjunction;

        protected BinaryConstraint(Constraint a, Constraint b, String c) {
            this.a = a;
            this.b = b;
            this.conjunction = c;
        }

        public int updateRepeatLimit(int limit) {
            return this.a.updateRepeatLimit(this.b.updateRepeatLimit(limit));
        }

        public String toString() {
            return this.a.toString() + this.conjunction + this.b.toString();
        }
    }

    private static class RangeConstraint
    implements Constraint,
    Serializable {
        private static final long serialVersionUID = 1L;
        private int mod;
        private boolean within;
        private long lowerBound;
        private long upperBound;

        public boolean isFulfilled(long n) {
            if (this.mod != 0) {
                n %= (long)this.mod;
            }
            return this.within == (n >= this.lowerBound && n <= this.upperBound);
        }

        RangeConstraint(int mod, boolean within, long lowerBound, long upperBound) {
            this.mod = mod;
            this.within = within;
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
        }

        public int updateRepeatLimit(int limit) {
            int mylimit = this.mod == 0 ? (int)this.upperBound : this.mod;
            return Math.max(mylimit, limit);
        }

        public String toString() {
            return "[mod: " + this.mod + " within: " + this.within + " low: " + this.lowerBound + " high: " + this.upperBound + "]";
        }
    }

    private static interface RuleList
    extends Serializable {
        public String select(long var1);

        public Set getKeywords();

        public int getRepeatLimit();
    }

    private static interface Rule
    extends Serializable {
        public String getKeyword();

        public boolean appliesTo(long var1);

        public int updateRepeatLimit(int var1);
    }

    private static interface Constraint
    extends Serializable {
        public boolean isFulfilled(long var1);

        public int updateRepeatLimit(int var1);
    }
}

