/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.lock.jbosscache;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.lock.AbstractSessionLockManager;
import org.exoplatform.services.jcr.impl.core.lock.LockImpl;
import org.exoplatform.services.jcr.impl.core.lock.jbosscache.CacheLockImpl;
import org.exoplatform.services.jcr.impl.core.lock.jbosscache.CacheableLockManager;
import org.exoplatform.services.jcr.impl.core.lock.jbosscache.LockData;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CacheableSessionLockManager
extends AbstractSessionLockManager {
    private final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.CacheableSessionLockManager");
    private final String sessionID;
    private final Map<String, String> tokens;
    private final Map<String, LockData> lockedNodes;
    private final Set<String> pendingLocks;
    private final CacheableLockManager lockManager;

    public CacheableSessionLockManager(String sessionID, CacheableLockManager lockManager, SessionDataManager transientManager) {
        super(transientManager);
        this.sessionID = sessionID;
        this.tokens = new HashMap<String, String>();
        this.lockedNodes = new HashMap<String, LockData>();
        this.pendingLocks = new HashSet<String>();
        this.lockManager = lockManager;
    }

    public Lock addLock(NodeImpl node, boolean isDeep, boolean isSessionScoped, long timeOut) throws LockException, RepositoryException {
        String lockToken = IdGenerator.generate();
        NodeData data = (NodeData)node.getData();
        LockData lData = this.lockManager.getExactNodeOrCloseParentLock(data);
        if (lData != null) {
            if (lData.getNodeIdentifier().equals(node.getIdentifier())) {
                throw new LockException("Node already locked: " + data.getQPath());
            }
            if (lData.isDeep()) {
                throw new LockException("Parent node has deep lock.");
            }
        }
        if (isDeep && this.lockManager.getClosedChild(data) != null) {
            throw new LockException("Some child node is locked.");
        }
        String lockTokenHash = this.lockManager.getLockTokenHash(lockToken);
        lData = new LockData(node.getIdentifier(), lockTokenHash, isDeep, isSessionScoped, node.getSession().getUserID(), timeOut > 0L ? timeOut : this.lockManager.getDefaultLockTimeOut());
        this.lockedNodes.put(node.getInternalIdentifier(), lData);
        this.pendingLocks.add(node.getInternalIdentifier());
        this.tokens.put(lockToken, lData.getTokenHash());
        CacheLockImpl lock = new CacheLockImpl(node.getSession(), lData, this);
        return lock;
    }

    public void addLockToken(String lt) {
        this.tokens.put(lt, this.lockManager.getLockTokenHash(lt));
    }

    public LockImpl getLock(NodeImpl node) throws LockException, RepositoryException {
        LockData lData = this.lockManager.getExactNodeOrCloseParentLock((NodeData)node.getData());
        if (lData == null || !node.getInternalIdentifier().equals(lData.getNodeIdentifier()) && !lData.isDeep()) {
            throw new LockException("Node not locked: " + node.getData().getQPath());
        }
        return new CacheLockImpl(node.getSession(), lData, this);
    }

    public String[] getLockTokens() {
        String[] arr = new String[this.tokens.size()];
        this.tokens.keySet().toArray(arr);
        return arr;
    }

    public boolean holdsLock(NodeData node) throws RepositoryException {
        return this.lockManager.lockExist(node.getIdentifier());
    }

    protected boolean isLockedPersisted(NodeData node) throws LockException {
        LockData lData = null;
        try {
            lData = this.lockManager.getExactNodeOrCloseParentLock(node);
        }
        catch (RepositoryException e) {
            throw new LockException(e.getMessage(), (Throwable)e);
        }
        return lData != null && (node.getIdentifier().equals(lData.getNodeIdentifier()) || lData.isDeep());
    }

    protected boolean isPersistedLockHolder(NodeData node) throws RepositoryException {
        LockData lData = this.lockManager.getExactNodeOrCloseParentLock(node);
        return lData != null && this.isLockHolder(lData);
    }

    public void onCloseSession(ExtendedSession session) {
        SessionImpl sessionImpl = (SessionImpl)session;
        String[] nodeIds = new String[this.lockedNodes.size()];
        this.lockedNodes.keySet().toArray(nodeIds);
        for (String nodeId : nodeIds) {
            LockData lock = this.lockedNodes.remove(nodeId);
            if (!lock.isSessionScoped() || this.pendingLocks.contains(nodeId)) continue;
            try {
                NodeImpl node = (NodeImpl)sessionImpl.getTransientNodesManager().getItemByIdentifier(lock.getNodeIdentifier(), false);
                if (node == null) continue;
                node.unlock();
            }
            catch (UnsupportedRepositoryOperationException e) {
                this.log.error((Object)e.getLocalizedMessage());
            }
            catch (LockException e) {
                this.log.error((Object)e.getLocalizedMessage());
            }
            catch (AccessDeniedException e) {
                this.log.error((Object)e.getLocalizedMessage());
            }
            catch (RepositoryException e) {
                this.log.error((Object)e.getLocalizedMessage());
            }
        }
        this.pendingLocks.clear();
        this.tokens.clear();
        this.lockedNodes.clear();
        this.lockManager.closeSessionLockManager(this.sessionID);
    }

    public void removeLockToken(String lt) {
        this.tokens.remove(lt);
    }

    private boolean isLockHolder(LockData lockData) {
        return this.tokens.containsValue(lockData.getTokenHash());
    }

    public boolean containsPendingLock(String nodeId) {
        return this.pendingLocks.contains(nodeId);
    }

    protected String getLockToken(String tokenHash) {
        for (String token : this.tokens.keySet()) {
            if (!this.tokens.get(token).equals(tokenHash)) continue;
            return token;
        }
        return null;
    }

    public LockData getPendingLock(String nodeId) {
        if (this.pendingLocks.contains(nodeId)) {
            return this.lockedNodes.get(nodeId);
        }
        return null;
    }

    protected boolean isLockLive(String nodeIdentifier) throws LockException {
        if (this.lockManager.isLockLive(nodeIdentifier)) {
            return true;
        }
        return this.pendingLocks.contains(nodeIdentifier);
    }

    public void notifyLockPersisted(String nodeIdentifier) {
        this.pendingLocks.remove(nodeIdentifier);
    }

    public void notifyLockRemoved(String nodeIdentifier) {
        this.lockedNodes.remove(nodeIdentifier);
    }

    protected void refresh(LockData newLockData) throws LockException {
        this.lockManager.refreshLockData(newLockData);
    }

    protected boolean checkPersistedLocks(NodeData node) throws LockException {
        LockData lData = null;
        try {
            lData = this.lockManager.getExactNodeOrCloseParentLock(node);
        }
        catch (RepositoryException e) {
            throw new LockException(e.getMessage(), (Throwable)e);
        }
        if (lData == null || !node.getIdentifier().equals(lData.getNodeIdentifier()) && !lData.isDeep()) {
            return true;
        }
        return this.isLockHolder(lData);
    }
}

