/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.net.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.common.net.URLFilter;
import org.gatein.common.net.URLNavigationProvider;
import org.gatein.common.net.URLVisitor;

public class FileURLNavigationProvider
implements URLNavigationProvider {
    private Logger log = LoggerFactory.getLogger(FileURLNavigationProvider.class);
    private boolean trace = this.log.isDebugEnabled();

    public void visit(URL url, URLVisitor visitor, URLFilter filter) throws IllegalArgumentException, IOException {
        File file = new File(url.getFile()).getCanonicalFile();
        this.visit(file, visitor, filter);
    }

    private void visit(File file, URLVisitor visitor, URLFilter filter) throws IllegalArgumentException, IOException {
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        String name = file.getName();
        if (file.isDirectory()) {
            boolean visit;
            if (this.trace) {
                this.log.debug((Object)("entering directory" + file.getAbsolutePath()));
            }
            URL url = file.toURI().toURL();
            boolean bl = visit = filter == null || filter.acceptDir(url);
            if (visit) {
                visitor.startDir(url, name);
                Object[] childrenFiles = file.listFiles();
                Arrays.sort(childrenFiles);
                for (int i = 0; i < childrenFiles.length; ++i) {
                    Object childFile = childrenFiles[i];
                    this.visit((File)childFile, visitor, filter);
                }
                visitor.endDir(file.toURI().toURL(), name);
                if (this.trace) {
                    this.log.debug((Object)("leaving directory" + file.getAbsolutePath()));
                }
            }
        } else {
            URL url;
            File file2;
            if (this.trace) {
                this.log.debug((Object)("visiting file " + file.getAbsolutePath()));
            }
            if (file.equals(file2 = new File((url = file.toURI().toURL()).getFile())) && filter.acceptFile(url)) {
                visitor.file(url, name);
            } else if (this.trace) {
                this.log.debug((Object)"The file does not respect url format");
            }
        }
    }
}

