/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.Path;
import org.exoplatform.services.rest.ComponentLifecycleScope;
import org.exoplatform.services.rest.ConstructorDescriptor;
import org.exoplatform.services.rest.FieldInjector;
import org.exoplatform.services.rest.FilterDescriptor;
import org.exoplatform.services.rest.impl.ConstructorDescriptorImpl;
import org.exoplatform.services.rest.impl.FieldInjectorImpl;
import org.exoplatform.services.rest.impl.resource.PathValue;
import org.exoplatform.services.rest.resource.ResourceDescriptorVisitor;
import org.exoplatform.services.rest.uri.UriPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterDescriptorImpl
implements FilterDescriptor {
    private final Class<?> filterClass;
    private final PathValue path;
    private final UriPattern uriPattern;
    private final List<ConstructorDescriptor> constructors;
    private final List<FieldInjector> fields;

    public FilterDescriptorImpl(Class<?> filterClass) {
        this(filterClass, ComponentLifecycleScope.PER_REQUEST);
    }

    public FilterDescriptorImpl(Object filter) {
        this(filter.getClass(), ComponentLifecycleScope.SINGLETON);
    }

    private FilterDescriptorImpl(Class<?> filterClass, ComponentLifecycleScope scope) {
        Path p = filterClass.getAnnotation(Path.class);
        if (p != null) {
            this.path = new PathValue(p.value());
            this.uriPattern = new UriPattern(p.value());
        } else {
            this.path = null;
            this.uriPattern = null;
        }
        this.filterClass = filterClass;
        this.constructors = new ArrayList<ConstructorDescriptor>();
        this.fields = new ArrayList<FieldInjector>();
        if (scope == ComponentLifecycleScope.PER_REQUEST) {
            for (Constructor<?> constructor : filterClass.getConstructors()) {
                this.constructors.add(new ConstructorDescriptorImpl(filterClass, constructor));
            }
            if (this.constructors.size() == 0) {
                String msg = "Not found accepted constructors for filter class " + filterClass.getName();
                throw new RuntimeException(msg);
            }
            if (this.constructors.size() > 1) {
                Collections.sort(this.constructors, ConstructorDescriptorImpl.CONSTRUCTOR_COMPARATOR);
            }
            for (AccessibleObject accessibleObject : filterClass.getDeclaredFields()) {
                this.fields.add(new FieldInjectorImpl(filterClass, (Field)accessibleObject));
            }
        }
    }

    @Override
    public void accept(ResourceDescriptorVisitor visitor) {
        visitor.visitFilterDescriptor(this);
    }

    @Override
    public List<ConstructorDescriptor> getConstructorDescriptors() {
        return this.constructors;
    }

    @Override
    public List<FieldInjector> getFieldInjectors() {
        return this.fields;
    }

    @Override
    public Class<?> getObjectClass() {
        return this.filterClass;
    }

    @Override
    public PathValue getPathValue() {
        return this.path;
    }

    @Override
    public UriPattern getUriPattern() {
        return this.uriPattern;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[ FilterDescriptorImpl: ");
        sb.append("path: " + this.getPathValue() + "; ").append("filter class: " + this.getObjectClass() + "; ").append(this.getConstructorDescriptors() + "; ").append(this.getFieldInjectors()).append(" ]");
        return sb.toString();
    }
}

