/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.map;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;

public abstract class AbstractMap
implements Map {
    protected abstract Object getAttribute(String var1);

    protected abstract void setAttribute(String var1, Object var2);

    protected abstract void removeAttribute(String var1);

    protected abstract Enumeration getAttributeNames();

    public int size() {
        int n = 0;
        Enumeration keys = this.getAttributeNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            ++n;
        }
        return n;
    }

    public boolean isEmpty() {
        return !this.getAttributeNames().hasMoreElements();
    }

    public boolean containsKey(Object key) {
        return this.getAttribute((String)key) != null;
    }

    public boolean containsValue(Object value) {
        boolean match = false;
        Enumeration keys = this.getAttributeNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object val = this.getAttribute(key);
            if (!value.equals(val)) continue;
            match = true;
            break;
        }
        return match;
    }

    public Object get(Object key) {
        return this.getAttribute((String)key);
    }

    public Object put(Object key, Object value) {
        Object result = null;
        if (this.containsKey(key)) {
            result = this.getAttribute((String)key);
        }
        this.setAttribute((String)key, value);
        return result;
    }

    public Object remove(Object key) {
        Object result = this.getAttribute((String)key);
        this.removeAttribute((String)key);
        return result;
    }

    public void putAll(Map t) {
        for (String key : t.keySet()) {
            Object value = t.get(key);
            this.put(key, value);
        }
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        Enumeration keys = this.getAttributeNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            b.append(key).append("\n");
        }
        return b.toString();
    }
}

