/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.connector.collaboration;

import java.io.FileNotFoundException;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

@Path(value="/contents/editing/")
public class InlineEditingService
implements ResourceContainer {
    private static Log log = ExoLogger.getLogger(InlineEditingService.class);
    public static final String EXO_TITLE = "exo:title".intern();
    public static final String EXO_SUMMARY = "exo:summary".intern();
    public static final String EXO_RSS_ENABLE = "exo:rss-enable".intern();
    public static final String POST_EDIT_CONTENT_EVENT = "CmsService.event.postEdit".intern();

    @POST
    @Path(value="/title/")
    public Response editTitle(@FormParam(value="newValue") String newTitle, @QueryParam(value="repositoryName") String repositoryName, @QueryParam(value="workspaceName") String workspaceName, @QueryParam(value="nodeUIID") String nodeUIID, @QueryParam(value="siteName") String siteName) {
        return this.modifyProperty(EXO_TITLE, newTitle, repositoryName, workspaceName, nodeUIID, siteName);
    }

    @POST
    @Path(value="/summary/")
    public Response editSummary(@FormParam(value="newValue") String newSummary, @QueryParam(value="repositoryName") String repositoryName, @QueryParam(value="workspaceName") String workspaceName, @QueryParam(value="nodeUIID") String nodeUIID, @QueryParam(value="siteName") String siteName) {
        return this.modifyProperty(EXO_SUMMARY, newSummary, repositoryName, workspaceName, nodeUIID, siteName);
    }

    @POST
    @Path(value="/property/")
    public Response editProperty(@QueryParam(value="propertyName") String propertyName, @FormParam(value="newValue") String newValue, @QueryParam(value="repositoryName") String repositoryName, @QueryParam(value="workspaceName") String workspaceName, @QueryParam(value="nodeUIID") String nodeUIID, @QueryParam(value="siteName") String siteName) {
        return this.modifyProperty(propertyName, newValue, repositoryName, workspaceName, nodeUIID, siteName);
    }

    public Response modifyProperty(String propertyName, String newValue, String repositoryName, String workspaceName, String nodeUIID, String siteName) {
        try {
            SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
            RepositoryService repositoryService = (RepositoryService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RepositoryService.class);
            ManageableRepository manageableRepository = repositoryService.getRepository(repositoryName);
            Session session = sessionProvider.getSession(workspaceName, manageableRepository);
            try {
                Node node = session.getNodeByUUID(nodeUIID);
                if (!this.sameValue(newValue, node, propertyName) && newValue.length() > 0) {
                    newValue = Text.escapeIllegalJcrChars((String)newValue.trim());
                    ExoContainer container = ExoContainerContext.getCurrentContainer();
                    PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
                    String containerName = containerInfo.getContainerName();
                    ListenerService listenerService = (ListenerService)WCMCoreUtils.getService(ListenerService.class, (String)containerName);
                    if (propertyName.equals(EXO_TITLE) && !node.hasProperty(EXO_TITLE)) {
                        node.addMixin(EXO_RSS_ENABLE);
                    }
                    node.setProperty(propertyName, newValue);
                    node.save();
                    ConversationState conversationState = ConversationState.getCurrent();
                    conversationState.setAttribute("siteName", (Object)siteName);
                    listenerService.broadcast(POST_EDIT_CONTENT_EVENT, null, (Object)node);
                }
                session.save();
            }
            catch (AccessDeniedException ace) {
                log.error((Object)"AccessDeniedException: ", (Throwable)ace);
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            catch (FileNotFoundException fie) {
                log.error((Object)"FileNotFoundException: ", (Throwable)fie);
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            catch (LockException lockex) {
                log.error((Object)"LockException", (Throwable)lockex);
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error when perform edit title: ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    private boolean sameValue(String newValue, Node node, String propertyName) throws Exception {
        if (!node.hasProperty(propertyName)) {
            return newValue == null || newValue.length() == 0;
        }
        return node.getProperty(propertyName).getString().equals(newValue);
    }
}

