/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.drives;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.drives.UIDriveInputSet;
import org.exoplatform.ecm.webui.component.admin.drives.UIDriveList;
import org.exoplatform.ecm.webui.component.admin.drives.UIDriveManager;
import org.exoplatform.ecm.webui.component.admin.drives.UIViewsInputSet;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTabPane;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormTabPane.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={RefreshActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddPermissionActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemovePermissionActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddPathActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddIconActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ChangeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ChooseNodeTypeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveNodeTypeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectTabActionListener.class}, phase=Event.Phase.DECODE)})
public class UIDriveForm
extends UIFormTabPane
implements UISelectable {
    private boolean isAddNew_ = true;
    public static final String[] ACTIONS = new String[]{"Save", "Refresh", "Cancel"};
    public static final String POPUP_DRIVEPERMISSION = "PopupDrivePermission";
    public static final String POPUP_NODETYPE_SELECTOR = "PopupNodeTypeSelector";
    private String membershipString = "";
    private String nodeTypes = "";
    public static final String ANY_PERMISSION = "*";

    public UIDriveForm() throws Exception {
        super("UIDriveForm");
        UIDriveInputSet driveInputSet = new UIDriveInputSet("DriveInputSet");
        UIFormSelectBox selectBox = (UIFormSelectBox)driveInputSet.getChildById("workspace");
        selectBox.setOnChange("Change");
        this.addUIFormInput((UIFormInputSet)driveInputSet);
        this.setSelectedTab(driveInputSet.getId());
        UIViewsInputSet viewInputSet = new UIViewsInputSet("ViewsInputSet");
        this.addUIFormInput(viewInputSet);
        this.setActions(ACTIONS);
    }

    public String getLabel(ResourceBundle res, String id) {
        try {
            return res.getString("UIDriveForm.label." + id);
        }
        catch (MissingResourceException ex) {
            return id + " ";
        }
    }

    public void doSelect(String selectField, Object value) {
        UIFormStringInput uiStringInput = this.getUIStringInput(selectField);
        if (selectField.equals("permissions")) {
            String membership = value.toString();
            String valuePermissions = (String)uiStringInput.getValue();
            List<Object> permissionsList = new ArrayList();
            StringBuilder newsPermissions = new StringBuilder();
            if (valuePermissions != null) {
                String[] permissionsArray = valuePermissions.split(",");
                permissionsList = Arrays.asList(permissionsArray);
                if (permissionsList.size() > 0) {
                    for (String string : permissionsList) {
                        if (newsPermissions.length() > 0) {
                            newsPermissions.append(",");
                        }
                        newsPermissions.append(string.trim());
                    }
                }
                if (!permissionsList.contains(membership)) {
                    if (newsPermissions.length() > 0) {
                        newsPermissions.append(",").append(membership.trim());
                    } else {
                        newsPermissions.append(membership.trim());
                    }
                }
            }
            uiStringInput.setValue((Object)newsPermissions.toString());
        } else {
            uiStringInput.setValue((Object)value.toString());
        }
        UIDriveManager uiContainer = (UIDriveManager)this.getAncestorOfType(UIDriveManager.class);
        for (UIComponent uiChild : uiContainer.getChildren()) {
            if (!uiChild.getId().equals(POPUP_DRIVEPERMISSION) && !uiChild.getId().equals("JCRBrowser") && !uiChild.getId().equals("JCRBrowserAssets") && !uiChild.getId().equals(POPUP_NODETYPE_SELECTOR)) continue;
            UIPopupWindow uiPopup = (UIPopupWindow)uiContainer.getChildById(uiChild.getId());
            uiPopup.setRendered(false);
            uiPopup.setShow(false);
        }
    }

    public void refresh(String driveName) throws Exception {
        String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        DriveData drive = null;
        if (driveName == null) {
            this.isAddNew_ = true;
        } else {
            this.isAddNew_ = false;
            this.setActions(new String[]{"Save", "Cancel"});
            drive = ((ManageDriveService)this.getApplicationComponent(ManageDriveService.class)).getDriveByName(driveName, repository);
        }
        ((UIDriveInputSet)this.getChild(UIDriveInputSet.class)).update(drive);
        ((UIViewsInputSet)this.getChild(UIViewsInputSet.class)).update(drive);
    }

    public String getWorkspaceEntries(String selectedWorkspace, String repository) throws Exception {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ArrayList wsEntries = repositoryService.getRepository(repository).getConfiguration().getWorkspaceEntries();
        String wsInitRootNodeType = null;
        for (WorkspaceEntry wsEntry : wsEntries) {
            if (!wsEntry.getName().equals(selectedWorkspace)) continue;
            wsInitRootNodeType = wsEntry.getAutoInitializedRootNt();
            break;
        }
        return wsInitRootNodeType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectTabActionListener
    extends EventListener<UIDriveForm> {
        public void execute(Event<UIDriveForm> event) throws Exception {
            UIDriveForm uiView = (UIDriveForm)((Object)event.getSource());
            UIDriveManager uiMetaManager = (UIDriveManager)uiView.getAncestorOfType(UIDriveManager.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMetaManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveNodeTypeActionListener
    extends EventListener<UIDriveForm> {
        public void execute(Event<UIDriveForm> event) throws Exception {
            UIDriveForm uiDriveForm = (UIDriveForm)((Object)event.getSource());
            uiDriveForm.nodeTypes = "";
            uiDriveForm.getUIStringInput("allowNodeTypesOnTree").setValue(null);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiDriveForm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChooseNodeTypeActionListener
    extends EventListener<UIDriveForm> {
        public void execute(Event<UIDriveForm> event) throws Exception {
            UIDriveForm uiDriveForm = (UIDriveForm)((Object)event.getSource());
            UIDriveManager uiManager = (UIDriveManager)uiDriveForm.getAncestorOfType(UIDriveManager.class);
            String nodeTypes = (String)uiDriveForm.getUIStringInput("allowNodeTypesOnTree").getValue();
            if (nodeTypes != null && uiDriveForm.membershipString.indexOf(nodeTypes) < 0) {
                if (uiDriveForm.nodeTypes.length() > 0) {
                    uiDriveForm.nodeTypes = uiDriveForm.nodeTypes + ("," + nodeTypes);
                } else {
                    uiDriveForm.nodeTypes = uiDriveForm.nodeTypes + nodeTypes;
                }
            }
            uiDriveForm.getUIStringInput("allowNodeTypesOnTree").setValue((Object)uiDriveForm.nodeTypes);
            uiManager.initPopupNodeTypeSelector(uiDriveForm.nodeTypes);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeActionListener
    extends EventListener<UIDriveForm> {
        public void execute(Event<UIDriveForm> event) throws Exception {
            UIDriveForm uiDriveForm = (UIDriveForm)((Object)event.getSource());
            String driverName = (String)uiDriveForm.getUIStringInput("name").getValue();
            String repository = ((UIECMAdminPortlet)uiDriveForm.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
            String selectedWorkspace = (String)uiDriveForm.getUIStringInput("workspace").getValue();
            UIDriveInputSet driveInputSet = (UIDriveInputSet)uiDriveForm.getChild(UIDriveInputSet.class);
            UIDriveManager uiManager = (UIDriveManager)uiDriveForm.getAncestorOfType(UIDriveManager.class);
            ManageDriveService manageDriveService = (ManageDriveService)uiDriveForm.getApplicationComponent(ManageDriveService.class);
            RepositoryService repositoryService = (RepositoryService)uiDriveForm.getApplicationComponent(RepositoryService.class);
            ArrayList wsEntries = repositoryService.getCurrentRepository().getConfiguration().getWorkspaceEntries();
            String wsInitRootNodeType = null;
            for (WorkspaceEntry wsEntry : wsEntries) {
                if (!wsEntry.getName().equals(selectedWorkspace)) continue;
                wsInitRootNodeType = wsEntry.getAutoInitializedRootNt();
            }
            TemplateService templateService = (TemplateService)uiDriveForm.getApplicationComponent(TemplateService.class);
            Set setFoldertypes = templateService.getAllowanceFolderType();
            ArrayList<SelectItemOption> foldertypeOptions = new ArrayList<SelectItemOption>();
            RequestContext context = RequestContext.getCurrentInstance();
            ResourceBundle res = context.getApplicationResourceBundle();
            String label = null;
            for (String folderType : setFoldertypes) {
                try {
                    label = res.getString(driveInputSet.getId() + ".label." + folderType.replace(":", "_"));
                }
                catch (MissingResourceException mi) {
                    label = folderType;
                }
                foldertypeOptions.add(new SelectItemOption(label, (Object)folderType));
            }
            ArrayList<SelectItemOption> folderOptions = new ArrayList<SelectItemOption>();
            UIFormSelectBox uiInput = (UIFormSelectBox)driveInputSet.getUIInput("allowCreateFolders");
            if (wsInitRootNodeType != null && wsInitRootNodeType.equals("nt:folder")) {
                folderOptions.add(new SelectItemOption("Folder", (Object)"nt:folder"));
            } else {
                folderOptions.addAll(foldertypeOptions);
            }
            uiInput.setOptions(folderOptions);
            if (!uiDriveForm.isAddNew_) {
                DriveData drive = manageDriveService.getDriveByName(driverName, repository);
                String defaultPath = drive.getHomePath();
                if (!drive.getWorkspace().equals(selectedWorkspace)) {
                    defaultPath = "/";
                }
                uiDriveForm.getUIStringInput("homePath").setValue((Object)defaultPath);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddIconActionListener
    extends EventListener<UIDriveForm> {
        public void execute(Event<UIDriveForm> event) throws Exception {
            UIDriveForm uiDriveForm = (UIDriveForm)((Object)event.getSource());
            UIDriveManager uiManager = (UIDriveManager)uiDriveForm.getAncestorOfType(UIDriveManager.class);
            UIDriveInputSet driveInputSet = (UIDriveInputSet)uiDriveForm.getChild(UIDriveInputSet.class);
            String workspace = (String)driveInputSet.getUIFormSelectBox("workspace").getValue();
            uiManager.initPopupJCRBrowserAssets(workspace);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddPathActionListener
    extends EventListener<UIDriveForm> {
        public void execute(Event<UIDriveForm> event) throws Exception {
            UIDriveForm uiDriveForm = (UIDriveForm)((Object)event.getSource());
            UIDriveManager uiManager = (UIDriveManager)uiDriveForm.getAncestorOfType(UIDriveManager.class);
            UIDriveInputSet driveInputSet = (UIDriveInputSet)uiDriveForm.getChild(UIDriveInputSet.class);
            String workspace = (String)driveInputSet.getUIFormSelectBox("workspace").getValue();
            uiManager.initPopupJCRBrowser(workspace, true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemovePermissionActionListener
    extends EventListener<UIDriveForm> {
        public void execute(Event<UIDriveForm> event) throws Exception {
            UIDriveForm uiDriveForm = (UIDriveForm)((Object)event.getSource());
            uiDriveForm.membershipString = "";
            uiDriveForm.getUIStringInput("permissions").setValue(null);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiDriveForm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddPermissionActionListener
    extends EventListener<UIDriveForm> {
        public void execute(Event<UIDriveForm> event) throws Exception {
            UIDriveForm uiDriveForm = (UIDriveForm)((Object)event.getSource());
            UIDriveManager uiManager = (UIDriveManager)uiDriveForm.getAncestorOfType(UIDriveManager.class);
            String membership = (String)uiDriveForm.getUIStringInput("permissions").getValue();
            if (membership != null && uiDriveForm.membershipString.indexOf(membership) < 0) {
                if (uiDriveForm.membershipString.length() > 0) {
                    uiDriveForm.membershipString = uiDriveForm.membershipString + ("," + membership);
                } else {
                    uiDriveForm.membershipString = uiDriveForm.membershipString + membership;
                }
            }
            uiDriveForm.getUIStringInput("permissions").setValue((Object)uiDriveForm.membershipString);
            uiManager.initPopupPermission(uiDriveForm.membershipString);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RefreshActionListener
    extends EventListener<UIDriveForm> {
        public void execute(Event<UIDriveForm> event) throws Exception {
            ((UIDriveForm)((Object)event.getSource())).refresh(null);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)event.getSource());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIDriveForm> {
        public void execute(Event<UIDriveForm> event) throws Exception {
            UIDriveForm uiDriveForm = (UIDriveForm)((Object)event.getSource());
            uiDriveForm.refresh(null);
            UIDriveManager uiDriveManager = (UIDriveManager)uiDriveForm.getAncestorOfType(UIDriveManager.class);
            uiDriveManager.removeChildById(UIDriveForm.POPUP_DRIVEPERMISSION);
            uiDriveManager.removeChildById("AddDriveManagerPopup");
            uiDriveManager.removeChildById("EditDriveManagerPopup");
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiDriveManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIDriveForm> {
        /*
         * Unable to fully structure code
         */
        public void execute(Event<UIDriveForm> event) throws Exception {
            uiDriveForm = (UIDriveForm)event.getSource();
            repository = ((UIECMAdminPortlet)uiDriveForm.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
            rservice = (RepositoryService)uiDriveForm.getApplicationComponent(RepositoryService.class);
            driveInputSet = (UIDriveInputSet)uiDriveForm.getChild(UIDriveInputSet.class);
            uiApp = (UIApplication)uiDriveForm.getAncestorOfType(UIApplication.class);
            name = ((String)driveInputSet.getUIStringInput("name").getValue()).trim();
            if (name == null || name.trim().length() == 0) {
                uiApp.addMessage(new ApplicationMessage("UIDriveForm.msg.name-null", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            for (String filterChar : arrFilterChar = new String[]{"&", "$", "@", "'", ":", "]", "[", "*", "%", "!", "\""}) {
                if (name.indexOf(filterChar) <= -1) continue;
                uiApp.addMessage(new ApplicationMessage("UIDriveForm.msg.fileName-invalid", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            workspace = (String)driveInputSet.getUIFormSelectBox("workspace").getValue();
            path = (String)driveInputSet.getUIStringInput("homePath").getValue();
            if (path == null || path.trim().length() == 0) {
                path = "/";
            }
            session = null;
            try {
                session = rservice.getCurrentRepository().getSystemSession(workspace);
                userId = Util.getPortalRequestContext().getRemoteUser();
                pathReal = path.replace("${userId}", userId);
                session.getItem(pathReal);
                session.logout();
            }
            catch (Exception e) {
                if (session != null) {
                    session.logout();
                }
                uiApp.addMessage(new ApplicationMessage("UIDriveForm.msg.workspace-path-invalid", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            viewReferences = driveInputSet.getUIFormCheckBoxInput("viewPreferences").isChecked();
            viewSideBar = driveInputSet.getUIFormCheckBoxInput("viewSideBar").isChecked();
            showHiddenNode = driveInputSet.getUIFormCheckBoxInput("showHiddenNode").isChecked();
            viewNonDocument = driveInputSet.getUIFormCheckBoxInput("viewNonDocument").isChecked();
            allowCreateFolders = driveInputSet.getUIFormSelectBox("allowCreateFolders").getSelectedValues();
            if (allowCreateFolders == null || allowCreateFolders.length == 0) {
                uiApp.addMessage(new ApplicationMessage("UIDriveForm.msg.allowedCreateFolder", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            foldertypes = new StringBuilder();
            for (String allowCreateFolder : allowCreateFolders) {
                foldertypes.append(allowCreateFolder).append(",");
            }
            if (foldertypes.toString().endsWith(",")) {
                foldertypes.deleteCharAt(foldertypes.length() - 1);
            }
            viewsInputSet = (UIViewsInputSet)uiDriveForm.getChild(UIViewsInputSet.class);
            views = viewsInputSet.getViewsSelected();
            permissions = (String)driveInputSet.getUIStringInput("permissions").getValue();
            if (permissions == null || permissions.trim().length() == 0) {
                uiApp.addMessage(new ApplicationMessage("UIDriveForm.msg.permission-null", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            oservice = (OrganizationService)uiDriveForm.getApplicationComponent(OrganizationService.class);
            arrPermissions = permissions.split(",");
            collection = oservice.getMembershipTypeHandler().findMembershipTypes();
            listMemberhip = new ArrayList<String>(5);
            for (E obj : collection) {
                listMemberhip.add(((MembershipType)obj).getName());
            }
            listMemberhip.add("*");
            for (String itemPermission : arrPermissions) {
                if (itemPermission.length() == 0) {
                    uiApp.addMessage(new ApplicationMessage("UIDriveForm.msg.permission-path-invalid", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
                if (!itemPermission.contains(":")) continue;
                permission = itemPermission.split(":");
                if (permission[0] == null || permission[0].length() == 0) {
                    uiApp.addMessage(new ApplicationMessage("UIDriveForm.msg.permission-path-invalid", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
                if (!listMemberhip.contains(permission[0])) {
                    uiApp.addMessage(new ApplicationMessage("UIDriveForm.msg.permission-path-invalid", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
                if (permission[1] == null || permission[1].length() == 0) {
                    uiApp.addMessage(new ApplicationMessage("UIDriveForm.msg.permission-path-invalid", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
                if (oservice.getGroupHandler().findGroupById(permission[1]) != null) continue;
                uiApp.addMessage(new ApplicationMessage("UIDriveForm.msg.permission-path-invalid", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            dservice_ = (ManageDriveService)uiDriveForm.getApplicationComponent(ManageDriveService.class);
            if (UIDriveForm.access$000(uiDriveForm) && dservice_.getDriveByName(name, repository) != null) {
                uiApp.addMessage(new ApplicationMessage("UIDriveForm.msg.drive-exists", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            iconPath = (String)driveInputSet.getUIStringInput("icon").getValue();
            if (iconPath != null && iconPath.trim().length() > 0) {
                jcrSession = null;
                try {
                    if (iconPath.indexOf(":/") <= -1) ** GOTO lbl115
                    paths = iconPath.split(":/");
                    jcrSession = rservice.getCurrentRepository().getSystemSession(paths[0]);
                    jcrSession.getItem("/" + paths[1]);
                    jcrSession.logout();
                }
                catch (Exception e) {
                    if (jcrSession != null) {
                        jcrSession.logout();
                    }
                    uiApp.addMessage(new ApplicationMessage("UIDriveForm.msg.icon-not-found", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
            } else {
                iconPath = "";
            }
lbl115:
            // 3 sources

            if ((allowNodeTypesOnTree = (String)driveInputSet.getUIStringInput("allowNodeTypesOnTree").getValue()) == null || allowNodeTypesOnTree.length() == 0) {
                allowNodeTypesOnTree = "*";
            }
            dservice_.addDrive(name, workspace, permissions, path, views, iconPath, viewReferences, viewNonDocument, viewSideBar, showHiddenNode, foldertypes.toString(), allowNodeTypesOnTree);
            uiManager = (UIDriveManager)uiDriveForm.getAncestorOfType(UIDriveManager.class);
            uiDriveList = (UIDriveList)uiManager.getChild(UIDriveList.class);
            uiDriveList.updateDriveListGrid(uiDriveList.getUIPageIterator().getCurrentPage());
            uiDriveForm.refresh(null);
            uiDriveManager = (UIDriveManager)uiDriveForm.getAncestorOfType(UIDriveManager.class);
            uiDriveManager.removeChildById("PopupDrivePermission");
            uiDriveManager.removeChildById("AddDriveManagerPopup");
            uiDriveManager.removeChildById("EditDriveManagerPopup");
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiDriveManager);
        }
    }
}

