/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.taxonomy;

import javax.jcr.RepositoryException;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyManagerTrees;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyTreeContainer;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyTreeCreateChild;
import org.exoplatform.ecm.webui.form.validator.ECMNameValidator;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.taxonomy.TaxonomyTreeData;
import org.exoplatform.services.cms.taxonomy.impl.TaxonomyNodeAlreadyExistsException;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UITaxonomyTreeCreateChildForm
extends UIForm {
    private static final String FIELD_PARENT = "parentPath";
    private static final String FIELD_NAME = "taxonomyName";

    public UITaxonomyTreeCreateChildForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormInputInfo(FIELD_PARENT, FIELD_PARENT, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_NAME, FIELD_NAME, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(ECMNameValidator.class, new Object[0]));
    }

    public void setParent(String path) {
        this.getUIFormInputInfo(FIELD_PARENT).setValue((Object)path);
        this.getUIStringInput(FIELD_NAME).setValue(null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UITaxonomyTreeCreateChildForm> {
        public void execute(Event<UITaxonomyTreeCreateChildForm> event) throws Exception {
            UITaxonomyTreeCreateChildForm uiForm = (UITaxonomyTreeCreateChildForm)((Object)event.getSource());
            UIPopupWindow uiPopup = (UIPopupWindow)uiForm.getParent();
            uiPopup.setRendered(false);
            uiPopup.setShow(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UITaxonomyTreeCreateChildForm> {
        public void execute(Event<UITaxonomyTreeCreateChildForm> event) throws Exception {
            UITaxonomyTreeCreateChildForm uiForm = (UITaxonomyTreeCreateChildForm)((Object)event.getSource());
            UITaxonomyTreeCreateChild uiCreateChild = (UITaxonomyTreeCreateChild)uiForm.getAncestorOfType(UITaxonomyTreeCreateChild.class);
            UITaxonomyTreeContainer uiTaxonomyTreeContainer = (UITaxonomyTreeContainer)uiForm.getAncestorOfType(UITaxonomyTreeContainer.class);
            UITaxonomyManagerTrees uiTaxonomyManageTrees = (UITaxonomyManagerTrees)uiForm.getAncestorOfType(UITaxonomyManagerTrees.class);
            TaxonomyTreeData taxoTreeData = uiTaxonomyTreeContainer.getTaxonomyTreeData();
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            String name = (String)uiForm.getUIStringInput(UITaxonomyTreeCreateChildForm.FIELD_NAME).getValue();
            if (name == null || name.trim().length() == 0) {
                uiApp.addMessage(new ApplicationMessage("UITaxonomyTreeCreateChildForm.msg.name-null", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            if (!Utils.isNameValid((String)(name = name.trim()), (String[])new String[]{"&", "$", "@", ",", ":", "]", "[", "*", "%", "!"})) {
                uiApp.addMessage(new ApplicationMessage("UITaxonomyTreeCreateChildForm.msg.name-invalid", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            if (name.length() > 30) {
                uiApp.addMessage(new ApplicationMessage("UITaxonomyTreeCreateChildForm.msg.name-too-long", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            try {
                TaxonomyService taxonomyService = (TaxonomyService)uiForm.getApplicationComponent(TaxonomyService.class);
                String parentPath = (String)uiForm.getUIFormInputInfo(UITaxonomyTreeCreateChildForm.FIELD_PARENT).getValue();
                taxonomyService.addTaxonomyNode(taxoTreeData.getTaxoTreeWorkspace(), parentPath, name, Util.getPortalRequestContext().getRemoteUser());
                uiCreateChild.update();
            }
            catch (TaxonomyNodeAlreadyExistsException e) {
                Object[] arg = new Object[]{name};
                uiApp.addMessage(new ApplicationMessage("UITaxonomyTreeCreateChildForm.msg.exist", arg, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (RepositoryException e) {
                Object[] arg = new Object[]{name};
                uiApp.addMessage(new ApplicationMessage("UITaxonomyTreeCreateChildForm.msg.error", arg, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            uiForm.reset();
            UIPopupWindow uiPopup = (UIPopupWindow)uiForm.getParent();
            uiPopup.setRendered(false);
            uiPopup.setShow(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTaxonomyManageTrees);
        }
    }
}

