/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.datamodel;

import org.exoplatform.commons.utils.QName;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;

public class InternalQName
extends QName {
    public InternalQName(String namespace, String name) {
        super(InternalQName.safeIntern(namespace), InternalQName.safeIntern(name));
    }

    private static String safeIntern(String s) {
        return s != null ? s.intern() : null;
    }

    public static InternalQName parse(String qName) throws IllegalNameException {
        if (!qName.startsWith("[")) {
            throw new IllegalNameException("Invalid Internal QName '" + qName + "' Should start of '['");
        }
        int uriStart = 0;
        int uriFinish = qName.indexOf("]", uriStart);
        if (uriFinish == -1) {
            throw new IllegalNameException("Invalid Internal QName '" + qName + "' No closed ']'");
        }
        String uri = qName.substring(uriStart + 1, uriFinish);
        String localName = qName.substring(uriFinish + 1, qName.length());
        return new InternalQName(uri, localName);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof InternalQName) {
            InternalQName that = (InternalQName)((Object)o);
            if (this.hashCode == that.hashCode) {
                String s1 = this.getAsString();
                String s2 = that.getAsString();
                return s1.equals(s2);
            }
        }
        return false;
    }
}

