/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import javax.jcr.LoginException;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.security.JCRRuntimePermissions;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.SessionReference;
import org.exoplatform.services.jcr.impl.core.TrackedSession;
import org.exoplatform.services.jcr.impl.core.TrackedXASession;
import org.exoplatform.services.jcr.impl.core.XASessionImpl;
import org.exoplatform.services.jcr.impl.dataflow.session.TransactionableResourceManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.transaction.TransactionService;

public class SessionFactory {
    protected static Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.SessionFactory");
    private final ExoContainer container;
    private final TransactionService tService;
    private final String workspaceName;
    private final TransactionableResourceManager txResourceManager;

    public SessionFactory(TransactionService tService, WorkspaceEntry config, ExoContainerContext containerContext) {
        this.container = containerContext.getContainer();
        this.workspaceName = config.getName();
        this.tService = tService;
        this.txResourceManager = new TransactionableResourceManager();
        boolean tracking = "true".equalsIgnoreCase(PrivilegedSystemHelper.getProperty((String)"exo.jcr.session.tracking.active", (String)"false"));
        if (tracking) {
            long maxAgeMillis = 0L;
            String maxagevalue = PrivilegedSystemHelper.getProperty((String)"exo.jcr.jcr.session.tracking.maxage");
            if (maxagevalue != null) {
                try {
                    maxAgeMillis = Long.parseLong(maxagevalue) * 1000L;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (maxAgeMillis <= 0L) {
                maxAgeMillis = 120000L;
            }
            try {
                SessionReference.start(maxAgeMillis);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public SessionFactory(WorkspaceEntry config, ExoContainerContext containerContext) {
        this(null, config, containerContext);
    }

    SessionImpl createSession(ConversationState user) throws RepositoryException, LoginException {
        SecurityManager security;
        if (IdentityConstants.SYSTEM.equals(user.getIdentity().getUserId()) && (security = System.getSecurityManager()) != null) {
            security.checkPermission(JCRRuntimePermissions.CREATE_SYSTEM_SESSION_PERMISSION);
        }
        if (this.tService == null) {
            if (SessionReference.isStarted()) {
                return new TrackedSession(this.workspaceName, user, this.container);
            }
            return new SessionImpl(this.workspaceName, user, this.container);
        }
        if (SessionReference.isStarted()) {
            return new TrackedXASession(this.workspaceName, user, this.container, this.tService, this.txResourceManager);
        }
        return new XASessionImpl(this.workspaceName, user, this.container, this.tService, this.txResourceManager);
    }
}

