/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.impl.rdbms;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Calendar;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.ValueStorageEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.backup.BackupConfig;
import org.exoplatform.services.jcr.ext.backup.BackupOperationException;
import org.exoplatform.services.jcr.ext.backup.impl.AbstractFullBackupJob;
import org.exoplatform.services.jcr.ext.backup.impl.FileNameProducer;
import org.exoplatform.services.jcr.impl.storage.jdbc.backup.BackupException;
import org.exoplatform.services.jcr.impl.storage.jdbc.backup.Backupable;
import org.exoplatform.services.jcr.impl.storage.jdbc.backup.ResumeException;
import org.exoplatform.services.jcr.impl.storage.jdbc.backup.SuspendException;
import org.exoplatform.services.jcr.impl.storage.jdbc.backup.Suspendable;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class FullBackupJob
extends AbstractFullBackupJob {
    public static final String INDEX_DIR = "index";
    public static final String SYSTEM_INDEX_DIR = "index_system";
    public static final String VALUE_STORAGE_DIR = "values";
    protected static Log log = ExoLogger.getLogger("exo.jcr.component.ext.FullBackupJob");

    protected URL createStorage() throws FileNotFoundException, IOException {
        FileNameProducer fnp = new FileNameProducer(this.config.getRepository(), this.config.getWorkspace(), PrivilegedFileHelper.getAbsolutePath(this.config.getBackupDir()), this.timeStamp, true, true);
        return new URL("file:" + PrivilegedFileHelper.getAbsolutePath(fnp.getNextFile()));
    }

    public void init(ManageableRepository repository, String workspaceName, BackupConfig config, Calendar timeStamp) {
        this.repository = repository;
        this.workspaceName = workspaceName;
        this.config = config;
        this.timeStamp = timeStamp;
        try {
            this.url = this.createStorage();
        }
        catch (FileNotFoundException e) {
            log.error("Full backup initialization failed ", e);
            this.notifyError("Full backup initialization failed ", e);
        }
        catch (IOException e) {
            log.error("Full backup initialization failed ", e);
            this.notifyError("Full backup initialization failed ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block27: {
            this.notifyListeners();
            List backupableComponents = this.repository.getWorkspaceContainer(this.workspaceName).getComponentInstancesOfType(Backupable.class);
            List suspendableComponents = this.repository.getWorkspaceContainer(this.workspaceName).getComponentInstancesOfType(Suspendable.class);
            try {
                WorkspaceEntry workspaceEntry = null;
                for (WorkspaceEntry entry : this.repository.getConfiguration().getWorkspaceEntries()) {
                    if (!entry.getName().equals(this.workspaceName)) continue;
                    workspaceEntry = entry;
                    break;
                }
                if (workspaceEntry == null) {
                    throw new RepositoryConfigurationException("Workpace name " + this.workspaceName + " not found in repository configuration");
                }
                for (Suspendable component : suspendableComponents) {
                    component.suspend();
                }
                for (Suspendable component : backupableComponents) {
                    component.backup(new File(this.getStorageURL().getFile()));
                }
                this.backupValueStorage(workspaceEntry);
                this.backupIndex(workspaceEntry);
                Object var7_11 = null;
            }
            catch (Throwable throwable) {
                Object var7_17 = null;
                for (Suspendable component : suspendableComponents) {
                    try {
                        component.resume();
                    }
                    catch (ResumeException e2) {
                        log.error("Full backup failed " + this.getStorageURL().getPath(), e2);
                        this.notifyError("Full backup failed", e2);
                    }
                }
                throw throwable;
            }
            for (Suspendable component : suspendableComponents) {
                try {
                    component.resume();
                }
                catch (ResumeException e2) {
                    log.error("Full backup failed " + this.getStorageURL().getPath(), e2);
                    this.notifyError("Full backup failed", e2);
                }
            }
            {
                break block27;
                catch (RepositoryConfigurationException e) {
                    log.error("Full backup failed " + this.getStorageURL().getPath(), e);
                    this.notifyError("Full backup failed", e);
                    Object var7_12 = null;
                    for (Suspendable component : suspendableComponents) {
                        try {
                            component.resume();
                        }
                        catch (ResumeException e2) {
                            log.error("Full backup failed " + this.getStorageURL().getPath(), e2);
                            this.notifyError("Full backup failed", e2);
                        }
                    }
                    break block27;
                }
                catch (SuspendException e) {
                    log.error("Full backup failed " + this.getStorageURL().getPath(), e);
                    this.notifyError("Full backup failed", e);
                    Object var7_13 = null;
                    for (Suspendable component : suspendableComponents) {
                        try {
                            component.resume();
                        }
                        catch (ResumeException e2) {
                            log.error("Full backup failed " + this.getStorageURL().getPath(), e2);
                            this.notifyError("Full backup failed", e2);
                        }
                    }
                    break block27;
                }
                catch (BackupException e) {
                    log.error("Full backup failed " + this.getStorageURL().getPath(), e);
                    this.notifyError("Full backup failed", e);
                    Object var7_14 = null;
                    for (Suspendable component : suspendableComponents) {
                        try {
                            component.resume();
                        }
                        catch (ResumeException e2) {
                            log.error("Full backup failed " + this.getStorageURL().getPath(), e2);
                            this.notifyError("Full backup failed", e2);
                        }
                    }
                    break block27;
                }
                catch (BackupOperationException e) {
                    log.error("Full backup failed " + this.getStorageURL().getPath(), e);
                    this.notifyError("Full backup failed", e);
                    Object var7_15 = null;
                    for (Suspendable component : suspendableComponents) {
                        try {
                            component.resume();
                        }
                        catch (ResumeException e2) {
                            log.error("Full backup failed " + this.getStorageURL().getPath(), e2);
                            this.notifyError("Full backup failed", e2);
                        }
                    }
                    break block27;
                }
                catch (IOException e) {
                    log.error("Full backup failed " + this.getStorageURL().getPath(), e);
                    this.notifyError("Full backup failed", e);
                    Object var7_16 = null;
                    for (Suspendable component : suspendableComponents) {
                        try {
                            component.resume();
                        }
                        catch (ResumeException e2) {
                            log.error("Full backup failed " + this.getStorageURL().getPath(), e2);
                            this.notifyError("Full backup failed", e2);
                        }
                    }
                }
            }
        }
        this.state = 4;
        this.notifyListeners();
    }

    protected void backupIndex(WorkspaceEntry workspaceEntry) throws RepositoryConfigurationException, BackupOperationException, IOException {
        if (workspaceEntry.getQueryHandler() != null) {
            File srcDir = new File(workspaceEntry.getQueryHandler().getParameterValue("index-dir"));
            if (!PrivilegedFileHelper.exists(srcDir)) {
                throw new BackupOperationException("Can't backup index. Directory " + srcDir.getName() + " doesn't exists");
            }
            File destDir = new File(this.getStorageURL().getFile(), INDEX_DIR);
            this.copyDirectory(srcDir, destDir);
            if (this.repository.getConfiguration().getSystemWorkspaceName().equals(this.workspaceName)) {
                if (!PrivilegedFileHelper.exists(srcDir = new File(PrivilegedFileHelper.getCanonicalPath(srcDir) + "_" + "system"))) {
                    throw new BackupOperationException("Can't backup system index. Directory " + srcDir.getName() + " doesn't exists");
                }
                destDir = new File(this.getStorageURL().getFile(), SYSTEM_INDEX_DIR);
                this.copyDirectory(srcDir, destDir);
            }
        }
    }

    protected void backupValueStorage(WorkspaceEntry workspaceEntry) throws RepositoryConfigurationException, BackupOperationException, IOException {
        if (workspaceEntry.getContainer().getValueStorages() != null) {
            for (ValueStorageEntry valueStorage : workspaceEntry.getContainer().getValueStorages()) {
                File srcDir = new File(valueStorage.getParameterValue("path"));
                if (!PrivilegedFileHelper.exists(srcDir)) {
                    throw new BackupOperationException("Can't backup value storage. Directory " + srcDir.getName() + " doesn't exists");
                }
                File destValuesDir = new File(this.getStorageURL().getFile(), VALUE_STORAGE_DIR);
                File destDir = new File(destValuesDir, valueStorage.getId());
                this.copyDirectory(srcDir, destDir);
            }
        }
    }

    public void stop() {
        log.info("Stop requested " + this.getStorageURL().getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copyDirectory(File srcPath, File dstPath) throws IOException {
        ZipOutputStream out;
        block7: {
            if (PrivilegedFileHelper.isDirectory(srcPath)) {
                if (!PrivilegedFileHelper.exists(dstPath)) {
                    PrivilegedFileHelper.mkdirs(dstPath);
                }
                String[] files = PrivilegedFileHelper.list(srcPath);
                for (int i = 0; i < files.length; ++i) {
                    this.copyDirectory(new File(srcPath, files[i]), new File(dstPath, files[i]));
                }
                return;
            }
            FileInputStream in = null;
            out = null;
            try {
                int len;
                in = PrivilegedFileHelper.fileInputStream(srcPath);
                out = PrivilegedFileHelper.zipOutputStream(dstPath);
                out.putNextEntry(new ZipEntry(srcPath.getName()));
                byte[] buf = new byte[2048];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                Object var8_9 = null;
                if (in == null) break block7;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (in != null) {
                    ((InputStream)in).close();
                }
                if (out == null) throw throwable;
                out.flush();
                out.closeEntry();
                out.close();
                throw throwable;
            }
            ((InputStream)in).close();
        }
        if (out == null) return;
        out.flush();
        out.closeEntry();
        out.close();
    }
}

