/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.impl.rdbms;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipInputStream;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessManager;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.ValueStorageEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.WorkspaceContainerFacade;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.ext.backup.impl.IndexCleanHelper;
import org.exoplatform.services.jcr.ext.backup.impl.ValueStorageCleanHelper;
import org.exoplatform.services.jcr.impl.core.BackupWorkspaceInitializer;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NamespaceRegistryImpl;
import org.exoplatform.services.jcr.impl.core.SessionRegistry;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CacheableWorkspaceDataManager;
import org.exoplatform.services.jcr.impl.storage.jdbc.backup.Backupable;
import org.exoplatform.services.jcr.impl.storage.jdbc.backup.CleanException;
import org.exoplatform.services.jcr.impl.storage.jdbc.backup.RestoreException;
import org.exoplatform.services.jcr.impl.util.io.FileCleanerHolder;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class RdbmsWorkspaceInitializer
extends BackupWorkspaceInitializer {
    protected static final Log log = ExoLogger.getLogger("exo.jcr.component.core.RdbmsWorkspaceInitializer");
    protected final RepositoryService repositoryService;

    public RdbmsWorkspaceInitializer(WorkspaceEntry config, RepositoryEntry repConfig, CacheableWorkspaceDataManager dataManager, NamespaceRegistryImpl namespaceRegistry, LocationFactory locationFactory, NodeTypeManagerImpl nodeTypeManager, ValueFactoryImpl valueFactory, AccessManager accessManager, RepositoryService repositoryService, FileCleanerHolder cleanerHolder) throws RepositoryConfigurationException, PathNotFoundException, RepositoryException {
        super(config, repConfig, dataManager, namespaceRegistry, locationFactory, nodeTypeManager, valueFactory, accessManager, cleanerHolder);
        this.repositoryService = repositoryService;
    }

    public NodeData initWorkspace() throws RepositoryException {
        if (this.isWorkspaceInitialized()) {
            return (NodeData)this.dataManager.getItemData("00exo0jcr0root0uuid0000000000000");
        }
        long start = System.currentTimeMillis();
        try {
            this.fullRdbmsRestore();
        }
        catch (Throwable e) {
            try {
                this.rollback();
            }
            catch (RepositoryConfigurationException e1) {
                log.error("Can't rollback changes", e1);
            }
            catch (CleanException e1) {
                log.error("Can't rollback changes", e1);
            }
            catch (IOException e1) {
                log.error("Can't rollback changes", e1);
            }
            throw new RepositoryException(e);
        }
        NodeData root = (NodeData)this.dataManager.getItemData("00exo0jcr0root0uuid0000000000000");
        log.info("Workspace [" + this.workspaceName + "] restored from storage " + this.restorePath + " in " + (double)(System.currentTimeMillis() - start) * 1.0 / 1000.0 + "sec");
        return root;
    }

    protected void fullRdbmsRestore() throws RepositoryException {
        ManageableRepository repository = null;
        try {
            repository = this.repositoryService.getRepository(this.repositoryEntry.getName());
        }
        catch (RepositoryConfigurationException e) {
            throw new RepositoryException((Throwable)e);
        }
        List backupableComponents = repository.getWorkspaceContainer(this.workspaceName).getComponentInstancesOfType(Backupable.class);
        try {
            for (Backupable component : backupableComponents) {
                component.restore(new File(this.restorePath));
            }
            this.restoreValueStorage();
            this.restoreIndex();
        }
        catch (RestoreException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (RepositoryConfigurationException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected void restoreIndex() throws RepositoryConfigurationException, IOException {
        File indexDir = new File(this.restorePath, "index");
        File systemIndexDir = new File(this.restorePath, "index_system");
        if (this.workspaceEntry.getQueryHandler() != null) {
            if (!PrivilegedFileHelper.exists(indexDir)) {
                throw new RepositoryConfigurationException("Can't restore index. Directory " + indexDir.getName() + " doesn't exists");
            }
            File destDir = new File(this.workspaceEntry.getQueryHandler().getParameterValue("index-dir"));
            this.copyDirectory(indexDir, destDir);
            if (this.repositoryEntry.getSystemWorkspaceName().equals(this.workspaceName)) {
                if (!PrivilegedFileHelper.exists(systemIndexDir)) {
                    throw new RepositoryConfigurationException("Can't restore system index. Directory " + systemIndexDir.getName() + " doesn't exists");
                }
                destDir = new File(this.workspaceEntry.getQueryHandler().getParameterValue("index-dir") + "_" + "system");
                this.copyDirectory(systemIndexDir, destDir);
            } else if (PrivilegedFileHelper.exists(systemIndexDir)) {
                throw new RepositoryConfigurationException("Workspace [" + this.workspaceName + "] is not a system in repository configuration but system index backup files exist");
            }
        } else if (PrivilegedFileHelper.exists(indexDir) || PrivilegedFileHelper.exists(systemIndexDir)) {
            throw new RepositoryConfigurationException("Query handler didn't configure in workspace [" + this.workspaceName + "] configuration but index backup files exist");
        }
    }

    protected void rollback() throws RepositoryException, RepositoryConfigurationException, CleanException, IOException {
        boolean isSystem = this.repositoryService.getRepository(this.repositoryEntry.getName()).getConfiguration().getSystemWorkspaceName().equals(this.workspaceEntry.getName());
        this.forceCloseSession(this.repositoryEntry.getName(), this.workspaceEntry.getName());
        List backupable = this.repositoryService.getRepository(this.repositoryEntry.getName()).getWorkspaceContainer(this.workspaceEntry.getName()).getComponentInstancesOfType(Backupable.class);
        for (Backupable component : backupable) {
            component.getDataCleaner().clean();
        }
        new IndexCleanHelper().removeWorkspaceIndex(this.workspaceEntry, isSystem);
        new ValueStorageCleanHelper().removeWorkspaceValueStorage(this.workspaceEntry);
    }

    private int forceCloseSession(String repositoryName, String workspaceName) throws RepositoryException, RepositoryConfigurationException {
        ManageableRepository mr = this.repositoryService.getRepository(repositoryName);
        WorkspaceContainerFacade wc = mr.getWorkspaceContainer(workspaceName);
        SessionRegistry sessionRegistry = (SessionRegistry)wc.getComponent(SessionRegistry.class);
        return sessionRegistry.closeSessions(workspaceName);
    }

    protected void restoreValueStorage() throws RepositoryConfigurationException, IOException {
        File backupValueStorageDir = new File(this.restorePath, "values");
        if (this.workspaceEntry.getContainer().getValueStorages() != null) {
            ArrayList valueStorages = this.workspaceEntry.getContainer().getValueStorages();
            String[] valueStoragesFiles = PrivilegedFileHelper.list(backupValueStorageDir);
            if (valueStoragesFiles == null && valueStorages.size() != 0 || valueStoragesFiles != null && valueStoragesFiles.length != valueStorages.size()) {
                throw new RepositoryConfigurationException("Workspace configuration [" + this.workspaceName + "] has a different amount of value storages than exist in backup");
            }
            for (ValueStorageEntry valueStorage : valueStorages) {
                File srcDir = new File(backupValueStorageDir, valueStorage.getId());
                if (!PrivilegedFileHelper.exists(srcDir)) {
                    throw new RepositoryConfigurationException("Can't restore value storage. Directory " + srcDir.getName() + " doesn't exists");
                }
                File destDir = new File(valueStorage.getParameterValue("path"));
                this.copyDirectory(srcDir, destDir);
            }
        } else if (PrivilegedFileHelper.exists(backupValueStorageDir)) {
            throw new RepositoryConfigurationException("Value storage didn't configure in workspace [" + this.workspaceName + "] configuration but value storage backup files exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copyDirectory(File srcPath, File dstPath) throws IOException {
        FileOutputStream out;
        block7: {
            if (PrivilegedFileHelper.isDirectory(srcPath)) {
                if (!PrivilegedFileHelper.exists(dstPath)) {
                    PrivilegedFileHelper.mkdirs(dstPath);
                }
                String[] files = PrivilegedFileHelper.list(srcPath);
                for (int i = 0; i < files.length; ++i) {
                    this.copyDirectory(new File(srcPath, files[i]), new File(dstPath, files[i]));
                }
                return;
            }
            ZipInputStream in = null;
            out = null;
            try {
                int len;
                in = PrivilegedFileHelper.zipInputStream(srcPath);
                in.getNextEntry();
                out = PrivilegedFileHelper.fileOutputStream(dstPath);
                byte[] buf = new byte[2048];
                while ((len = in.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                Object var8_9 = null;
                if (in == null) break block7;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (in != null) {
                    in.close();
                }
                if (out == null) throw throwable;
                ((OutputStream)out).close();
                throw throwable;
            }
            in.close();
        }
        if (out == null) return;
        ((OutputStream)out).close();
    }
}

