/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.drives;

import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.exoplatform.ecm.webui.component.admin.drives.UIDriveForm;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.form.validator.DrivePermissionValidator;
import org.exoplatform.ecm.webui.form.validator.ECMNameValidator;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(template="classpath:groovy/ecm/webui/form/UIFormInputSetWithAction.gtmpl")
public class UIDriveInputSet
extends UIFormInputSetWithAction {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_WORKSPACE = "workspace";
    public static final String FIELD_HOMEPATH = "homePath";
    public static final String FIELD_WORKSPACEICON = "icon";
    public static final String FIELD_PERMISSION = "permissions";
    public static final String FIELD_ALLOW_NODETYPES_ON_TREE = "allowNodeTypesOnTree";
    public static final String FIELD_VIEWPREFERENCESDOC = "viewPreferences";
    public static final String FIELD_VIEWNONDOC = "viewNonDocument";
    public static final String FIELD_VIEWSIDEBAR = "viewSideBar";
    public static final String FIELD_FOLDER_ONLY = "Folder";
    public static final String FIELD_BOTH = "Both";
    public static final String FIELD_UNSTRUCTURED_ONLY = "Unstructured folder";
    public static final String FIELD_ALLOW_CREATE_FOLDERS = "allowCreateFolders";
    public static final String SHOW_HIDDEN_NODE = "showHiddenNode";
    public String bothLabel_;
    public String folderOnlyLabel_;
    public String unstructuredFolderLabel_;

    public UIDriveInputSet(String name) throws Exception {
        super(name);
        this.setComponentConfig(((Object)((Object)this)).getClass(), null);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_NAME, FIELD_NAME, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(ECMNameValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_WORKSPACE, FIELD_WORKSPACE, null));
        UIFormStringInput homePathField = new UIFormStringInput(FIELD_HOMEPATH, FIELD_HOMEPATH, null);
        homePathField.setValue((Object)"/");
        homePathField.setEditable(false);
        this.addUIFormInput((UIFormInput)homePathField);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_WORKSPACEICON, FIELD_WORKSPACEICON, null).setEditable(false));
        UIFormStringInput permissonSelectField = new UIFormStringInput(FIELD_PERMISSION, FIELD_PERMISSION, null);
        permissonSelectField.addValidator(MandatoryValidator.class, new Object[0]);
        permissonSelectField.addValidator(DrivePermissionValidator.class, new Object[0]);
        permissonSelectField.setEditable(true);
        this.addUIFormInput((UIFormInput)permissonSelectField);
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(FIELD_VIEWPREFERENCESDOC, FIELD_VIEWPREFERENCESDOC, null));
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(FIELD_VIEWNONDOC, FIELD_VIEWNONDOC, null));
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(FIELD_VIEWSIDEBAR, FIELD_VIEWSIDEBAR, null));
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(SHOW_HIDDEN_NODE, SHOW_HIDDEN_NODE, null));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_ALLOW_CREATE_FOLDERS, FIELD_ALLOW_CREATE_FOLDERS, null));
        UIFormStringInput filterNodeTypes = new UIFormStringInput(FIELD_ALLOW_NODETYPES_ON_TREE, FIELD_ALLOW_NODETYPES_ON_TREE, null);
        this.addUIFormInput((UIFormInput)filterNodeTypes);
        this.setActionInfo(FIELD_ALLOW_NODETYPES_ON_TREE, new String[]{"ChooseNodeType", "RemoveNodeType"});
        this.setActionInfo(FIELD_PERMISSION, new String[]{"AddPermission", "RemovePermission"});
        this.setActionInfo(FIELD_HOMEPATH, new String[]{"AddPath"});
        this.setActionInfo(FIELD_WORKSPACEICON, new String[]{"AddIcon"});
    }

    public void update(DriveData drive) throws Exception {
        String[] wsNames = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getCurrentRepository().getWorkspaceNames();
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        Set setFoldertypes = templateService.getAllowanceFolderType();
        ArrayList<SelectItemOption> workspace = new ArrayList<SelectItemOption>();
        ArrayList<SelectItemOption> foldertypeOptions = new ArrayList<SelectItemOption>();
        for (String wsName : wsNames) {
            workspace.add(new SelectItemOption(wsName, (Object)wsName));
        }
        RequestContext context = RequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        for (String foldertype : setFoldertypes) {
            try {
                foldertypeOptions.add(new SelectItemOption(res.getString(this.getId() + ".label." + foldertype.replace(":", "_")), (Object)foldertype));
            }
            catch (MissingResourceException mre) {
                foldertypeOptions.add(new SelectItemOption(foldertype, (Object)foldertype));
            }
        }
        this.getUIFormSelectBox(FIELD_WORKSPACE).setOptions(workspace);
        this.getUIFormSelectBox(FIELD_ALLOW_CREATE_FOLDERS).setOptions(foldertypeOptions);
        this.getUIFormSelectBox(FIELD_ALLOW_CREATE_FOLDERS).setMultiple(true);
        if (drive != null) {
            UIDriveForm uiDriveForm = (UIDriveForm)this.getAncestorOfType(UIDriveForm.class);
            String selectedWorkspace = drive.getWorkspace();
            String wsInitRootNodeType = uiDriveForm.getWorkspaceEntries(selectedWorkspace);
            this.invokeGetBindingField(drive);
            String foldertypes = drive.getAllowCreateFolders();
            String[] selectedFolderTypes = foldertypes.contains(",") ? foldertypes.split(",") : new String[]{foldertypes};
            ArrayList<SelectItemOption> folderOptions = new ArrayList<SelectItemOption>();
            if (wsInitRootNodeType != null && wsInitRootNodeType.equals("nt:folder")) {
                folderOptions.add(new SelectItemOption(FIELD_FOLDER_ONLY, (Object)"nt:folder"));
            } else {
                folderOptions.addAll(foldertypeOptions);
            }
            this.getUIFormSelectBox(FIELD_ALLOW_CREATE_FOLDERS).setOptions(folderOptions);
            this.getUIFormSelectBox(FIELD_ALLOW_CREATE_FOLDERS).setSelectedValues(selectedFolderTypes);
            this.getUIStringInput(FIELD_NAME).setEditable(false);
            return;
        }
        this.getUIStringInput(FIELD_NAME).setEditable(true);
        this.reset();
        this.getUIFormCheckBoxInput(FIELD_VIEWPREFERENCESDOC).setChecked(false);
        this.getUIFormCheckBoxInput(FIELD_VIEWNONDOC).setChecked(false);
        this.getUIFormCheckBoxInput(FIELD_VIEWSIDEBAR).setChecked(false);
        this.getUIFormCheckBoxInput(SHOW_HIDDEN_NODE).setChecked(false);
    }
}

