/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.templates;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Value;
import javax.portlet.PortletPreferences;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.admin.templates.UITemplateContent;
import org.exoplatform.ecm.webui.component.admin.templates.UITemplatesManager;
import org.exoplatform.ecm.webui.component.admin.templates.UIViewTemplate;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIContainerLifecycle.class, events={@EventConfig(listeners={EditActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UIDialogTab.msg.confirm-delete")})
public class UIDialogTab
extends UIContainer {
    private static final String[] BEAN_FIELD = new String[]{"name", "roles", "baseVersion"};
    private static final String[] ACTIONS = new String[]{"Edit", "Delete"};
    public static final String DIALOG_LIST_NAME = "DialogList";
    public static final String DIALOG_FORM_NAME = "DialogForm";
    private List<String> listDialog_ = new ArrayList<String>();

    public UIDialogTab() throws Exception {
        UIGrid uiGrid = (UIGrid)this.addChild(UIGrid.class, null, DIALOG_LIST_NAME);
        uiGrid.getUIPageIterator().setId("DialogListIterator");
        uiGrid.configure("name", BEAN_FIELD, ACTIONS);
        UITemplateContent uiForm = (UITemplateContent)this.addChild(UITemplateContent.class, null, DIALOG_FORM_NAME);
        uiForm.setTemplateType(TemplateService.DIALOGS);
        uiForm.update(null);
    }

    public List<String> getListDialog() {
        return this.listDialog_;
    }

    public void updateGrid(String nodeName, String repository) throws Exception {
        TemplateService tempService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        NodeIterator iter = tempService.getAllTemplatesOfNodeType(true, nodeName, SessionProviderFactory.createSystemProvider());
        ArrayList<DialogData> data = new ArrayList<DialogData>();
        if (iter == null) {
            return;
        }
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            String version = "";
            StringBuilder rule = new StringBuilder();
            Value[] rules = node.getNode("jcr:content").getProperty("exo:roles").getValues();
            for (int i = 0; i < rules.length; ++i) {
                rule.append("[" + rules[i].getString() + "]");
            }
            if (node.isNodeType("mix:versionable") && !node.isNodeType(Utils.NT_FROZEN)) {
                version = node.getBaseVersion().getName();
            }
            this.listDialog_.add(node.getName());
            DialogData item = new DialogData(node.getName(), rule.toString(), version);
            data.add(item);
        }
        UIGrid uiGrid = (UIGrid)this.getChild(UIGrid.class);
        ListAccessImpl dialogDataList = new ListAccessImpl(DialogData.class, data);
        LazyPageList dataPageList = new LazyPageList((ListAccess)dialogDataList, 4);
        uiGrid.getUIPageIterator().setPageList((PageList)dataPageList);
    }

    public void setTabRendered() {
        UIViewTemplate uiViewTemplate = (UIViewTemplate)this.getAncestorOfType(UIViewTemplate.class);
        uiViewTemplate.setRenderedChild(UIDialogTab.class);
    }

    public static class DialogData {
        private String name;
        private String roles;
        private String baseVersion;

        public DialogData(String name, String roles, String version) {
            this.name = name;
            this.roles = roles;
            this.baseVersion = version;
        }

        public String getName() {
            return this.name;
        }

        public String getRoles() {
            return this.roles;
        }

        public String getBaseVersion() {
            return this.baseVersion;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActionListener
    extends EventListener<UIDialogTab> {
        public void execute(Event<UIDialogTab> event) throws Exception {
            UIDialogTab dialogTab = (UIDialogTab)((Object)event.getSource());
            UIViewTemplate uiViewTemplate = (UIViewTemplate)((UIDialogTab)((Object)event.getSource())).getAncestorOfType(UIViewTemplate.class);
            String nodeTypeName = uiViewTemplate.getNodeTypeName();
            String templateName = event.getRequestContext().getRequestParameter("objectId");
            TemplateService templateService = (TemplateService)dialogTab.getApplicationComponent(TemplateService.class);
            UITemplateContent uiForm = (UITemplateContent)dialogTab.findFirstComponentOfType(UITemplateContent.class);
            for (String template : TemplateService.UNDELETABLE_TEMPLATES) {
                if (!template.equals(templateName)) continue;
                UIApplication app = (UIApplication)dialogTab.getAncestorOfType(UIApplication.class);
                Object[] args = new Object[]{template};
                app.addMessage(new ApplicationMessage("UIDialogTab.msg.undeletable", args));
                dialogTab.setTabRendered();
                return;
            }
            PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
            PortletPreferences portletPref = pcontext.getRequest().getPreferences();
            String repository = portletPref.getValue(Utils.REPOSITORY, "");
            templateService.removeTemplate(TemplateService.DIALOGS, nodeTypeName, templateName);
            uiForm.update(null);
            uiForm.reset();
            dialogTab.updateGrid(nodeTypeName, repository);
            dialogTab.setTabRendered();
            UITemplatesManager uiManager = (UITemplatesManager)dialogTab.getAncestorOfType(UITemplatesManager.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditActionListener
    extends EventListener<UIDialogTab> {
        public void execute(Event<UIDialogTab> event) throws Exception {
            UIDialogTab dialogTab = (UIDialogTab)((Object)event.getSource());
            String dialogName = event.getRequestContext().getRequestParameter("objectId");
            UITemplateContent uiForm = (UITemplateContent)dialogTab.getChild(UITemplateContent.class);
            uiForm.update(dialogName);
            dialogTab.setTabRendered();
            UITemplatesManager uiManager = (UITemplatesManager)dialogTab.getAncestorOfType(UITemplatesManager.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }
}

