/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.queries.impl;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.queries.impl.NewUserConfig;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewUserListener
extends UserEventListener {
    private NewUserConfig config_;
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private RepositoryService repositoryService_;
    private String relativePath_;

    public NewUserListener(RepositoryService repositoryService, NodeHierarchyCreator nodeHierarchyCreator, InitParams params) throws Exception {
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.repositoryService_ = repositoryService;
        this.config_ = (NewUserConfig)params.getObjectParamValues(NewUserConfig.class).get(0);
        this.relativePath_ = params.getValueParam("relativePath").getValue();
    }

    public void preSave(User user, boolean isNew) throws Exception {
        this.initSystemData(user.getUserName());
    }

    private void initSystemData(String userName) throws Exception {
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        Node userNode = this.nodeHierarchyCreator_.getUserNode(sessionProvider, userName);
        Node queriesHome = userNode.getNode(this.relativePath_);
        boolean userFound = false;
        NewUserConfig.User templateConfig = null;
        for (NewUserConfig.User userConfig : this.config_.getUsers()) {
            String currentName = userConfig.getUserName();
            if (this.config_.getTemplate().equals(currentName)) {
                templateConfig = userConfig;
            }
            if (!currentName.equals(userName)) continue;
            List<NewUserConfig.Query> queries = userConfig.getQueries();
            this.importQueries(queriesHome, queries, userNode.getSession().getWorkspace().getName());
            userFound = true;
            break;
        }
        if (!userFound) {
            List<NewUserConfig.Query> queries = templateConfig.getQueries();
            this.importQueries(queriesHome, queries);
        }
    }

    public void importQueries(Node queriesHome, List<NewUserConfig.Query> queries) throws Exception {
        this.importQueries(queriesHome, queries, queriesHome.getSession().getWorkspace().getName());
    }

    public void importQueries(Node queriesHome, List<NewUserConfig.Query> queries, String workspaceName) throws Exception {
        QueryManager manager = this.getSession(workspaceName).getWorkspace().getQueryManager();
        for (NewUserConfig.Query query : queries) {
            String absPath;
            String queryName = query.getQueryName();
            String language = query.getLanguage();
            String statement = query.getQuery();
            Query queryNode = manager.createQuery(statement, language);
            Node node = queryNode.storeAsNode(absPath = queriesHome.getPath() + "/" + queryName);
            if (!node.isNodeType("exo:datetime")) {
                node.addMixin("exo:datetime");
            }
            node.setProperty("exo:dateCreated", (Calendar)new GregorianCalendar());
            node.getSession().save();
        }
    }

    private Session getSession(String workspaceName) throws Exception {
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        return sessionProvider.getSession(workspaceName, this.repositoryService_.getCurrentRepository());
    }
}

