/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.quartz.JobExecutionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WCMCoreUtils {
    private static Log log = ExoLogger.getLogger((String)"wcm.WCMCoreUtils");

    public static <T> T getService(Class<T> clazz) {
        return WCMCoreUtils.getService(clazz, null);
    }

    public static SessionProvider getSystemSessionProvider() {
        SessionProviderService sessionProviderService = WCMCoreUtils.getService(SessionProviderService.class);
        SessionProvider sessionProvider = sessionProviderService.getSystemSessionProvider(null);
        return sessionProvider;
    }

    public static SessionProvider getUserSessionProvider() {
        SessionProviderService sessionProviderService = WCMCoreUtils.getService(SessionProviderService.class);
        SessionProvider sessionProvider = sessionProviderService.getSessionProvider(null);
        return sessionProvider;
    }

    public static <T> T getService(Class<T> clazz, String containerName) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (containerName != null) {
            container = RootContainer.getInstance().getPortalContainer(containerName);
        }
        return clazz.cast(container.getComponentInstanceOfType(clazz));
    }

    public static String getContainerNameFromJobContext(JobExecutionContext context) {
        return context.getJobDetail().getGroup().split(":")[0];
    }

    public static boolean hasPermission(String userId, List<String> permissions, boolean isNeedFullAccess) {
        try {
            OrganizationService organizationService = WCMCoreUtils.getService(OrganizationService.class);
            WCMCoreUtils.startRequest(organizationService);
            Collection memberships = null;
            Membership userMembership2 = null;
            String userMembershipTmp = null;
            int count = 0;
            String permissionTmp = "";
            for (String permission : permissions) {
                if (!permissionTmp.equals(permission)) {
                    count = 0;
                }
                memberships = organizationService.getMembershipHandler().findMembershipsByUser(userId);
                for (Membership userMembership2 : memberships) {
                    if (permission.equals(userMembership2.getUserName())) {
                        return true;
                    }
                    if ("any".equals(permission)) {
                        if (isNeedFullAccess) {
                            if (++count != 4) continue;
                            return true;
                        }
                        return true;
                    }
                    if (permission.startsWith("*") && permission.contains(userMembership2.getGroupId())) {
                        if (isNeedFullAccess) {
                            if (++count != 4) continue;
                            return true;
                        }
                        return true;
                    }
                    userMembershipTmp = userMembership2.getMembershipType() + ":" + userMembership2.getGroupId();
                    if (!permission.equals(userMembershipTmp)) continue;
                    if (isNeedFullAccess) {
                        if (++count != 4) continue;
                        return true;
                    }
                    return true;
                }
                permissionTmp = permission;
            }
            WCMCoreUtils.endRequest(organizationService);
        }
        catch (Exception e) {
            log.error((Object)"hasPermission() failed because of ", (Throwable)e);
        }
        return false;
    }

    public static <T> List<T> getAllElementsOfListAccess(ListAccess<T> listAccess) {
        try {
            return Arrays.asList(listAccess.load(0, listAccess.getSize()));
        }
        catch (Exception e) {
            log.error((Object)"getAllElementsOfListAccess() failed because of ", (Throwable)e);
            return null;
        }
    }

    @Deprecated
    public static ManageableRepository getRepository(String repository) {
        try {
            RepositoryService repositoryService = WCMCoreUtils.getService(RepositoryService.class);
            return repositoryService.getCurrentRepository();
        }
        catch (Exception e) {
            log.error((Object)("getRepository(" + repository + ") failed because of "), (Throwable)e);
            return null;
        }
    }

    public static ManageableRepository getRepository() {
        try {
            RepositoryService repositoryService = WCMCoreUtils.getService(RepositoryService.class);
            return repositoryService.getCurrentRepository();
        }
        catch (Exception e) {
            log.error((Object)"getRepository() failed because of ", (Throwable)e);
            return null;
        }
    }

    public static void startRequest(OrganizationService orgService) throws Exception {
        if (orgService instanceof ComponentRequestLifecycle) {
            ((ComponentRequestLifecycle)orgService).startRequest(ExoContainerContext.getCurrentContainer());
        }
    }

    public static void endRequest(OrganizationService orgService) throws Exception {
        if (orgService instanceof ComponentRequestLifecycle) {
            ((ComponentRequestLifecycle)orgService).endRequest(ExoContainerContext.getCurrentContainer());
        }
    }
}

