/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.search;

import java.util.HashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jcr.Node;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.commons.lang.ArrayUtils;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.publication.WCMComposer;
import org.exoplatform.services.wcm.search.QueryCriteria;
import org.exoplatform.services.wcm.search.ResultNode;
import org.exoplatform.services.wcm.utils.PaginatedNodeIterator;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class PaginatedQueryResult
extends PaginatedNodeIterator {
    protected QueryCriteria queryCriteria;
    protected QueryResult queryResult;
    private boolean isSearchContent;

    public PaginatedQueryResult(int pageSize) {
        super(pageSize);
    }

    public PaginatedQueryResult(QueryResult queryResult, int pageSize, boolean isSearchContent) throws Exception {
        super(pageSize);
        this.nodeIterator = queryResult.getNodes();
        this.isSearchContent = isSearchContent;
        this.setAvailablePage((int)this.nodeIterator.getSize());
        this.queryResult = queryResult;
    }

    protected void populateCurrentPage(int page) throws Exception {
        if (page == this.currentPage_ && this.currentListPage_ != null && !this.currentListPage_.isEmpty()) {
            return;
        }
        this.checkAndSetPosition(page);
        this.currentListPage_ = new CopyOnWriteArrayList();
        int count = 0;
        RowIterator iterator = this.queryResult.getRows();
        while (this.nodeIterator.hasNext()) {
            Node node = this.nodeIterator.nextNode();
            Node viewNode = this.filterNodeToDisplay(node);
            if (viewNode == null) continue;
            long position = this.nodeIterator.getPosition();
            long rowPosition = iterator.getPosition();
            long skipNum = position - rowPosition;
            iterator.skip(skipNum - 1L);
            Row row = iterator.nextRow();
            ResultNode resultNode = new ResultNode(viewNode, row);
            this.currentListPage_.add(resultNode);
            if (++count != this.getPageSize()) continue;
            break;
        }
        this.currentPage_ = page;
    }

    protected Node filterNodeToDisplay(Node node) throws Exception {
        Node displayNode = this.getNodeToCheckState(node);
        if (displayNode == null) {
            return null;
        }
        if (this.isSearchContent) {
            return displayNode;
        }
        NodeLocation nodeLocation = NodeLocation.getNodeLocationByNode((Node)displayNode);
        WCMComposer wcmComposer = (WCMComposer)WCMCoreUtils.getService(WCMComposer.class);
        HashMap<String, String> filters = new HashMap<String, String>();
        filters.put("filter-mode", "Live");
        return wcmComposer.getContent(nodeLocation.getWorkspace(), nodeLocation.getPath(), filters, WCMCoreUtils.getSystemSessionProvider());
    }

    protected Node getNodeToCheckState(Node node) throws Exception {
        String primaryNodeType;
        Object[] contentTypes;
        Node parent;
        Node displayNode = node;
        if (node.getPath().contains("web contents/site artifacts")) {
            return null;
        }
        if (displayNode.isNodeType("nt:resource")) {
            displayNode = node.getParent();
        }
        if (displayNode.isNodeType("exo:htmlFile") && (parent = displayNode.getParent()).isNodeType("exo:webContent")) {
            displayNode = parent;
        }
        if (this.queryCriteria.isSearchWebContent()) {
            if (!this.queryCriteria.isSearchDocument() && !displayNode.isNodeType("exo:webContent")) {
                return null;
            }
            if (this.queryCriteria.isSearchWebpage() && !displayNode.isNodeType("publication:webpagesPublication")) {
                return null;
            }
        } else if (this.queryCriteria.isSearchWebpage()) {
            if (this.queryCriteria.isSearchDocument()) {
                return displayNode;
            }
            if (!displayNode.isNodeType("publication:webpagesPublication")) {
                return null;
            }
        }
        if ((contentTypes = this.queryCriteria.getContentTypes()) != null && contentTypes.length > 0 && !ArrayUtils.contains((Object[])contentTypes, (Object)(primaryNodeType = displayNode.getPrimaryNodeType().getName()))) {
            return null;
        }
        return displayNode;
    }
}

