/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer;

import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.jcr.AccessDeniedException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.definition.PortalContainerConfig;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.ecm.jcr.model.Preference;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentWorkspace;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorerPortlet;
import org.exoplatform.ecm.webui.component.explorer.UIJcrExplorerContainer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.UIActionBar;
import org.exoplatform.ecm.webui.component.explorer.control.UIAddressBar;
import org.exoplatform.ecm.webui.component.explorer.control.UIControl;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIDocumentForm;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIDocumentFormController;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UISideBar;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/explorer/UIDrivesArea.gtmpl", events={@EventConfig(listeners={SelectRepoActionListener.class}), @EventConfig(listeners={SelectDriveActionListener.class})})
public class UIDrivesArea
extends UIContainer {
    public static final String FIELD_SELECTREPO = "selectRepo";
    private String repoName_;
    private boolean firstVisit = true;

    public void setFirstVisit(boolean firstVisit) {
        this.firstVisit = firstVisit;
    }

    public boolean isFirstVisit() {
        return this.firstVisit;
    }

    public String getLabel(String id) {
        RequestContext context = RequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        try {
            return res.getString("Drives.label." + id.replace(" ", ""));
        }
        catch (MissingResourceException ex) {
            return id;
        }
    }

    public String getGroupLabel(String groupId) {
        RequestContext context = RequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        try {
            return res.getString("Drives.label." + groupId.replace(".", ""));
        }
        catch (MissingResourceException ex) {
            return groupId.replace(".", " / ");
        }
    }

    public List<String> getRepositoryList() {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ArrayList<String> repositories = new ArrayList<String>();
        RepositoryEntry re = null;
        try {
            re = repositoryService.getCurrentRepository().getConfiguration();
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        repositories.add(re.getName());
        return repositories;
    }

    public String getPortalName() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
        return containerInfo.getContainerName();
    }

    public String getRestName() {
        PortalContainerConfig portalContainerConfig = (PortalContainerConfig)this.getApplicationComponent(PortalContainerConfig.class);
        return portalContainerConfig.getRestContextName(this.getPortalName());
    }

    public String getRepository() throws Exception {
        if (this.repoName_ == null || this.repoName_.length() == 0) {
            RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
            this.repoName_ = repositoryService.getCurrentRepository().getConfiguration().getName();
        }
        return this.repoName_;
    }

    public void setRepository(String repoName) {
        this.repoName_ = repoName;
    }

    public List<DriveData> mainDrives() throws Exception {
        ManageDriveService driveService = (ManageDriveService)this.getApplicationComponent(ManageDriveService.class);
        List userRoles = org.exoplatform.ecm.webui.utils.Utils.getMemberships();
        String userId = Util.getPortalRequestContext().getRemoteUser();
        return driveService.getMainDrives(userId, userRoles);
    }

    public List<DriveData> groupDrives() throws Exception {
        ManageDriveService driveService = (ManageDriveService)this.getApplicationComponent(ManageDriveService.class);
        List groups = org.exoplatform.ecm.webui.utils.Utils.getGroups();
        List userRoles = org.exoplatform.ecm.webui.utils.Utils.getMemberships();
        String userId = Util.getPortalRequestContext().getRemoteUser();
        return driveService.getGroupDrives(userId, userRoles, groups);
    }

    public List<DriveData> personalDrives() throws Exception {
        ManageDriveService driveService = (ManageDriveService)this.getApplicationComponent(ManageDriveService.class);
        List userRoles = org.exoplatform.ecm.webui.utils.Utils.getMemberships();
        String userId = Util.getPortalRequestContext().getRemoteUser();
        return driveService.getPersonalDrives(userId, userRoles);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectDriveActionListener
    extends EventListener<UIDrivesArea> {
        public void execute(Event<UIDrivesArea> event) throws Exception {
            UIDrivesArea uiDrivesArea = (UIDrivesArea)((Object)event.getSource());
            String driveName = event.getRequestContext().getRequestParameter("objectId");
            RepositoryService rservice = (RepositoryService)uiDrivesArea.getApplicationComponent(RepositoryService.class);
            String repoName = uiDrivesArea.getRepository();
            ManageDriveService dservice = (ManageDriveService)uiDrivesArea.getApplicationComponent(ManageDriveService.class);
            DriveData drive = dservice.getDriveByName(driveName);
            String userId = Util.getPortalRequestContext().getRemoteUser();
            UIApplication uiApp = (UIApplication)uiDrivesArea.getAncestorOfType(UIApplication.class);
            ArrayList<String> viewList = new ArrayList<String>();
            for (String role : org.exoplatform.ecm.webui.utils.Utils.getMemberships()) {
                for (String viewName : drive.getViews().split(",")) {
                    if (viewList.contains(viewName.trim())) continue;
                    Node viewNode = ((ManageViewService)uiDrivesArea.getApplicationComponent(ManageViewService.class)).getViewByName(viewName.trim(), SessionProviderFactory.createSystemProvider());
                    String permiss = viewNode.getProperty("exo:accessPermissions").getString();
                    if (permiss.contains("${userId}")) {
                        permiss = permiss.replace("${userId}", userId);
                    }
                    String[] viewPermissions = permiss.split(",");
                    if (permiss.equals("*")) {
                        viewList.add(viewName.trim());
                    }
                    if (!drive.hasPermission(viewPermissions, role)) continue;
                    viewList.add(viewName.trim());
                }
            }
            if (viewList.isEmpty()) {
                Object[] args = new Object[]{driveName};
                uiApp.addMessage(new ApplicationMessage("UIDrivesBrowser.msg.no-view-found", args));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            String viewListStr = "";
            for (String viewName : viewList) {
                if (viewListStr.length() > 0) {
                    viewListStr = viewListStr + "," + viewName;
                    continue;
                }
                viewListStr = viewName;
            }
            drive.setViews(viewListStr);
            String homePath = drive.getHomePath();
            if (homePath.contains("${userId}")) {
                homePath = Utils.getPersonalDrivePath((String)homePath, (String)userId);
            }
            UIJCRExplorerPortlet uiParent = (UIJCRExplorerPortlet)uiDrivesArea.getAncestorOfType(UIJCRExplorerPortlet.class);
            uiParent.setFlagSelect(true);
            UIJcrExplorerContainer explorerContainer = (UIJcrExplorerContainer)uiParent.getChild(UIJcrExplorerContainer.class);
            UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)explorerContainer.getChild(UIJCRExplorer.class);
            Preference pref = uiJCRExplorer.getPreference();
            pref.setShowSideBar(drive.getViewSideBar());
            pref.setShowNonDocumentType(drive.getViewNonDocument());
            pref.setShowPreferenceDocuments(drive.getViewPreferences());
            pref.setAllowCreateFoder(drive.getAllowCreateFolders());
            pref.setShowHiddenNode(drive.getShowHiddenNode());
            uiJCRExplorer.setDriveData(drive);
            uiJCRExplorer.setIsReferenceNode(false);
            uiJCRExplorer.setPreferencesSaved(true);
            SessionProvider provider = SessionProviderFactory.createSessionProvider();
            ManageableRepository repository = rservice.getCurrentRepository();
            try {
                Session session = provider.getSession(drive.getWorkspace(), repository);
                session.getItem(homePath);
            }
            catch (AccessDeniedException ace) {
                Object[] args = new Object[]{driveName};
                uiApp.addMessage(new ApplicationMessage("UIDrivesBrowser.msg.access-denied", args, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (NoSuchWorkspaceException nosuchWS) {
                Object[] args = new Object[]{driveName};
                uiApp.addMessage(new ApplicationMessage("UIDrivesBrowser.msg.workspace-not-exist", args, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
            uiJCRExplorer.clearNodeHistory(homePath);
            uiJCRExplorer.setRepositoryName(repoName);
            uiJCRExplorer.setWorkspaceName(drive.getWorkspace());
            uiJCRExplorer.setRootPath(homePath);
            uiJCRExplorer.setSelectNode(drive.getWorkspace(), homePath);
            uiJCRExplorer.refreshExplorer();
            String selectedView = (String)viewList.get(0);
            UIControl uiControl = (UIControl)((UIControl)uiJCRExplorer.getChild(UIControl.class)).setRendered(true);
            UIActionBar uiActionbar = (UIActionBar)uiControl.getChild(UIActionBar.class);
            uiActionbar.setTabOptions(selectedView);
            UIAddressBar uiAddressBar = (UIAddressBar)uiControl.getChild(UIAddressBar.class);
            uiAddressBar.setViewList(viewList);
            uiAddressBar.setSelectedViewName(selectedView);
            explorerContainer.setRenderedChild(UIJCRExplorer.class);
            UIWorkingArea uiWorkingArea = (UIWorkingArea)uiJCRExplorer.getChild(UIWorkingArea.class);
            ((UISideBar)uiWorkingArea.getChild(UISideBar.class)).initialize();
            for (UIComponent uiComp : uiWorkingArea.getChildren()) {
                if (uiComp instanceof UIDrivesArea) {
                    uiComp.setRendered(false);
                    continue;
                }
                uiComp.setRendered(true);
            }
            UIDocumentWorkspace uiDocumentWorkspace = (UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class);
            UIDocumentFormController controller = (UIDocumentFormController)uiDocumentWorkspace.removeChild(UIDocumentFormController.class);
            if (controller != null) {
                ((UIDocumentForm)controller.getChild(UIDocumentForm.class)).releaseLock();
            }
            uiParent.setRenderedChild(UIJcrExplorerContainer.class);
            uiJCRExplorer.updateAjax(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectRepoActionListener
    extends EventListener<UIDrivesArea> {
        public void execute(Event<UIDrivesArea> event) throws Exception {
            String repoName = event.getRequestContext().getRequestParameter("objectId");
            UIDrivesArea uiDrivesArea = (UIDrivesArea)((Object)event.getSource());
            uiDrivesArea.setRepository(repoName);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiDrivesArea);
        }
    }
}

